﻿#pragma once 

using namespace System;
using namespace System::Windows::Forms;
using namespace System::Collections;
using namespace System::IO;
using namespace System::Drawing;
using namespace System::Drawing::Printing;

ref class ScribbleDoc;

ref class MainWindow: public Form
{
public:
   static MainWindow^ parentWindow;
   MainWindow();
   virtual ~MainWindow();
   static int documentCount; // 跟踪文档计数的静态变量

   // 这用于窗体视图的显示
   void DisableItems();
   void EnableItems();

private:
   void InitializeComponent();
   void MenuItemHandler( Object^ sender, EventArgs^ e );
   void ToolbarHandler( Object^ sender, ToolBarButtonClickEventArgs^ e );
   void AboutHelp();

   //帮助主题
   void HelpTopics();

   //InitComponent 的倒数第 2 行
   //printDocument1.AddOnPrintPage (new PrintPageEventHandler (ScribblePrintPage);
   //CreateDocument();
   //打印
   void Print();

   //PrintPage 事件处理程序
   void ScribblePrintPage( Object^ sender, PrintPageEventArgs^ ev );

   //打印预览
   void PrintPreview();

   //退出
   void Exit();

   //关闭视图
   void CloseView();

   //平铺
   void Tile();

   //层叠
   void Cascade();

   //清除内容
   void ClearAll();

   //打开现有文档
   void Open();

   //保存文档
   void Save();

   //打开新文档
   void New();

   //新窗口
   void NewWindow();

   //粗线
   void ThickLine();

   //笔宽
   void PenWidthsDlg();

   //创建新文档
   ScribbleDoc^ CreateDocument();
   System::ComponentModel::Container^ components;
   PrintDocument^ printDoc;
   HelpProvider^ helpProvider1;
   Windows::Forms::MenuItem^ fileMenuItem;
   Windows::Forms::MenuItem^ editMenuItem;
   Windows::Forms::MenuItem^ viewMenuItem;
   Windows::Forms::MenuItem^ penMenuItem;
   Windows::Forms::MenuItem^ helpMenuItem;
   Windows::Forms::MenuItem^ windowMenuItem;
   Windows::Forms::MenuItem^ newMenuItem;
   Windows::Forms::MenuItem^ openMenuItem;
   Windows::Forms::MenuItem^ closeMenuItem;
   Windows::Forms::MenuItem^ saveMenuItem;
   Windows::Forms::MenuItem^ saveAsMenuItem;
   Windows::Forms::MenuItem^ printMenuItem;
   Windows::Forms::MenuItem^ printPreviewMenuItem;
   Windows::Forms::MenuItem^ exitMenuItem;
   Windows::Forms::MenuItem^ thickLineMenuItem;
   Windows::Forms::MenuItem^ newWindowMenuItem;
   Windows::Forms::MenuItem^ cascadeMenuItem;
   Windows::Forms::MenuItem^ tileMenuItem;
   Windows::Forms::MenuItem^ clearAllMenuItem;
   Windows::Forms::MenuItem^ toolbarMenuItem;
   Windows::Forms::MenuItem^ statusbarMenuItem;
   Windows::Forms::MenuItem^ helpAboutMenuItem;
   Windows::Forms::MenuItem^ helpTopicsMenuItem;
   Windows::Forms::MenuItem^ helpUnmanagedStringMenuItem;
   Windows::Forms::MenuItem^ penWidthMenuItem;
   Windows::Forms::MenuItem^ line1MenuItem;
   Windows::Forms::MenuItem^ line2MenuItem;
   Windows::Forms::MenuItem^ line3MenuItem;

   //工具栏
   Windows::Forms::ToolBar^ toolBar1;
   Windows::Forms::StatusBar^ statusBar1;
   Windows::Forms::ImageList^ imageList1;
   Windows::Forms::ToolBarButton^ helpButton;
   Windows::Forms::ToolBarButton^ printButton;
   Windows::Forms::ToolBarButton^ previewButton;
   Windows::Forms::ToolBarButton^ saveButton;
   Windows::Forms::ToolBarButton^ openButton;
   Windows::Forms::ToolBarButton^ newButton;
   Windows::Forms::MainMenu^ mainMenu;
};

