﻿// ScribbleWSClass.h

#pragma once

using namespace System;
using namespace System::Web;
using namespace System::Web::Services;
using namespace System::Xml::Serialization;
using namespace System::Drawing;
using namespace cli;


namespace ScribbleWS
{
	[XmlRoot("Shape", IsNullable=false)]
	public ref class Shape {
	public:
		[XmlAttribute("Name")]
		System::String^ name;

		[XmlArray("Points", IsNullable=false)]
		[XmlArrayItem("Point", IsNullable=false)]
		array<Point>^ points;

	public:
		Shape(void);
		Shape(String^ n);

		static Shape^ CreateRectangle(int width, int height);
		static Shape^ CreateCircle(int radius);
	};


    public ref class ScribbleWSClass : public System::Web::Services::WebService {
        
    public:
		ScribbleWSClass()
		{
			InitializeComponent();
		}
	protected:
		~ScribbleWSClass()
		{
			if (components)
			{
				delete components;
			}
		}

	private:
		/// <summary>
		///必需的设计器变量。
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		///设计器支持所需的方法 - 请勿
		///使用代码编辑器修改此方法的内容。
		/// </summary>
		void InitializeComponent()
		{
		}	
#pragma endregion

		// WEB 服务方法

	public:
        [System::Web::Services::WebMethod] 
        Shape ^GetRectangle(int width, int height);

        [System::Web::Services::WebMethod] 
        Shape ^GetCircle(int radius);
	};

}