﻿// ScribItm.cpp: CScribbleItem 类的实现
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
//参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。

#include "stdafx.h"
#include "Scribble.h"

#include "ScribDoc.h"
#include "ScribItm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScribbleItem 实现

IMPLEMENT_DYNAMIC(CScribbleItem, COleServerItem)

CScribbleItem::CScribbleItem(CScribbleDoc* pContainerDoc)
	: COleServerItem(pContainerDoc, TRUE)
{
	// TODO: 在此添加一次性构造代码
	//(例如，向项的数据源添加更多剪贴板格式)
}

CScribbleItem::~CScribbleItem()
{
	// TODO: 在此处添加清理代码
}

void CScribbleItem::Serialize(CArchive& ar)
{
	//如果项被复制到剪贴板，
	//框架则会调用 CScribbleItem::Serialize。这可以
	//通过 OLE 回调 OnGetClipboardData 自动执行。对于
	//嵌入项，最好默认直接委托给文档的 Serialize 函数。
	//如果支持链接，则只需序列化
	//文档的一部分。

	if (!IsLinkedItem())
	{
		CScribbleDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->Serialize(ar);
	}
}

BOOL CScribbleItem::OnGetExtent(DVASPECT dwDrawAspect, CSize& rSize)
{
	//与此类似的大多数应用程序只对项的内容
	//方面进行处理。如果希望支持其他方面，如
	//DVASPECT_THUMBNAIL(通过重写 OnDrawEx)，则应修改
	//OnGetExtent 的此实现以处理
	//其他方面。

	if (dwDrawAspect != DVASPECT_CONTENT)
		return COleServerItem::OnGetExtent(dwDrawAspect, rSize);

	//调用 CScribbleItem::OnGetExtent 以获取整个项的
	//以 HIMETRIC 单位表示的范围。此处的默认实现
	//只返回单位的硬编码数。

	CScribbleDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	rSize = pDoc->GetDocSize();
	CClientDC dc(NULL);

        //使用基于逻辑单位的映射模式
	//(我们不能使用 MM_LOENGLISH，因为 MM_LOENGLISH 使用物理英寸)
	dc.SetMapMode(MM_ANISOTROPIC);
	dc.SetViewportExt(dc.GetDeviceCaps(LOGPIXELSX), dc.GetDeviceCaps(LOGPIXELSY));
	dc.SetWindowExt(100, -100);
	dc.LPtoHIMETRIC(&rSize);

	return TRUE;
}

BOOL CScribbleItem::OnDraw(CDC* pDC, CSize& /* rSize */)
{
	CScribbleDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDC->SetMapMode(MM_ANISOTROPIC);
	CSize sizeDoc = pDoc->GetDocSize();
	sizeDoc.cy = -sizeDoc.cy;
	pDC->SetWindowOrg(0,0);
	pDC->SetWindowExt(sizeDoc);

	CTypedPtrList<CObList,CStroke*>& strokeList = pDoc->m_strokeList;
	POSITION pos = strokeList.GetHeadPosition();
	while (pos != NULL)
	{
		strokeList.GetNext(pos)->DrawStroke(pDC);
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CScribbleItem 诊断

#ifdef _DEBUG
void CScribbleItem::AssertValid() const
{
	COleServerItem::AssertValid();
}

void CScribbleItem::Dump(CDumpContext& dc) const
{
	COleServerItem::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////
