﻿#pragma once
// ScribDoc.h: CScribbleDoc 类的接口
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
//参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。
/////////////////////////////////////////////////////////////////////////////


//数据结构类的前向声明
class CScribbleItem;

/////////////////////////////////////////////////////////////////////////////
//类 CStroke
//
//笔画是随意画图中一系列相连的点。
//一个随意画图文档可以包含多个笔画。

class CStroke : public CObject
{
public:
	CStroke(UINT nPenWidth, UINT penColor);

protected:
	CStroke();
	DECLARE_SERIAL(CStroke)

//属性
protected:
	UINT                   m_nPenWidth;    //一个钢笔宽度适用于整个笔画
	UINT				   m_penColor;     //笔画的钢笔颜色
public:
	CArray<CPoint,CPoint>  m_pointArray;   //一系列相连的点
	CRect               m_rectBounding; //围绕笔画中所有点的
										//最小矩形
										//度量单位为 MM_LOENGLISH
										//(0.01 英寸，Y 轴反向)
public:
	CRect& GetBoundingRect() { return m_rectBounding; }

//操作
public:
	BOOL DrawStroke(CDC* pDC);
	void FinishStroke();

public:
	virtual void Serialize(CArchive& ar);
};



class CScribbleDoc : public COleServerDoc
{
protected: //仅从序列化创建
	CScribbleDoc();
	DECLARE_DYNCREATE(CScribbleDoc)

//属性
protected:
	//此文档为所有视图跟踪
	//当前钢笔宽度。我们希望随意画图具有
	//这样的用户界面，当用户选择“Draw
	//Thick Line”(绘制粗线条)命令时，它将应用于所有视图，而不仅仅是
	//当前具有焦点的视图

	UINT            m_nPenWidth;        //用户当前选定的钢笔宽度
	BOOL            m_bThickPen;        //如果当前钢笔为粗钢笔，则为 TRUE
	UINT            m_nThinWidth;
	UINT            m_nThickWidth;
	CPen            m_penCur;           //根据用户选择的钢笔样式
										//(宽度)创建的钢笔
public:
	CTypedPtrList<CObList,CStroke*>     m_strokeList;   
	CPen*           GetCurrentPen() { return &m_penCur; }
	void			SetPenColor(COLORREF c);
	COLORREF		GetPenColor() { return m_penColor; }
protected:
	CSize           m_sizeDoc;
	UINT			m_penColor; 
public:
	CSize GetDocSize() { return m_sizeDoc; }
	CScribbleItem* GetEmbeddedItem()
		{ return (CScribbleItem*)COleServerDoc::GetEmbeddedItem(); }

//操作
public:
	CStroke* NewStroke();

//重写
	// ClassWizard 生成的虚函数重写
	//{{AFX_VIRTUAL(CScribbleDoc)
	protected:
	virtual COleServerItem* OnGetEmbeddedItem();
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void DeleteContents();
	//}}AFX_VIRTUAL

//实现
protected:
	void ReplacePen();
	void OnSetItemRects(LPCRECT lpPosRect, LPCRECT lpClipRect);

public:
	virtual ~CScribbleDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void            InitDocument();

//生成的消息映射函数
protected:
	//{{AFX_MSG(CScribbleDoc)
	afx_msg void OnEditClearAll();
	afx_msg void OnPenThickOrThin();
	afx_msg void OnUpdateEditClearAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePenThickOrThin(CCmdUI* pCmdUI);
	afx_msg void OnPenWidths();
	afx_msg void OnEditCopy();
	afx_msg void OnSelectPlugin(UINT menuID);
	afx_msg void OnUpdatePlugin(CCmdUI* pCmdUI);
	afx_msg void OnSelectWebServiceAddRec();
	afx_msg void OnUpdateWebServiceAddRec(CCmdUI* pCmdUI);
	afx_msg void OnSelectWebServiceAddCir();
	afx_msg void OnUpdateWebServiceAddCir(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

