﻿// ScribDoc.cpp: CScribbleDoc 类的实现
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
//参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。

#include "stdafx.h"
#include "Scribble.h"

#include "ScribDoc.h"
#include "ScribItm.h"
#include "PenDlg.h"
#include "ScribVw.h"
#include "ShapeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScribbleDoc

IMPLEMENT_DYNCREATE(CScribbleDoc, COleServerDoc)

BEGIN_MESSAGE_MAP(CScribbleDoc, COleServerDoc)
	//{{AFX_MSG_MAP(CScribbleDoc)
	ON_COMMAND(ID_EDIT_CLEAR_ALL, OnEditClearAll)
	ON_COMMAND(ID_PEN_THICK_OR_THIN, OnPenThickOrThin)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR_ALL, OnUpdateEditClearAll)
	ON_UPDATE_COMMAND_UI(ID_PEN_THICK_OR_THIN, OnUpdatePenThickOrThin)
	ON_COMMAND(ID_PEN_WIDTHS, OnPenWidths)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
	ON_COMMAND_RANGE(ID_PLUGIN_MENU_START, ID_PLUGIN_MENU_END, OnSelectPlugin)
	ON_UPDATE_COMMAND_UI_RANGE(ID_PLUGIN_MENU_START, ID_PLUGIN_MENU_END, OnUpdatePlugin)
	ON_COMMAND(ID_WEBSERVICE_ADDSHAPE_REC, OnSelectWebServiceAddRec)
	ON_UPDATE_COMMAND_UI(ID_WEBSERVICE_ADDSHAPE_REC, OnUpdateWebServiceAddRec)
	ON_COMMAND(ID_WEBSERVICE_ADDSHAPE_CIR, OnSelectWebServiceAddCir)
	ON_UPDATE_COMMAND_UI(ID_WEBSERVICE_ADDSHAPE_CIR, OnUpdateWebServiceAddCir)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScribbleDoc 构造/析构

CScribbleDoc::CScribbleDoc()
{
	//使用 OLE 复合文件
	EnableCompoundFile();

	m_sizeDoc = CSize(200, 200);
	m_penColor = RGB(0,0,0);
}

CScribbleDoc::~CScribbleDoc()
{
}

BOOL CScribbleDoc::OnNewDocument()
{
	if (!COleServerDoc::OnNewDocument())
		return FALSE;
	InitDocument();
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CScribbleDoc 序列化

void CScribbleDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		ar << m_sizeDoc;
		ar << m_penColor;
	}
	else
	{
		ar >> m_sizeDoc;
		ar >> m_penColor;
	}
	m_strokeList.Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CScribbleDoc 诊断

#ifdef _DEBUG
void CScribbleDoc::AssertValid() const
{
	COleServerDoc::AssertValid();
}

void CScribbleDoc::Dump(CDumpContext& dc) const
{
	COleServerDoc::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScribbleDoc 命令

BOOL CScribbleDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!COleServerDoc::OnOpenDocument(lpszPathName))
		return FALSE;
	InitDocument(); 
	return TRUE;
}

void CScribbleDoc::DeleteContents() 
{
	while (!m_strokeList.IsEmpty())
	{
		delete m_strokeList.RemoveHead();
	}
	COleServerDoc::DeleteContents();
}

void CScribbleDoc::InitDocument()
{
	m_bThickPen = FALSE;
	m_nThinWidth = 2;   //默认细钢笔宽度为 2 个像素
	m_nThickWidth = 5;  //默认粗钢笔宽度为 5 个像素
	ReplacePen();       //根据当前宽度初始化钢笔

	//默认文档大小为 2 x 2 英寸
	m_sizeDoc = CSize(200,200);
}

CStroke* CScribbleDoc::NewStroke()
{
	CStroke* pStrokeItem = new CStroke(m_nPenWidth, m_penColor);
	m_strokeList.AddTail(pStrokeItem);
	SetModifiedFlag();  //将文档标记为已修改，用于
						//确认文件关闭。
	return pStrokeItem;
}




/////////////////////////////////////////////////////////////////////////////
// CStroke

IMPLEMENT_SERIAL(CStroke, CObject, 2)
CStroke::CStroke()
{
	//此空构造函数应仅供序列化使用
}

CStroke::CStroke(UINT nPenWidth, UINT penColor)
{
	m_nPenWidth = nPenWidth;
	m_penColor = penColor;
	m_rectBounding.SetRectEmpty();
}

void CStroke::Serialize(CArchive& ar)
{
	RGB(0, 0, 0);

	if (ar.IsStoring())
	{
		ar << m_rectBounding;
		ar << (WORD)m_nPenWidth;
		ar << m_penColor;
		m_pointArray.Serialize(ar);
	}
	else
	{
		ar >> m_rectBounding;
		WORD w;
		ar >> w;
		m_nPenWidth = w;
		ar >> m_penColor;
		m_pointArray.Serialize(ar);
	}
}

BOOL CStroke::DrawStroke(CDC* pDC)
{
	CPen penStroke;
	if (!penStroke.CreatePen(PS_SOLID, m_nPenWidth, m_penColor))
		return FALSE;
	CPen* pOldPen = pDC->SelectObject(&penStroke);
	pDC->MoveTo(m_pointArray[0]);
	for (int i=1; i < m_pointArray.GetSize(); i++)
	{
		pDC->LineTo(m_pointArray[i]);
	}

	pDC->SelectObject(pOldPen);
	return TRUE;
}

void CScribbleDoc::OnEditClearAll() 
{
	DeleteContents();
	SetModifiedFlag();  //将文档标记为已修改，用于
						//确认文件关闭。
	UpdateAllViews(NULL);
}

void CScribbleDoc::OnPenThickOrThin() 
{
	//在钢笔的粗细状态之间切换。
	m_bThickPen = !m_bThickPen;

	//更改当前钢笔以反映用户指定的新宽度。
	ReplacePen();
}

void CScribbleDoc::ReplacePen()
{
	m_nPenWidth = m_bThickPen? m_nThickWidth : m_nThinWidth;

	//更改当前钢笔以反映用户指定的新宽度。
	m_penCur.DeleteObject();
	m_penCur.CreatePen(PS_SOLID, m_nPenWidth, m_penColor); //纯黑色
}

void CScribbleDoc::SetPenColor(COLORREF c)
{
	m_penColor = c;

	m_penCur.DeleteObject();
	m_penCur.CreatePen(PS_SOLID, m_nPenWidth, m_penColor);
}

void CScribbleDoc::OnUpdateEditClearAll(CCmdUI* pCmdUI) 
{
	//如果文档非空，即至少有一个笔画，
	//则启用命令用户界面对象(菜单项或工具栏按钮)。
	pCmdUI->Enable(!m_strokeList.IsEmpty());
}

void CScribbleDoc::OnUpdatePenThickOrThin(CCmdUI* pCmdUI) 
{
	//如果当前钢笔宽度为“粗”，
	//则向“Draw Thick Line”(绘制粗线条)菜单项添加选中标记。
	pCmdUI->SetCheck(m_bThickPen);
}

void CScribbleDoc::OnPenWidths() 
{
	CPenWidthsDlg dlg;
	//初始化对话框数据
	dlg.m_nThinWidth = m_nThinWidth;
	dlg.m_nThickWidth = m_nThickWidth;

	//调用对话框
	if (dlg.DoModal() == IDOK)
	{
		//检索对话框数据
		m_nThinWidth = dlg.m_nThinWidth;
		m_nThickWidth = dlg.m_nThickWidth;

		//绘制新笔画时更新视图使用的钢笔，
		//以反映新钢笔的“粗”和“细”宽度定义。
		ReplacePen();
	}
}

void CStroke::FinishStroke()
{
	//计算边框。在进行智能重新绘制时
	//需要使用它。

	if (m_pointArray.GetSize()==0)
	{
		m_rectBounding.SetRectEmpty();
		return;
	}
	CPoint pt = m_pointArray[0];
	m_rectBounding = CRect(pt.x, pt.y, pt.x, pt.y);

	for (int i=1; i < m_pointArray.GetSize(); i++)
	{
		//如果点位于累积的边框外部，
		//则扩大此边框以将其包括在内。
		pt = m_pointArray[i];
		m_rectBounding.left     = min(m_rectBounding.left, pt.x);
		m_rectBounding.right    = max(m_rectBounding.right, pt.x);
		m_rectBounding.top      = max(m_rectBounding.top, pt.y);
		m_rectBounding.bottom   = min(m_rectBounding.bottom, pt.y);
	}

	//将钢笔宽度添加到边框。这对于
	//在使屏幕无效时计算笔画宽度
	//是必需的。
	m_rectBounding.InflateRect(CSize(m_nPenWidth, -(int)m_nPenWidth));
	return;
}

COleServerItem* CScribbleDoc::OnGetEmbeddedItem()
{
	//OnGetEmbeddedItem 由框架调用以获取与该文档关联的 COleServerItem。
	//只在必要时才调用它。

	CScribbleItem* pItem = new CScribbleItem(this);
	ASSERT_VALID(pItem);
	return pItem;
}

void CScribbleDoc::OnSetItemRects(LPCRECT lpPosRect, LPCRECT lpClipRect)
{
	//调用基类以更改窗口大小
	COleServerDoc::OnSetItemRects(lpPosRect, lpClipRect);

	//通知第一个应更改滚动信息的视图
	POSITION pos = GetFirstViewPosition();
	CScribbleView* pView = (CScribbleView*)GetNextView(pos);
	pView->ResyncScrollSizes();
}

void CScribbleDoc::OnEditCopy()
{
	CScribbleItem* pItem = GetEmbeddedItem();
	pItem->CopyToClipboard(TRUE);
}

void CScribbleDoc::OnSelectPlugin(UINT menuID)
{
	CScribbleApp * scribApp = (CScribbleApp *)::AfxGetApp();

	scribApp->ExecutePlugin(this, menuID);
}

void CScribbleDoc::OnUpdatePlugin(CCmdUI* pCmdUI)
{
	if (pCmdUI)
	{
		// TODO: 添加插件菜单用户界面更新代码
	}
}


void CScribbleDoc::OnSelectWebServiceAddRec()
{
	//矩形信息对话框
	CRecInfoDlg dlg;

	//调用对话框
	if (dlg.DoModal() == IDOK)
	{
		CScribbleApp * scribApp = (CScribbleApp *)::AfxGetApp();
		scribApp->AddRectangle(this, dlg.m_posX, dlg.m_posY, dlg.m_width, dlg.m_height);
	}
}

void CScribbleDoc::OnUpdateWebServiceAddRec(CCmdUI* pCmdUI)
{
	if (pCmdUI) 
	{
		// TODO: 添加插件菜单用户界面更新代码
	}
}


void CScribbleDoc::OnSelectWebServiceAddCir()
{
	//矩形信息对话框
	CCircleInfoDlg dlg;

	//调用对话框
	if (dlg.DoModal() == IDOK)
	{
		CScribbleApp * scribApp = (CScribbleApp *)::AfxGetApp();
		scribApp->AddCircle(this, dlg.m_posX, dlg.m_posY, dlg.m_radius);
	}
}

void CScribbleDoc::OnUpdateWebServiceAddCir(CCmdUI* pCmdUI)
{
	if (pCmdUI)
	{
		// TODO: 添加插件菜单用户界面更新代码
	}
}
