﻿// Scribble.cpp: 定义应用程序的类行为。
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
//参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。

#include "stdafx.h"
#include "Scribble.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "IpFrame.h"
#include "ScribDoc.h"
#include "ScribVw.h"
#include "PluginBld.h"
#include "WebService.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//静态全局函数
#ifdef _MANAGED
static char * ManagedStr2CStr(String ^ str)
{
	pin_ptr<const wchar_t> pwc = PtrToStringChars(str);
	size_t nChars = str->Length + 1;
	char* pc = new char[nChars];
	size_t sizeInBytes = nChars * sizeof(pc[0]);
	size_t nConvertedChars;
	wcstombs_s(&nConvertedChars, pc, sizeInBytes, pwc, sizeInBytes);

	return pc;
}
#endif

/////////////////////////////////////////////////////////////////////////////
// CScribbleApp

BEGIN_MESSAGE_MAP(CScribbleApp, CWinApp)
	//{{AFX_MSG_MAP(CScribbleApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		//注意 - ClassWizard 将在此处添加和移除映射宏。
		//不要编辑这些生成的代码块中的内容!
	//}}AFX_MSG_MAP
	//基于文件的标准文档命令
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	//标准打印设置命令
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScribbleApp 构造

CScribbleApp::CScribbleApp()
{
	// TODO: 在此处添加构造代码，
	//将所有重要的初始化放置在 InitInstance 中
	EnableHtmlHelp();
#ifdef _MANAGED
	m_pluginMap = gcnew Dictionary<UINT, IScribblePlugin ^>();
	m_webService = gcnew ScribbleWSClass();
#endif
}

/////////////////////////////////////////////////////////////////////////////
//唯一的 CScribbleApp 对象

CScribbleApp theApp;

//生成的此标识符在统计上对于您的应用程序是唯一的。
//如果您更愿选择一个特定的标识符，则可以更改它。

// {7559FD90-9B93-11CE-B0F0-00AA006C28B3}
static const CLSID clsid =
{ 0x7559fd90, 0x9b93, 0x11ce, { 0xb0, 0xf0, 0x0, 0xaa, 0x0, 0x6c, 0x28, 0xb3 } };

/////////////////////////////////////////////////////////////////////////////
// CScribbleApp 初始化

BOOL CScribbleApp::InitInstance()
{
	//初始化 OLE 库
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	//标准初始化
	//如果未使用这些功能并希望减小
	//最终可执行文件的大小，则应从下列内容中移除
	//不需要的特定初始化例程。

	LoadStdProfileSettings();  //加载标准 INI 文件选项(包括 MRU)

	
	//注册应用程序的文档模板。文档模板
	//用作文档、框架窗口和视图之间的连接。

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_SCRIBBTYPE,
		RUNTIME_CLASS(CScribbleDoc),
		RUNTIME_CLASS(CChildFrame), //自定义 MDI 子框架
		RUNTIME_CLASS(CScribbleView));

	pDocTemplate->SetServerInfo(
		IDR_SCRIBBTYPE_SRVR_EMB, IDR_SCRIBBTYPE_SRVR_IP,
		RUNTIME_CLASS(CInPlaceFrame));

	AddDocTemplate(pDocTemplate);
	//将 COleTemplateServer 连接到文档模板。
	//COleTemplateServer 通过使用
	//文档模板中指定的信息为请求 OLE 容器
	//创建新文档。
	m_server.ConnectTemplate(clsid, pDocTemplate, FALSE);

	//将所有 OLE 服务器工厂注册为正在运行。这将使
	//OLE 库能够从其他应用程序创建对象。
	COleTemplateServer::RegisterAll();
		//注意: MDI 应用程序将注册所有服务器对象，而不管
		//命令行上的 /Embedding 或 /Automation。


	//创建主 MDI 框架窗口
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
	{
		delete pMainFrame;
		return FALSE;
	}
	m_pMainWnd = pMainFrame;

	//启用拖/放打开。我们不在 Win32 中调用它，因为
	//运行 AppWizard 时没有选择文档文件扩展名。
	m_pMainWnd->DragAcceptFiles();

	//分析标准外壳命令、DDE、打开文件操作的命令行
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	//查看是否作为 OLE 服务器启动
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		//应用程序使用 /Embedding 或 /Automation 运行。这种情况下
		//不要显示主窗口。
		return TRUE;
	}

	//服务器应用程序以独立方式启动时，最好
	//更新系统注册表，以防其已损坏。
	m_server.UpdateRegistry(OAT_INPLACE_SERVER);

	//调度在命令行中指定的命令
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
    
	//主窗口已初始化，因此显示并更新主窗口。
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	//加载插件
	LoadPlugins();

	//添加 Web 服务菜单
	AddWebServiceMenu();

	return TRUE;
}


int FindMenuItem(CMenu * menu, LPCTSTR menuString)
{
	ENSURE(menu);
	ENSURE(::IsMenu(menu->GetSafeHmenu()));

	int count = menu->GetMenuItemCount();
	for (int i = 0; i < count; ++i)
	{
		CString str;
		if (menu->GetMenuString(i, str, MF_BYPOSITION) 
			&& (strcmp(str, menuString) == 0))
		{
			return i;
		}
	}

	return -1;
}

void CScribbleApp::LoadPlugins()
{
#ifdef _MANAGED
	String ^ fileName = "plugins.xml";
	List<IScribblePlugin ^> ^ pluginList;

	//加载插件
	try
	{
		pluginList = PluginBuilder::GetPlugins(fileName);
	}
	catch (PluginFileException ^ e)
	{
		char * cStr = ManagedStr2CStr(e->Message);
		MessageBox(m_pMainWnd->m_hWnd, cStr, "Error", MB_ICONERROR | MB_OK);
		delete cStr;
		return;
	}
	catch (PluginLoadException ^ e)
	{
		char * cStr = ManagedStr2CStr(e->Message);
		MessageBox(m_pMainWnd->m_hWnd, cStr, "Error", MB_ICONERROR | MB_OK);
		delete cStr;

		return;
	}

	//生成插件菜单
	CMenu * cmMainMenu = m_pMainWnd->GetMenu();
	CMenu * cmPluginMenu = new CMenu();
	cmPluginMenu->CreatePopupMenu();

	unsigned int curID = ID_PLUGIN_MENU_START;
	for (int iPlugin = 0; iPlugin < pluginList->Count; ++iPlugin, ++curID)
	{
		//添加插件映射，其中映射是按插件
		//的菜单 ID 索引的
		m_pluginMap->Add(curID, pluginList->default[iPlugin]);

		//追加到弹出菜单
		char * cStr = ManagedStr2CStr(pluginList->default[iPlugin]->Name);
		cmPluginMenu->AppendMenuA(MF_STRING, curID, cStr);
		delete cStr;
	}

	//找到帮助菜单 ID
	int helpMenuID = FindMenuItem(cmMainMenu, "&Help");

	//将插件菜单插入到帮助菜单前
	cmMainMenu->InsertMenu(helpMenuID, MF_BYPOSITION | MF_POPUP, 
		(UINT_PTR) cmPluginMenu->Detach(), "&Plugins");

	//将插入有插件菜单的原始主菜单设置为
	//主菜单
	SetMenu(m_pMainWnd->m_hWnd, cmMainMenu->m_hMenu);
	cmMainMenu->Detach();

	delete cmPluginMenu;
#endif
}

void CScribbleApp::AddWebServiceMenu()
{
#ifdef _MANAGED
	//生成 Web 服务菜单
	CMenu * cmMainMenu = m_pMainWnd->GetMenu();
	CMenu * cmWebServiceMenu = new CMenu();
	cmWebServiceMenu->CreatePopupMenu();

	//添加 Web 服务菜单项
	cmWebServiceMenu->AppendMenuA(MF_STRING, ID_WEBSERVICE_ADDSHAPE_SQR, "Add Square");
	cmWebServiceMenu->AppendMenuA(MF_STRING, ID_WEBSERVICE_ADDSHAPE_REC, "Add Rectangle");
	cmWebServiceMenu->AppendMenuA(MF_STRING, ID_WEBSERVICE_ADDSHAPE_CIR, "Add Circle");
	
	//找到帮助菜单 ID
	int helpMenuID = FindMenuItem(cmMainMenu, "&Help");

	//将 Web 服务菜单插入到帮助菜单前
	cmMainMenu->InsertMenu(helpMenuID, MF_BYPOSITION | MF_POPUP, 
		(UINT_PTR) cmWebServiceMenu->Detach(), "&Web Services");

	//将插入有 Web 服务菜单的原始主菜单设置为
	//主菜单
	SetMenu(m_pMainWnd->m_hWnd, cmMainMenu->m_hMenu);
	cmMainMenu->Detach();

	delete cmWebServiceMenu;
#endif
}

void CScribbleApp::ExecutePlugin(CScribbleDoc * pScribDoc, UINT pluginMenuID)
{
#ifdef _MANAGED
	MyScribApp ^ scribApp = gcnew MyScribApp(pScribDoc);
	m_pluginMap->default[pluginMenuID]->Run(scribApp);
#endif
}

void CScribbleApp::AddRectangle(CScribbleDoc * pScribDoc, int posX, int posY, int width, int height) 
{
	ASSERT_VALID(pScribDoc);
#ifdef _MANAGED
	try {
		Shape^ shape = m_webService->GetRectangle(width, height);
		this->AddShape(pScribDoc, shape, posX, posY);
	} catch (Exception^ e) {
		char * cStr = ManagedStr2CStr(e->Message);
		MessageBox(m_pMainWnd->m_hWnd, cStr, "Error", MB_ICONERROR | MB_OK);
		delete cStr;
		return;
	}
#endif
	return;
}

void CScribbleApp::AddCircle(CScribbleDoc * pScribDoc, int posX, int posY, int radius) 
{
	ASSERT_VALID(pScribDoc);
#ifdef _MANAGED
	try {
		Shape^ shape = m_webService->GetCircle(radius);
		this->AddShape(pScribDoc, shape, posX, posY);
	} catch (Exception^ e) {
		char * cStr = ManagedStr2CStr(e->Message);
		MessageBox(m_pMainWnd->m_hWnd, cStr, "Error", MB_ICONERROR | MB_OK);
		delete cStr;
		return;
	}
#endif
	return;
}

#ifdef _MANAGED
void CScribbleApp::AddShape(CScribbleDoc * pScribDoc, Shape^ pShape, int posX, int posY)
{
	ASSERT_VALID(pScribDoc);
	if (pShape != nullptr) {
		CStroke* stroke = pScribDoc->NewStroke();
		for (int i = 0; i < pShape->Points->Length; ++i) {
			stroke->m_pointArray.Add(CPoint(posX + pShape->Points[i]->X, posY -  pShape->Points[i]->Y));
		}
		stroke->FinishStroke();
		pScribDoc->UpdateAllViews(NULL, 0L, stroke);
	}

}
#endif

/////////////////////////////////////////////////////////////////////////////
//用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

//对话框数据
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA
	
	// ClassWizard 生成的虚函数重写
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持
	//}}AFX_VIRTUAL

//实现
protected:
	//{{AFX_MSG(CAboutDlg)
		//无消息处理程序
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		//无消息处理程序
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//运行对话框的应用程序命令
void CScribbleApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CScribbleApp 命令
