﻿// ScribApp.cpp: CScribbleDoc 类的实现
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
// 参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。

#include "stdafx.h"
#include "ScribApp.h"

#ifdef _MANAGED

MyScribDoc::MyScribDoc(CScribbleDoc * scribDoc)
{
	m_ScribDoc = scribDoc;
}

void
MyScribDoc::DrawLine(Point ^ p1, Point ^ p2)
{
	CStroke * pStroke = m_ScribDoc->NewStroke();

	pStroke->m_pointArray.Add(CPoint(p1->X, p1->Y));
	pStroke->m_pointArray.Add(CPoint(p2->X, p2->Y));
	pStroke->FinishStroke();

	m_ScribDoc->UpdateAllViews(NULL, 0L, pStroke);
}

void
MyScribDoc::SetPenColor(Color c)
{
	m_ScribDoc->SetPenColor(RGB(c.R, c.G, c.B));
}

Color
MyScribDoc::GetPenColor()
{
	return Color::FromArgb(m_ScribDoc->GetPenColor());
}

MyScribApp::MyScribApp(CScribbleDoc * scribDoc)
{
	m_ScribDoc = gcnew MyScribDoc(scribDoc);
}

IScribbleDoc ^
MyScribApp::GetDocument()
{
	return m_ScribDoc;
}

#endif