﻿#pragma once
// PluginBld.h: PluginBuilder 类的接口
//
//这是 Microsoft 基础类 C++ 库的一部分。
//版权所有 (C) Microsoft Corporation。保留所有权利。
//
//此源代码仅用作 Microsoft 基础类
//参考及随库提供的相关
//电子文档的补充。
//有关 Microsoft 基础类产品的详细信息，
//请参见这些来源。
/////////////////////////////////////////////////////////////////////////////

#ifdef _MANAGED

#using <mscorlib.dll>
#using <System.Xml.dll>


using namespace System;
using namespace System::Xml;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace ScribbleApp;

ref class PluginLoadException : Exception
{
   static String ^ exceptMesg = "Error loading plugin";
public:
   PluginLoadException(String ^ mesg, Exception ^ inner) :
      Exception(String::Format("{0} : {1}", exceptMesg, mesg, inner))
   {
      
   }
};

ref class PluginFileException : Exception
{
   static String ^ exceptMesg = "Error in plugin file";
public:
   PluginFileException(String ^ mesg, Exception ^ inner) :
      Exception(String::Format("{0} : {1}", exceptMesg, mesg, inner))
   {
      
   }
};

ref class PluginBuilder
{
public:
	static List<IScribblePlugin ^> ^ GetPlugins(String ^ pluginFileName);
private:
	static IScribblePlugin ^ GetPlugin(String ^ assemblyPath, String ^ assemblyName);
    static List<String ^> ^ ReadPluginFile(String ^ pluginFilePath, String ^ pluginFileName);
};

#endif