﻿using System;
using System.Globalization;
using System.IO;

namespace EvenOdd
{
    class TestSecondsOrNumbers
    {
        [STAThread]
        public static int Main(string[] args)
        {
            // 如果未提供任何参数，则测试第二个参数值是否为偶数
            if (args.Length == 0)
                return TestNumber(DateTime.Now.Second);

            // 如果只提供了一个数值型参数，
            // 则测试该参数是否为偶数
            if (args.Length == 1)
            {
                try
                {
                    int num = Int32.Parse(args[0]);
                    return TestNumber(num);
                }
                catch (System.FormatException)
                {
                    Console.WriteLine("Please enter a numeric argument.");
                    return 1;
                }
            }
            // 如果指定了两个参数，则在第二个参数是
            // 已部署文件的名称的情况下，测试通过
            if (args.Length == 2)
                if (File.Exists(args[1]))
                    return 0;

            // 对于所有其他情况，测试均失败
            return 1;
        }

        public static int TestNumber(int arg)
        {
            int remainder;
            Math.DivRem(arg, 2, out remainder);
            return remainder;
        }
    }
}

