﻿using System;

namespace BankAccountNS
{
	/// <summary> 
	/// 银行帐户演示类。
	/// </summary> 
	public class BankAccount
	{
		private string m_customerName;

		private double m_balance;

		public BankAccount(string customerName, double balance)
		{
			m_customerName = customerName;
			m_balance = balance;
		}

		public string CustomerName
		{
			get { return m_customerName; }
		}

		public double Balance
		{
			get { return m_balance; }
		}

		public void Debit(double amount)
		{
			if (amount < 0)
			{
				throw new ArgumentOutOfRangeException("amount");
			}

			m_balance += amount;
		}

		public void Credit(double amount)
		{
			if (amount > m_balance)
			{
				throw new ArgumentOutOfRangeException("amount");
			}

			m_balance -= amount;
		}

		//        // new enum: 
		//        private enum accountType 
		//        { 
		//            Gold, 
		//            Platinum, 
		//        } 
		// 
		//        // private method: 
		//        private accountType GetAccountType 
		//        { 
		//            get 
		//            { 
		//                if (Balance > 15.00) 
		//                    return accountType.Platinum; 
		//                else 
		//                    return accountType.Gold; 
		//            } 
		//        } 

		public static void Main()
		{
			BankAccount ba = new BankAccount("Mr. Bryan Walton", 11.99);

			ba.Credit(5.77);
			ba.Debit(11.22);
			Console.WriteLine("Current balance is ${0}", ba.Balance);
			//Console.ReadKey(); 
		}

	}
}

/* 此处描述的示例公司、组织、产品、域名、电子邮件地址、徽标、人员、地点和事件均属虚构。无意与任何真实的公司、组织、产品、域名、电子邮件地址、徽标、人员、地点和事件发生关联，请勿进行此类推测。*/
