﻿using System;
using System.IO;
using System.Collections;
using System.Data.SqlClient;
using System.Resources;
using System.Reflection;

using OperationNS;
using PersonInformationNS;

namespace PeopleNS
{
	public class People
	{
		ResourceManager resourceManager;
		ArrayList fullNames;
		ArrayList companyNames;

#if OPTIMIZED_GETPEOPLE

		public People()
		{
			this.resourceManager = new ResourceManager("People.People", Assembly.GetExecutingAssembly());
			// 获取名称列表
			this.fullNames = GetNames(resourceManager, "fullNames");
			this.companyNames=GetNames(resourceManager, "companyNames");
		}
#else
		public People()
		{
			this.resourceManager = new ResourceManager("People.People", Assembly.GetExecutingAssembly());
		}
#endif

#if OPTIMIZED_GETPEOPLE

		public ArrayList GetPeople(int number)
		{
			// 这可以帮助表明进度
			OperationControl.GetInstance().Maximum += number;
			ArrayList people = new ArrayList();

			
			for (int i = 1; i <= number; i++)
			{
				string companyName = "";
				string fullName = "";

				fullName = (string)this.fullNames[i];
				companyName = (string)this.companyNames[i];

				// 基于姓名和公司创建一个 Person (人员)实例并添加到列表中
				people.Add(new PersonInformation(fullName, companyName));
				// 增加进度
				OperationControl.GetInstance().Increment(1);
			}
			// 返回人员列表
			return people;
		}
#else
		public ArrayList GetPeople(int number)
		{
			// 这可以帮助表明进度
			OperationControl.GetInstance().Maximum += number;
			ArrayList people = new ArrayList();

		
			for (int i = 1; i <= number; i++)
			{
				string companyName = "";
				string fullName = "";

				//获取所有全名的列表
				this.fullNames = GetNames(this.resourceManager, "fullNames");
				fullName = (string)this.fullNames[i];

				//获取所有公司名称的列表
				this.companyNames = GetNames(this.resourceManager, "companyNames");
				companyName = (string)this.companyNames[i];

				// 基于姓名和公司创建一个 Person (人员)实例并添加到列表中
				people.Add(new PersonInformation(fullName, companyName));
				// 增加进度
				OperationControl.GetInstance().Increment(1);
			}
			// 返回人员列表
			return people;
		}
#endif

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Maintainability", "CA1500:VariableNamesShouldNotMatchFieldNames", MessageId = "resourceManager")]
        private static ArrayList GetNames(ResourceManager resourceManager, string fileName)
		{
			ArrayList names = new ArrayList();
			string contents = resourceManager.GetString(fileName);

			using (StringReader reader = new StringReader(contents))
			{
				string name = reader.ReadLine();

				while (name != null)
				{
					names.Add(name.Trim());
					name = reader.ReadLine();
				}
			}
			return names;
		}
	}
}
