/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994, 1995
                       yield Example

    FILE:       yieldp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  YieldProc() - sleeps the amount of time specified
                              by client to server

    COMMENTS:

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "yield.h"    // header file generated by MIDL compiler

void YieldProc(short cSeconds)
{
    printf("Calling Sleep for %d seconds...\n", cSeconds);
    Sleep(cSeconds * 1000);
    printf("Awake for next call...\n");
}

void Shutdown(void)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file yieldp.c */
