/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994, 1995
                        repas Example

    FILE:       repasu.c

    PURPOSE:    Utility functions used by both client and server
                sides of the RPC distributed application.
                This sample demonstrates the transmit_as example.
                A doubly-linked list is transmitted over the network
                as a sized array.

    RELATED:    repass.c - server main
                repasp.c - remote procedures
                repasc.c - client main

    FUNCTIONS:  WCHAR_STRING_to_local    - convert WCHAR_STRING to CHAR_STRING
                WCHAR_STRING_from_local  - convert CHAR_STRING to WCHAR_STRING
                WCHAR_STRING_free_inst   - free CHAR_STRING memory
                WCHAR_STRING_free_local  - free WCHAR_STRING memory
                midl_user_allocate - user-supplied memory allocator
                midl_user_free - user-supplied routine to free memory


    COMMENTS:   This sample program generates a client and server can share
                an interface, but one side can use a different representation
                than the other.

                The client side in this example does all operations using
                character strings, and the server side does all operations
                using UNICODE strings.  Two procedures are provided, one
                defined with ASCII strings, one with UNICODE strings.
                The wire format reflects these definitions, yet the client
                and server see pure ASCII and pure UNICODE respectively.

                The [represent_as] attribute (used in the client and server
                side acf files) requires the four user-supplied functions
                whose names start with the name of the transmitted type
                (in the client side's case: WCHAR_STRING)

                The [in, out] attributes applied to remote procedure
                parameters require the two user-supplied functions
                midl_user_allocate and midl_user_free.

                The other functions are utilities that are used to
                build or display the data structures.

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "repass.h"    // header file generated by MIDL compiler for client




void __RPC_USER
CHAR_STRING_from_local(
    WCHAR_STRING __RPC_FAR * pLocal,
    CHAR_STRING __RPC_FAR * __RPC_FAR * pWire )
{
    CHAR_STRING    *   pWireString;

    pWireString = midl_user_allocate( sizeof( CHAR_STRING ) );

    *pWire = pWireString;

    wcstombs( *pWireString, *pLocal, STRING_SIZE );
}


void __RPC_USER
CHAR_STRING_to_local(
    CHAR_STRING __RPC_FAR * pWire,
    WCHAR_STRING __RPC_FAR * pLocal )
{
    mbstowcs( *pLocal, *pWire, STRING_SIZE );
}

void __RPC_USER
CHAR_STRING_free_inst(
    CHAR_STRING __RPC_FAR * pWire)
{
    midl_user_free( pWire );
}

void __RPC_USER
CHAR_STRING_free_local(
    WCHAR_STRING __RPC_FAR * pLocal)
{
    midl_user_free( pLocal );
}

/***************************************************************************/

void __RPC_FAR * __RPC_USER midl_user_allocate(size_t len)
{
    return(malloc(len));
}

void __RPC_USER midl_user_free(void __RPC_FAR * ptr)
{
    free(ptr);
}


/***************************************************************************/

/* end file repassu.c */
