/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994, 1995
                         repas Example

    FILE:       repasp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  ModifyListProc() - changes the doubly-linked list
                Shutdown() - shuts down the server side

    COMMENTS:   Related to repass.c

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "repass.h"    // header file generated by MIDL compiler


/****************************************************************************

Function:   ModifyMyWString

Parameters: pStr : Pointer to pointer to UNICODE string

Returns:    none

Purpose:    Display the string passed in, modify it, and return

Comments:   This sample is meant to demonstrate a typical use of the
            represent_as attribute:  The client and server have different
            local views of the data, although the IDL file describes the
            wire contract.

****************************************************************************/
void ModifyMyWString(WCHAR_STRING * pStr)
{
    wprintf(L"\nModifyMyWString: received UNICODE string:\n%s\n\n", *pStr );
    wcscpy(*pStr, L"This string comes back on the wire as UNICODE");
    wprintf(L"ModifyMyWString: sending UNICODE string:\n%s\n\n", *pStr );

}

/****************************************************************************

Function:   ModifyMyString

Parameters: pStr : Pointer to pointer to UNICODE string

Returns:    none

Purpose:    Display the string passed in, modify it, and return

Comments:   This sample is meant to demonstrate a typical use of the
            represent_as attribute:  The client and server have different
            local views of the data, although the IDL file describes the
            wire contract.

****************************************************************************/
void ModifyMyString(WCHAR_STRING * pStr)
{
    wprintf(L"\nModifyMyString: received UNICODE string:\n%s\n\n", *pStr );
    wcscpy(*pStr, L"This UNICODE string comes back on the wire as ASCII");
    wprintf(L"ModifyMyString: sending UNICODE string:\n%s\n\n", *pStr );

}


/****************************************************************************

Function:   Shutdown

Parameters: none

Returns:    none

Purpose:    Make the server stop listening for client applications.

Comments:   The two NULL parameters passed to RpcServerUnregisterIf are
            a show of brute force:  they tell the function to turn
            off all registered interfaces.  See the RPC API function
            reference for more information about these functions.

****************************************************************************/

void Shutdown(void)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file repasp.c */
