/****************************************************************************
                  Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994, 1995
                       inout Example

    FILE:       inoutp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  InOutProc() - demonstrates in, out parameters

    COMMENTS:

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "inout.h"    // header file generated by MIDL compiler

#define CONSTANT 257

void InOutProc(short    s1,
               short * ps2,
               float * pf3)
{
    printf("on entry, *pf3 = %f\n", *pf3);

    *pf3 = (float) s1 / (float) *ps2;
    printf("%d / %d = %0.3f\n", s1, *ps2, *pf3);

    *ps2 = (short)CONSTANT - s1;
    printf("%d - %d = %d\n", CONSTANT, s1, *ps2);

    s1++;

    return;
}

void Shutdown(void)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file inoutp.c */
