/////////////////////////////////////////////////////////////////////////////
// charset.h : Contains bitmap character images.
//

// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1996 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.


/////////////////////////////////////////////////////////////////////////////

// See the documentation for more information on the
// format of this file.

#ifndef __CHARSET_H__
#define __CHARSET_H__

// all characters are 8x16

#define char_width 8
#define char_height 16

static unsigned char char_bits[11][char_height] = 
{
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0xC3, 0xC3, 
		0xDB, 0xDB, 0xC3, 0xC3, 0x66, 0x3C }, // 0
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1C, 0x1E, 0x18, 
		0x18, 0x18, 0x18, 0x18, 0x18, 0x7E }, // 1
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x63, 0x60, 0x30, 
		0x18, 0x0C, 0x06, 0x03, 0x63, 0x7F }, // 2
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x63, 0x60, 0x60, 
		0x3C, 0x60, 0x60, 0x60, 0x63, 0x3E }, // 3
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x38, 0x3C, 0x36, 
		0x33, 0x7F, 0x30, 0x30, 0x30, 0x78 }, // 4
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x03, 0x03, 0x03, 
		0x3F, 0x60, 0x60, 0x60, 0x63, 0x3E }, // 5
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x06, 0x03, 0x03, 
		0x3F, 0x63, 0x63, 0x63, 0x63, 0x3E }, // 6
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x63, 0x60, 0x60, 
		0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x0C }, // 7
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x63, 0x63, 0x63, 
		0x3E, 0x63, 0x63, 0x63, 0x63, 0x3E }, // 8
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x63, 0x63, 0x63, 
		0x7E, 0x60, 0x60, 0x60, 0x30, 0x1E }, // 9
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 
		0x00, 0x00, 0x00, 0x18, 0x18, 0x00 }, // :
};

#endif
