/*****************************************************************************\
*                                                                             *
*    Ole.r                                                                    *
*                                                                             *
*    OLE Version 2.0 Sample Code                                              *
*                                                                             *
*    Copyright (c) 1992-1994, Microsoft Corp. All rights reserved.            *
*                                                                             *
\*****************************************************************************/

#ifndef _MSC_VER
#include "OLine.h"
#endif

#include "Types.r"
#include "Const.h"

// OLDNAME: OleTypes.r

type 'CSTR' {
	cstring;
};


// OLDNAME: Ole.r

resource 'CURS' (kCursorDragNone) {
	$"0000 03C0 0C30 1008 2804 2404 4202 4102"
	$"4082 4042 2024 2014 1008 0C30 03C0",
	$"03C0 0FF0 1FF8 3C3C 7C0E 7E0E E707 E387"
	$"E1C7 E0E7 707E 703E 3C3C 1FF8 0FF0 03C0",
	{7, 8}
};

resource 'CURS' (kCursorDragCopy) {
	$"0000 4040 6040 51F0 4840 4440 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C040 E0E0 F1F0 FBF8 FDF0 FEE0 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragMove) {
	$"0000 4000 6000 5000 4800 4400 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C000 E000 F000 F800 FC00 FE00 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragLink) {
	$"0000 4080 6080 5080 4880 44F0 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C1C0 E1C0 F1C0 F9C0 FDF8 FFF8 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragScroll) {
	$"0000 40F0 6080 50F0 4810 44F0 4200 41F8"
	$"47FC 5CFE 6CFE 46FE 06FE 03FE 03FE",
	$"C1C0 E1C0 F1C0 F9C0 FDF8 FFF8 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

// OLDNAME: OleOutline.r
resource 'CSTR' (kOutlineFormat_CSTR, locked, preload) {
	"Outline Data"
};

resource 'CSTR' (kOutlineResult_CSTR, locked, preload) {
	"Outline Data"
};

resource 'CSTR' (kTextFormat_CSTR, locked, preload) {
	"Text"
};

resource 'CSTR' (kTextResult_CSTR, locked, preload) {
	"text"
};

resource 'CSTR' (kNewNamePrefix_CSTR, purgeable) {
	"Object"
};

resource 'CSTR' (kEmbeddedObjectFormat_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kEmbeddedObjectResult_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kPictFormat_CSTR, locked, preload) {
	"Picture (Metafile)"
};

resource 'CSTR' (kPictResult_CSTR, locked, preload) {
	"a static picture"
};

resource 'CSTR' (kDIBFormat_CSTR, locked, preload) {
	"Picture (DIB)"
};

resource 'CSTR' (kDIBResult_CSTR, locked, preload) {
	"a static picture"
};

resource 'CSTR' (kBitmapFormat_CSTR, locked, preload) {
	"Picture (Bitmap)"
};

resource 'CSTR' (kBitmapResult_CSTR, locked, preload) {
	"as a static picture"
};

resource 'CSTR' (kLinkSourceFormat_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kLinkSourceResult_CSTR, locked, preload) {
	"%s"
};

resource 'CURS' (kCursorBackwardResize, preload) {
	$"0000 0000 0000 1E00 1C00 1C00 1200 0100"
	$"0090 0070 0070 00F0",
	$"0000 0000 3F00 3F00 3E00 3E00 3F00 3398"
	$"01F8 00F8 00F8 01F8 01F8",
	{7, 7}
};

resource 'CURS' (kCursorForwardResize, preload) {
	$"0000 0000 0000 00F0 0070 0070 0090 0100"
	$"1200 1C00 1C00 1E",
	$"0000 0000 01F8 01F8 00F8 00F8 01F8 3398"
	$"3F00 3E00 3E00 3F00 3F",
	{7, 7}
};

resource 'CURS' (kCursorHorizResize, preload) {
	$"0000 0000 0000 0000 0000 1010 3018 7FFC"
	$"3018 1010",
	$"0000 0000 0000 0000 1830 3838 7FFC FFFE"
	$"7FFC 3838 1830",
	{7, 7}
};

resource 'CURS' (kCursorVertResize, preload) {
	$"0000 0100 0380 07C0 0100 0100 0100 0100"
	$"0100 0100 0100 07C0 0380 01",
	$"0100 0380 07C0 0FE0 0FE0 0380 0380 0380"
	$"0380 0380 0FE0 0FE0 07C0 0380 01",
	{7, 7}
};

// OLDNAME: OleServerDocument.r

resource 'STR#' (kServerMenu_STRs, purgeable)
{
	{
		"Close & Return";
		"Update";
		"Save a Copy As...";
		"Quit & Return";
	}
};

// OLDNAME: OutlineServer.r
resource 'SIZE' (-1)
{
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,
	multiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreChildDiedEvents,
	is32BitCompatible,
	isHighLevelEventAware,
	localAndRemoteHLEvents,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	kPrefSize * 1024,
	kMinSize * 1024
};

resource 'MENU' (kApple_MENU, preload, nonpurgeable)
{
	kApple_MENU, textMenuProc,
	0b1111111111111111111111111111101,
	enabled, apple,
	{
#if !qOleInPlace
		"About Outline Server...", noicon, nokey, nomark, plain;
#else
		"About Outline InPlace Server...", noicon, nokey, nomark, plain;
#endif
		"-", noicon, nokey, nomark, plain
	}
};

resource 'MENU' (kEdit_MENU, preload, nonpurgeable)
{
	kEdit_MENU, textMenuProc,
	0b0000000000000000000000000000000,
	enabled, "Edit",
	 {
		"Undo", noicon, "Z", nomark, plain;
		"-", noicon, nokey, nomark, plain;
		"Cut", noicon, "X", nomark, plain;
		"Copy", noicon, "C", nomark, plain;
		"Paste", noicon, "V", nomark, plain;
		"Clear", noicon, "B", nomark, plain;
		"Select All", noicon, "A", nomark, plain;
	}
};

resource kMenuItemToCmdResType (kMenuItemToCmdResID, preload, nonpurgeable)
{
	{
		kApple_MENU, 1, cmdAbout;

		kFile_Menu, 1, cmdNew;
		kFile_Menu, 2, cmdOpen;
		kFile_Menu, 4, cmdClose;
		kFile_Menu, 5, cmdSave;
		kFile_Menu, 6, cmdSaveAs;
		kFile_Menu, 7, cmdRevert;
		kFile_Menu, 9, cmdPageSetup;
		kFile_Menu, 10, cmdPrint;
		kFile_Menu, 12, cmdQuit;

		kEdit_MENU, 1, cmdUndo;
		kEdit_MENU, 3, cmdCut;
		kEdit_MENU, 4, cmdCopy;
		kEdit_MENU, 5, cmdPaste;
		kEdit_MENU, 6, cmdClear;
		kEdit_MENU, 7, cmdSelectAll;

		kLines_MENU, 1, cmdNewLine;
		kLines_MENU, 2, cmdIndentLine;
		kLines_MENU, 3, cmdUnIndentLine;

		kName_MENU, 1, cmdShowName;

		kOptions_MENU, 1, cmdToolbar;
		kOptions_MENU, 2, cmdFormulaBar;
		kOptions_MENU, 3, cmdHeadings;

		kToolbar_MENU, 1, cmdToolbarAtTop;
		kToolbar_MENU, 2, cmdToolbarAtBottom;
		kToolbar_MENU, 3, cmdToolbarFloating;
		kToolbar_MENU, 4, cmdToolbarHidden;

		kFormulaBar_MENU, 1, cmdFormulaBarAtTop;
		kFormulaBar_MENU, 2, cmdFormulaBarAtBottom;
		kFormulaBar_MENU, 3, cmdFormulaBarFloating;

		kHeadings_MENU, 1, cmdHeadingsShow;
		kHeadings_MENU, 2, cmdHeadingsHide;

#if qDebug
		kDebug_MENU, 1, cmdAsserts;
		kDebug_MENU, 2, cmdRejectMessages;
#endif
	}
};

#if qOleInPlace

type 'OTIS' as 'STR ';

resource 'OTIS' (0) {
	"OLE 2.0 In-Place Server Sample Code"
};

resource 'BNDL' (128) {
	'OTIS',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		}
	}
};

data 'FREF' (128) {
	$"4150 504C 0000 00"                                  /* APPL... */
};

resource 'icl4' (128) {
	$"0000 0000 0000 0000 0000 0000 00FF 0000"
	$"0000 0000 0000 0000 0000 0000 0F2F 0000"
	$"0000 0000 0000 0000 0000 0000 F2F0 0000"
	$"0000 0000 0000 0000 0000 000F 2F00 0000"
	$"0000 0000 0000 0000 0000 00F2 F000 0000"
	$"0000 0000 0000 0000 0000 0F2F 0000 0000"
	$"0FFF FFFF FFFF FFFF FFFF F2FF FFFF 0000"
	$"0F00 FDBD BDBD BDBD F00F 2FFF BFBF 0000"
	$"0F00 FBDB DBDB DBDF 0CF2 F000 FFDF 0000"
	$"0FFF FFFF FFFF FFF0 CF2F 0000 0FFF 0000"
	$"0FF0 0FDB DBDB DF0C F2FC 0000 000F FFF0"
	$"0FF0 0FBD BDBD BFCF 2FFC 0000 0000 F34F"
	$"0FFF FFFF FFEE EFF2 F0FC 0000 0000 F43F"
	$"0FE0 CCCC CCCC CFFF FFFC 0000 0000 F34F"
	$"0FE0 0000 0000 FF00 0000 0000 0000 F43F"
	$"0FE0 CCCC CCCF 2FFF F000 00CF FCCF 434F"
	$"0FE0 0000 0F0F F000 0FFF FFF0 0FF4 343F"
	$"0FE0 0000 CCEC CCCC CCCC CCC0 0F43 43F0"
	$"0FE0 0000 0EEE EE00 0000 0000 00FF FF00"
	$"0FEC CCCC CCCC CCCC CCCC CCCC C0FF 0000"
	$"0FE0 0000 CEEE EEE0 0000 0000 00EF 0000"
	$"0FE0 000C CCCC CCCC CCCC CCCC CCEF 0000"
	$"0FE0 0000 0EEE EEEE E000 0000 00EF 0000"
	$"0FE0 000C CCCC CCCC CCCC CCCC C0EF 0000"
	$"0FE0 0000 0000 EEEE EE00 0000 00EF 0000"
	$"0FE0 000C CCCC CCCC CCCC CCC0 00EF 0000"
	$"0FE0 0000 0000 000E EEEE EE00 00EF 0000"
	$"0FEE EEEE EEEE EEEE EEEE EEEE EEEF 0000"
	$"0FFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (128) {
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 FFFF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 00FF 17FF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 FF17 FF00 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 00FF 17FF 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 FF17 FF00 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 00FF 17FF 0000 0000 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FF17 FFFF FFFF FFFF 0000 0000"
	$"00FF 0000 FFF9 5EF9 5EF9 5EF9 5EF9 5EF9"
	$"FF00 00FF 17FF FFFF 5EFF 5EFF 0000 0000"
	$"00FF 0000 FF5E F95E F95E F95E F95E F9FF"
	$"002B FF17 FF00 0000 FFFF F9FF 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
	$"2BFF 17FF 0000 0000 00FF FFFF 0000 0000"
	$"00FF FF00 00FF F95E F95E F95E F9FF 002B"
	$"FF17 FF2B 0000 0000 0000 00FF FFFF FF00"
	$"00FF FF00 00FF 5EF9 5EF9 5EF9 5EFF 2BFF"
	$"17FF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF FFFF FFFF FFFF FFFF FCFC FCFF FF17"
	$"FF00 FF2B 0000 0000 0000 0000 FF20 D8FF"
	$"00FF FC00 2B2B 2B2B 2B2B 2B2B 2BFF FFFF"
	$"FFFF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF FC00 0000 0000 0000 0000 FFFF 0000"
	$"0000 0000 0000 0000 0000 0000 FF20 D8FF"
	$"00FF FC00 2B2B 2B2B 2B2B 2BFF 17FF FFFF"
	$"FF00 0000 0000 2BFF FF2B 2BFF 20D8 20FF"
	$"00FF FC00 0000 0000 00FF 00FF FF00 0000"
	$"00FF FFFF FFFF FF00 00FF FF20 D820 D8FF"
	$"00FF FC00 0000 0000 2B2B FC2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B00 00FF 20D8 20D8 FF00"
	$"00FF FC00 0000 0000 00FC FCFC FCFC 0000"
	$"0000 0000 0000 0000 0000 FFFF FFFF 0000"
	$"00FF FC2B 2B2B 2B2B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B00 FFFF 0000 0000"
	$"00FF FC00 0000 0000 2BFC FCFC FCFC FC00"
	$"0000 0000 0000 0000 0000 FCFF 0000 0000"
	$"00FF FC00 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B2B FCFF 0000 0000"
	$"00FF FC00 0000 0000 00FC FCFC FCFC FCFC"
	$"FC00 0000 0000 0000 0000 FCFF 0000 0000"
	$"00FF FC00 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B00 FCFF 0000 0000"
	$"00FF FC00 0000 0000 0000 0000 FCFC FCFC"
	$"FCFC 0000 0000 0000 0000 FCFF 0000 0000"
	$"00FF FC00 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B00 0000 FCFF 0000 0000"
	$"00FF FC00 0000 0000 0000 0000 0000 00FC"
	$"FCFC FCFC FCFC 0000 0000 FCFF 0000 0000"
	$"00FF FCFC FCFC FCFC FCFC FCFC FCFC FCFC"
	$"FCFC FCFC FCFC FCFC FCFC FCFF 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0030 0000 0050 0000 00A0 0000 0140"
		$"0000 0280 0000 0500 7FFF FBF0 4AAA 9750"
		$"4D55 28D0 7FFE 5070 7FFC A01E 6555 600D"
		$"66AE A009 7FFF E00D 600C 0009 6557 8195"
		$"6058 7E61 6035 5456 607C 003C 6555 5530"
		$"607E 0030 6155 5570 607F 8030 6155 5530"
		$"600F C030 6155 5530 6001 FC30 7FFF FFF0"
		$"7FFF FFF0",
		/* [2] */
		$"0000 0030 0000 0070 0000 00E0 0000 01C0"
		$"0000 0380 0000 0700 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFFE 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFE 7FFF FFFC 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0"
	}
};

resource 'ics#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"000C 0014 0038 FFFC AB6C FEC7 DFC3 FD1F"
		$"CEFF C50E C72C D28C C3CC C14C FFFC FFFC",
		/* [2] */
		$"000C 001C 0038 FFFC FFFC FFFF FFFF FFFF"
		$"FFFF FFFE FFFC FFFC FFFC FFFC FFFC FFFC"
	}
};

resource 'ics4' (128) {
	$"0000 0000 0000 FF00 0000 0000 000F 2F00"
	$"0000 0000 00F2 F000 FFFF FFFF FF2F FF00"
	$"F0FB FBFF 02F0 FF00 FFFF FFF0 2F00 0FFF"
	$"FF0F BEF2 FF00 00FF FFFF FF2F 000F FF4F"
	$"F000 FFFC FFFF FF4F FCCC EEEC CCCC FFF0"
	$"F00C EEEE CCCC FF00 F00C EEEE ECCC FF00"
	$"F00C CCEE ECCC FF00 F000 0CCE EEEE EF00"
	$"FFFF FFFF FFFF FF00 FFFF FFFF FFFF FF"
};

resource 'ics8' (128) {
	$"0000 0000 0000 0000 0000 0000 FFFF 0000"
	$"0000 0000 0000 0000 0000 00FF 17FF 0000"
	$"0000 0000 0000 0000 0000 FF17 FF00 0000"
	$"FFFF FFFF FFFF FFFF FFFF 17FF FFFF 0000"
	$"FF00 FF5E FF5E FFFF 0017 FF00 FFFF 0000"
	$"FFFF FFFF FFFF FF00 17FF 0000 00FF FFFF"
	$"FFFF 00FF 5EFC FF17 FFFF 0000 0000 FFFF"
	$"FFFF FFFF FFFF 17FF 0000 00FF FFFF 20FF"
	$"FF00 0000 FFFF FF2B FFFF FFFF FFFF 20FF"
	$"FF2B 2B2B FCFC FC2B 2B2B 2B2B FFFF FF00"
	$"FF00 002B FCFC FCFC 2B2B 2B2B FFFF 0000"
	$"FF00 002B FCFC FCFC FC2B 2B2B FFFF 0000"
	$"FF00 002B 2B2B FCFC FC2B 2B2B FFFF 0000"
	$"FF00 0000 002B 2BFC FCFC FCFC FCFF 0000"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

#else

type 'OUTS' as 'STR ';

resource 'OUTS' (0) {
	"OLE 2.0 Server Sample Code"
};

resource 'BNDL' (128) {
	'OUTS',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		}
	}
};

data 'FREF' (128) {
	$"4150 504C 0000 00"                                  /* APPL... */
};

resource 'icl4' (128) {
	$"0000 0000 0000 0000 0000 0000 00FF 0000"
	$"0000 0000 0000 0000 0000 0000 0F2F 0000"
	$"0000 0000 0000 0000 0000 0000 F2F0 0000"
	$"0000 000F FFFF FFFF FFFF FFFF 2F00 0000"
	$"0000 000F 00FD BDBD BDBD BDF2 F000 0000"
	$"0000 000F 00FB DBDB DBDB DF2F F000 0000"
	$"0FFF FFFF FFFF FFFF FFFF F2FF FFFF 0000"
	$"0F00 FDBF 0000 0000 F00F 2FFF BFBF 0000"
	$"0F00 FBDF 0CCC CC0F CCF2 F000 FFDF 0000"
	$"0FFF FFFF 0000 0FF0 CF2F 0000 0FFF 0000"
	$"0F00 000F 00CC CF0C F2FC 0000 000F FFF0"
	$"0FCC CCCF 0000 0FCF 2FFC 0000 0000 F34F"
	$"0F00 000F 00CC CFF2 F0FC 0000 0000 F43F"
	$"0F00 CCCF 0000 0FFF FFFC 0000 0000 F34F"
	$"0F00 000F 0CCC FF00 0000 0000 0000 F43F"
	$"0F00 CCCF 0FFF 2FFF F000 00CF FCCF 434F"
	$"0F00 000F 000F F000 0FFF FFF0 0FF4 343F"
	$"0F00 000F 0FFF 0000 0000 00F0 0F43 43F0"
	$"0F00 000F 0000 0000 0000 00F0 00FF FF00"
	$"0F0C CCCF 0FFF FFF0 0000 00FC C0FF 0000"
	$"0F00 000F 0000 0000 0000 00F0 000F 0000"
	$"0F00 000F 0FFF FFFF 0000 00FC CCCF 0000"
	$"0F00 000F 0000 0000 0000 00F0 000F 0000"
	$"0F00 000F FFFF FFFF FFFF FFFC C00F 0000"
	$"0F00 0000 0000 EEEE EE00 0000 000F 0000"
	$"0F00 000C CCCC CCCC CCCC CCC0 000F 0000"
	$"0F00 0000 0000 000E EEEE EE00 000F 0000"
	$"0F00 0000 000C CCCC CEEE EEEE E00F 0000"
	$"0FFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (128) {
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 FFFF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 00FF 17FF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 FF17 FF00 0000 0000"
	$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF 17FF 0000 0000 0000"
	$"0000 0000 0000 00FF 0000 FFF9 5EF9 5EF9"
	$"5EF9 5EF9 5EF9 FF17 FF00 0000 0000 0000"
	$"0000 0000 0000 00FF 0000 FF5E F95E F95E"
	$"F95E F95E F9FF 17FF FF00 0000 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FF17 FFFF FFFF FFFF 0000 0000"
	$"00FF 0000 FFF9 5EFF 0000 0000 0000 0000"
	$"FF00 00FF 17FF FFFF 5EFF 5EFF 0000 0000"
	$"00FF 0000 FF5E F9FF 002B 2B2B 2B2B 00FF"
	$"2B2B FF17 FF00 0000 FFFF F9FF 0000 0000"
	$"00FF FFFF FFFF FFFF 0000 0000 00FF FF00"
	$"2BFF 17FF 0000 0000 00FF FFFF 0000 0000"
	$"00FF 0000 0000 00FF 0000 2B2B 2BFF 002B"
	$"FF17 FF2B 0000 0000 0000 00FF FFFF FF00"
	$"00FF 2B2B 2B2B 2BFF 0000 0000 00FF 2BFF"
	$"17FF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF 0000 0000 00FF 0000 2B2B 2BFF FF17"
	$"FF00 FF2B 0000 0000 0000 0000 FF20 D8FF"
	$"00FF 0000 2B2B 2BFF 0000 0000 00FF FFFF"
	$"FFFF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF 0000 0000 00FF 002B 2B2B FFFF 0000"
	$"0000 0000 0000 0000 0000 0000 FF20 D8FF"
	$"00FF 0000 2B2B 2BFF 00FF FFFF 17FF FFFF"
	$"FF00 0000 0000 2BFF FF2B 2BFF 20D8 20FF"
	$"00FF 0000 0000 00FF 0000 00FF FF00 0000"
	$"00FF FFFF FFFF FF00 00FF FF20 D820 D8FF"
	$"00FF 0000 0000 00FF 00FF FFFF 0000 0000"
	$"0000 0000 0000 FF00 00FF 20D8 20D8 FF00"
	$"00FF 0000 0000 00FF 0000 0000 0000 0000"
	$"0000 0000 0000 FF00 0000 FFFF FFFF 0000"
	$"00FF 002B 2B2B 2BFF 00FF FFFF FFFF FF00"
	$"0000 0000 0000 FF2B 2B00 FFFF 0000 0000"
	$"00FF 0000 0000 00FF 0000 0000 0000 0000"
	$"0000 0000 0000 FF00 0000 00FF 0000 0000"
	$"00FF 0000 0000 00FF 00FF FFFF FFFF FFFF"
	$"0000 0000 0000 FF2B 2B2B 2BFF 0000 0000"
	$"00FF 0000 0000 00FF 0000 0000 0000 0000"
	$"0000 0000 0000 FF00 0000 00FF 0000 0000"
	$"00FF 0000 0000 00FF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FF2B 2B00 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 FCFC FCFC"
	$"FCFC 0000 0000 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B00 0000 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 0000 00FC"
	$"FCFC FCFC FCFC 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 002B 2B2B 2B2B"
	$"2BFC FCFC FCFC FCFC FC00 00FF 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0030 0000 0050 0000 00A0 01FF FF40"
		$"0135 5680 012A AD00 7FFF FBF0 4D00 9750"
		$"4B2B 28D0 7F02 5070 412C A01E 5505 600D"
		$"412E A009 450F E00D 411C 0009 4577 8195"
		$"4159 7F61 417C 0156 4135 553C 457F 0110"
		$"4155 5510 417F 8150 4155 5510 41FF FF10"
		$"400F E010 4155 5510 4001 FC10 4000 7F90"
		$"7FFF FFF0",
		/* [2] */
		$"0000 0030 0000 0070 0000 00E0 01FF FFC0"
		$"01FF FF80 01FF FF80 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFFE 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFE 7FFF FFFC 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0"
	}
};

resource 'ics#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"000C 1FF4 142C FFDC BF6C F2C7 97C3 931F"
		$"9EFF 9516 9754 9294 9FF4 815C FFFC",
		/* [2] */
		$"000C 1FFC 1FF8 FFFC FFFC FFFF FFFF FFFF"
		$"FFFF FFFE FFFC FFFC FFFC FFFC FFFC"
	}
};

resource 'ics4' (128) {
	$"0000 0000 0000 FF00 000F FFFF FFFF 2F00"
	$"000F 0FDD DDF2 F000 FFFF FFFF FF2F FF00"
	$"F0FF 00FF 02F0 FF00 FFFF 0CF0 2F00 0FFF"
	$"F0CF 00FF FF00 00FF F0CF CCFF 000F FF4F"
	$"F00F 0FF0 FFFF FF4F FCCF 0CCC C00F CFF0"
	$"F00F 0EEE 000F CF00 F00F FFFF FFFF CF00"
	$"F00C CCEE ECCC 0F00 F000 0CCE EEEE EF00"
	$"FFFF FFFF FFFF FF"
};

resource 'ics8' (128) {
	$"0000 0000 0000 0000 0000 0000 FFFF 0000"
	$"0000 00FF FFFF FFFF FFFF FFFF 17FF 0000"
	$"0000 00FF 00FF F9F9 F9F9 FF17 FF00 0000"
	$"FFFF FFFF FFFF FFFF FFFF 17FF FFFF 0000"
	$"FF00 FFFF 0000 FFFF 0017 FF00 FFFF 0000"
	$"FFFF FFFF 002B FF00 17FF 0000 00FF FFFF"
	$"FF00 2BFF 0000 FFFF FFFF 0000 0000 FFFF"
	$"FF00 2BFF 2B2B FFFF 0000 00FF FFFF 20FF"
	$"FF00 00FF 00FF FF00 FFFF FFFF FFFF 20FF"
	$"FF2B 2BFF 002B 2B2B 2B00 00FF 2BFF FF00"
	$"FF00 00FF 00FC FCFC 0000 00FF 2BFF 0000"
	$"FF00 00FF FFFF FFFF FFFF FFFF 2BFF 0000"
	$"FF00 002B 2B2B FCFC FC2B 2B2B 00FF 0000"
	$"FF00 0000 002B 2BFC FCFC FCFC FCFF 0000"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

#endif
