/*****************************************************************************\
*                                                                             *
*    Ole.r                                                                    *
*                                                                             *
*    OLE Version 2.0 Sample Code                                              *
*                                                                             *
*    Copyright (c) 1992-1994, Microsoft Corp. All rights reserved.            *
*                                                                             *
\*****************************************************************************/

#ifndef _MSC_VER
#include "oline.h"
#endif

#include "Types.r"
#include "Const.h"

// OLDNAME: Ole.r

resource 'CURS' (kCursorDragNone) {
	$"0000 03C0 0C30 1008 2804 2404 4202 4102"
	$"4082 4042 2024 2014 1008 0C30 03C0",
	$"03C0 0FF0 1FF8 3C3C 7C0E 7E0E E707 E387"
	$"E1C7 E0E7 707E 703E 3C3C 1FF8 0FF0 03C0",
	{7, 8}
};

resource 'CURS' (kCursorDragCopy) {
	$"0000 4040 6040 51F0 4840 4440 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C040 E0E0 F1F0 FBF8 FDF0 FEE0 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragMove) {
	$"0000 4000 6000 5000 4800 4400 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C000 E000 F000 F800 FC00 FE00 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragLink) {
	$"0000 4080 6080 5080 4880 44F0 4200 41F8"
	$"478C 5C8E 6C82 4682 0682 0382 03FE",
	$"C1C0 E1C0 F1C0 F9C0 FDF8 FFF8 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

resource 'CURS' (kCursorDragScroll) {
	$"0000 40F0 6080 50F0 4810 44F0 4200 41F8"
	$"47FC 5CFE 6CFE 46FE 06FE 03FE 03FE",
	$"C1C0 E1C0 F1C0 F9C0 FDF8 FFF8 FFF8 FFFC"
	$"FFFE FFFF FFFF EFFF CFFF 87FF 07FF 03FF",
	{1, 1}
};

// OLDNAME: OleTypes.r

type 'CSTR' {
	cstring;
};


// OLDNAME: OleOutline.r

resource 'CSTR' (kOutlineFormat_CSTR, locked, preload) {
	"Outline Data"
};

resource 'CSTR' (kOutlineResult_CSTR, locked, preload) {
	"Outline Data"
};

resource 'CSTR' (kTextFormat_CSTR, locked, preload) {
	"Text"
};

resource 'CSTR' (kTextResult_CSTR, locked, preload) {
	"text"
};

resource 'CSTR' (kNewNamePrefix_CSTR, purgeable) {
	"Object"
};

resource 'CSTR' (kEmbeddedObjectFormat_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kEmbeddedObjectResult_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kPictFormat_CSTR, locked, preload) {
	"Picture (Metafile)"
};

resource 'CSTR' (kPictResult_CSTR, locked, preload) {
	"a static picture"
};

resource 'CSTR' (kDIBFormat_CSTR, locked, preload) {
	"Picture (DIB)"
};

resource 'CSTR' (kDIBResult_CSTR, locked, preload) {
	"a static picture"
};

resource 'CSTR' (kBitmapFormat_CSTR, locked, preload) {
	"Picture (Bitmap)"
};

resource 'CSTR' (kBitmapResult_CSTR, locked, preload) {
	"as a static picture"
};

resource 'CSTR' (kLinkSourceFormat_CSTR, locked, preload) {
	"%s"
};

resource 'CSTR' (kLinkSourceResult_CSTR, locked, preload) {
	"%s"
};

resource 'CURS' (kCursorBackwardResize, preload) {
	$"0000 0000 0000 1E00 1C00 1C00 1200 0100"
	$"0090 0070 0070 00F0",
	$"0000 0000 3F00 3F00 3E00 3E00 3F00 3398"
	$"01F8 00F8 00F8 01F8 01F8",
	{7, 7}
};

resource 'CURS' (kCursorForwardResize, preload) {
	$"0000 0000 0000 00F0 0070 0070 0090 0100"
	$"1200 1C00 1C00 1E",
	$"0000 0000 01F8 01F8 00F8 00F8 01F8 3398"
	$"3F00 3E00 3E00 3F00 3F",
	{7, 7}
};

resource 'CURS' (kCursorHorizResize, preload) {
	$"0000 0000 0000 0000 0000 1010 3018 7FFC"
	$"3018 1010",
	$"0000 0000 0000 0000 1830 3838 7FFC FFFE"
	$"7FFC 3838 1830",
	{7, 7}
};

resource 'CURS' (kCursorVertResize, preload) {
	$"0000 0100 0380 07C0 0100 0100 0100 0100"
	$"0100 0100 0100 07C0 0380 01",
	$"0100 0380 07C0 0FE0 0FE0 0380 0380 0380"
	$"0380 0380 0FE0 0FE0 07C0 0380 01",
	{7, 7}
};

// OLDNAME: OutlineContainer.r

resource 'SIZE' (-1)
{
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,
	multiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreChildDiedEvents,
	is32BitCompatible,
	isHighLevelEventAware,
	localAndRemoteHLEvents,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	kPrefSize * 1024,
	kMinSize * 1024
};

resource 'CSTR' (kObjectNamePrefix_CSTR, purgeable)
{
	"Object"
};

resource 'STR ' (kTemporaryFileNamePrefix_STR, purgeable)
{
	"Outline"
};

resource 'MENU' (kApple_MENU, preload, nonpurgeable)
{
	kApple_MENU, textMenuProc,
	0b1111111111111111111111111111101,
	enabled, apple,
	{
#if !qOleInPlace
		"About Outline Container...", noicon, nokey, nomark, plain;
#else
		"About Outline InPlace Container...", noicon, noKey, nomark, plain;
#endif
		"-", noicon, nokey, nomark, plain
	}
};

resource 'MENU' (kEdit_MENU, preload, nonpurgeable)
{
	kEdit_MENU, textMenuProc,
	0b0000000000000000000000000000000,
	enabled, "Edit",
	 {
		"Undo", noicon, "Z", nomark, plain;
		"-", noicon, nokey, nomark, plain;
		"Cut", noicon, "X", nomark, plain;
		"Copy", noicon, "C", nomark, plain;
		"Paste", noicon, "V", nomark, plain;
		"Clear", noicon, "B", nomark, plain;
		"Select All", noicon, "A", nomark, plain;
		"-", noicon, nokey, nomark, plain;
		"Paste Link", noicon, "D", nomark, plain;
		"Paste Special...", noicon, nokey, nomark, plain;
		"Insert Object...", noicon, "I", nomark, plain;
		"Links...", noicon, nokey, nomark, plain;
		"-", noicon, nokey, nomark, plain;
		"Object", noicon, hierarchicalMenu, kObject_MENU_Char, plain;
	}
};

resource 'MENU' (kObject_MENU, preload, nonpurgeable)
{
	kObject_MENU, textMenuProc,
	0b0000000000000000000000000000000,
	enabled, "",
	{
	}
};

resource kMenuItemToCmdResType (kMenuItemToCmdResID, preload, nonpurgeable)
{
	{
		kApple_MENU, 1, cmdAbout;

		kFile_Menu, 1, cmdNew;
		kFile_Menu, 2, cmdOpen;
		kFile_Menu, 4, cmdClose;
		kFile_Menu, 5, cmdSave;
		kFile_Menu, 6, cmdSaveAs;
		kFile_Menu, 7, cmdRevert;
		kFile_Menu, 9, cmdPageSetup;
		kFile_Menu, 10, cmdPrint;
		kFile_Menu, 12, cmdQuit;

		kEdit_MENU, 1, cmdUndo;
		kEdit_MENU, 3, cmdCut;
		kEdit_MENU, 4, cmdCopy;
		kEdit_MENU, 5, cmdPaste;
		kEdit_MENU, 6, cmdClear;
		kEdit_MENU, 7, cmdSelectAll;
		kEdit_MENU, 9, cmdPasteLink;
		kEdit_MENU, 10, cmdPasteSpecial;
		kEdit_MENU, 11, cmdInsertObject;
		kEdit_MENU, 12, cmdLinks;
		kEdit_MENU, 14, cmdObject;
		
		kLines_MENU, 1, cmdNewLine;
		kLines_MENU, 2, cmdIndentLine;
		kLines_MENU, 3, cmdUnIndentLine;

		kName_MENU, 1, cmdShowName;

		kOptions_MENU, 1, cmdToolbar;
		kOptions_MENU, 2, cmdFormulaBar;
		kOptions_MENU, 3, cmdHeadings;

		kToolbar_MENU, 1, cmdToolbarAtTop;
		kToolbar_MENU, 2, cmdToolbarAtBottom;
		kToolbar_MENU, 3, cmdToolbarFloating;
		kToolbar_MENU, 4, cmdToolbarHidden;

		kFormulaBar_MENU, 1, cmdFormulaBarAtTop;
		kFormulaBar_MENU, 2, cmdFormulaBarAtBottom;
		kFormulaBar_MENU, 3, cmdFormulaBarFloating;

		kHeadings_MENU, 1, cmdHeadingsShow;
		kHeadings_MENU, 2, cmdHeadingsHide;

#if qDebug
		kDebug_MENU, 1, cmdAsserts;
		kDebug_MENU, 2, cmdRejectMessages;
#endif
	}
};

#if qOleInPlace

type 'OTIC' as 'STR ';

resource 'OTIC' (0) {
	"OLE 2.0 In-Place Container Sample Code"
};

resource 'BNDL' (128) {
	'OTIC',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		}
	}
};

data 'FREF' (128) {
	$"4150 504C 0000 00"                                  /* APPL... */
};

resource 'icl4' (128) {
	$"0000 0000 0000 0000 0000 0000 00FF 0000"
	$"0000 0000 0000 0000 0000 0000 0F2F 0000"
	$"0000 0000 0000 0000 0000 0000 F2F0 0000"
	$"0000 0000 0000 0000 0000 000F 2F00 0000"
	$"0000 0000 0000 0000 0000 00F2 F000 0000"
	$"0000 000F F000 0000 0000 0F2F 0000 0000"
	$"00FF FFF4 FFFF FFFF FFFF F2FF FFFF 0000"
	$"00F0 FF44 FDBD BDBD F00F 2FFF BDBF 0000"
	$"00F0 F474 FBDB DBDF 0CF2 F000 FBDF 0000"
	$"0FFF 4744 FFFF FFF0 CF2F 0000 0FFF 0000"
	$"FFF4 7474 F000 0F0C F2FC 0000 000F FFF0"
	$"FFF7 4744 FDDD DFCF 2FFC 0000 0000 F34F"
	$"0F74 7474 F000 0FF2 F0FC 0000 0000 F43F"
	$"FFF7 4744 FDDD DFFF FFFC 0000 0000 F34F"
	$"FFF4 7474 F000 FF00 0000 0000 0000 F43F"
	$"0F47 4744 FDDF 2FFF F000 00CF FCCF 434F"
	$"FFF4 7474 FF0F F000 0FFF FFF0 0FF4 343F"
	$"FFF7 4744 FDFD DDDD DDDD DDD0 0F43 43F0"
	$"0F74 7474 FEEE EE00 0000 0000 00FF FF00"
	$"FFF7 4744 FDDD DDDD DDDD DDD0 00FF 0000"
	$"FFF4 7474 FEEE EEEE E000 0000 00FF 0000"
	$"0F47 4744 FDDD DDDD DDDD DDD0 00FF 0000"
	$"FFF4 7474 FEEE EEEE EEE0 0000 00FF 0000"
	$"FFF7 474F DDDD DDDD DDDD DDD0 00FF 0000"
	$"0F74 74F0 0000 EEEE EEEE 0000 00FF 0000"
	$"FFF7 4FDD DDDD DDDD DDDD DDD0 00FF 0000"
	$"FFF4 F000 0000 0000 0EEE EE00 00FF 0000"
	$"0F4F 0000 0000 0000 000E EEEE E0FF 0000"
	$"03FF FFFF FFFF FFFF FFFF FFFF FF4F 0000"
	$"0334 FFFF FFFF FFFF FFFF FFFF FFF0 0000"
	$"0003 3333 3333 3333 3333 3333 33"
};

resource 'icl8' (128) {
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 FFFF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 00FF 17FF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 FF17 FF00 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 00FF 17FF 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 FF17 FF00 0000 0000 0000"
	$"0000 0000 0000 00FF FF00 0000 0000 0000"
	$"0000 0000 00FF 17FF 0000 0000 0000 0000"
	$"0000 FFFF FFFF FF20 FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FF17 FFFF FFFF FFFF 0000 0000"
	$"0000 FF00 FFFF 2020 FFF9 5EF9 5EF9 5EF9"
	$"FF00 00FF 17FF FFFF 5EF9 5EFF 0000 0000"
	$"0000 FF00 FF20 C020 FF5E F95E F95E F9FF"
	$"002B FF17 FF00 0000 FF5E F9FF 0000 0000"
	$"00FF FFFF 20C0 2020 FFFF FFFF FFFF FF00"
	$"2BFF 17FF 0000 0000 00FF FFFF 0000 0000"
	$"FFFF FF20 C020 C020 FF00 0000 00FF 002B"
	$"FF17 FF2B 0000 0000 0000 00FF FFFF FF00"
	$"FFFF FFC0 20C0 2020 FFF9 F9F9 F9FF 2BFF"
	$"17FF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF C020 C020 C020 FF00 0000 00FF FF17"
	$"FF00 FF2B 0000 0000 0000 0000 FF20 D8FF"
	$"FFFF FFC0 20C0 2020 FFF9 F9F9 F9FF FFFF"
	$"FFFF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"FFFF FF20 C020 C020 FF00 0000 FFFF 0000"
	$"0000 0000 0000 0000 0000 0000 FF20 D8FF"
	$"00FF 20C0 20C0 2020 FFF9 F9FF 17FF FFFF"
	$"FF00 0000 0000 2BFF FF2B 2BFF 20D8 20FF"
	$"FFFF FF20 C020 C020 FFFF 00FF FF00 0000"
	$"00FF FFFF FFFF FF00 00FF FF20 D820 D8FF"
	$"FFFF FFC0 20C0 2020 FFF9 FFF9 F9F9 F9F9"
	$"F9F9 F9F9 F9F9 F900 00FF 20D8 20D8 FF00"
	$"00FF C020 C020 C020 FFFC FCFC FCFC 0000"
	$"0000 0000 0000 0000 0000 FFFF FFFF 0000"
	$"FFFF FFC0 20C0 2020 FFF9 F9F9 F9F9 F9F9"
	$"F9F9 F9F9 F9F9 F900 0000 FFFF 0000 0000"
	$"FFFF FF20 C020 C020 FFFC FCFC FCFC FCFC"
	$"FC00 0000 0000 0000 0000 FFFF 0000 0000"
	$"00FF 20C0 20C0 2020 FFF9 F9F9 F9F9 F9F9"
	$"F9F9 F9F9 F9F9 F900 0000 FFFF 0000 0000"
	$"FFFF FF20 C020 C020 FFFC FCFC FCFC FCFC"
	$"FCFC FC00 0000 0000 0000 FFFF 0000 0000"
	$"FFFF FFC0 20C0 20FF F9F9 F9F9 F9F9 F9F9"
	$"F9F9 F9F9 F9F9 F900 0000 FFFF 0000 0000"
	$"00FF C020 C020 FF00 0000 0000 FCFC FCFC"
	$"FCFC FCFC 0000 0000 0000 FFFF 0000 0000"
	$"FFFF FFC0 20FF F9F9 F9F9 F9F9 F9F9 F9F9"
	$"F9F9 F9F9 F9F9 F900 0000 FFFF 0000 0000"
	$"FFFF FF20 FF00 0000 0000 0000 0000 0000"
	$"00FC FCFC FCFC 0000 0000 FFFF 0000 0000"
	$"00FF 20FF 0000 0000 0000 0000 0000 0000"
	$"0000 00FC FCFC FCFC FC00 FFFF 0000 0000"
	$"00D8 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF 20FF 0000 0000"
	$"00D8 D820 FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"0000 00D8 D8D8 D8D8 D8D8 D8D8 D8D8 D8D8"
	$"D8D8 D8D8 D8D8 D8D8 D8D8"
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0030 0000 0050 0000 00A0 0000 0140"
		$"0000 0280 0180 0500 3EFF FBF0 2DAB 9750"
		$"3AFF 28F0 75FE 5070 EA84 A01E F5AD 600D"
		$"6A86 A009 F5AF E00D EA8C 0009 55B7 8195"
		$"EAD8 7E61 F5AA AA56 6AFC 003C F5AA AA30"
		$"EAFF 8030 55AA AA30 EAFF E030 F5AA AA30"
		$"6A0F F030 F6AA AA30 E800 7C30 5000 1FB0"
		$"3FFF FFD0 1FFF FFE0",
		/* [2] */
		$"0000 0030 0000 0070 0000 00E0 0000 01C0"
		$"0000 0380 0180 0700 3FFF FFF0 3FFF FFF0"
		$"3FFF FFF0 7FFF FFF0 FFFF FFFE FFFF FFFF"
		$"7FFF FFFF FFFF FFFF FFFF FFFF 7FFF FFFF"
		$"FFFF FFFF FFFF FFFE 7FFF FFFC FFFF FFF0"
		$"FFFF FFF0 7FFF FFF0 FFFF FFF0 FFFF FFF0"
		$"7FFF FFF0 FFFF FFF0 FFFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFE0 1FFF FFC0"
	}
};

resource 'ics#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"000C 081C FFFF BAB5 6F6F DAC7 EBC3 5B9F"
		$"E8FD DA87 69A5 DFC5 F2E5 60AF 7FFC",
		/* [2] */
		$"000C 081C FFFE FFFE FFFE FFFF FFFF 7FFF"
		$"FFFF FFFE 7FFC FFFC FFFC 7FFC FFFC 7FF8"
	}
};

resource 'ics4' (128) {
	$"0000 0000 0000 FF00 0000 F000 000F 2F00"
	$"FFDF FDDD DDF2 FDD0 F0FF FBBB FF2F 00F0"
	$"FFF7 FDDD 02F0 FFF0 FF77 FCF0 2F00 0FFF"
	$"FF77 F0FF FF00 00E4 0F77 FC2F 000F 00E4"
	$"FF77 FEFC FFFF FF4F FF77 F0EE 0000 0FF0"
	$"0F77 FCCC CCC0 0F00 FF7F F00E EE00 0F00"
	$"FFFF 0CCC CCC0 0F00 0FF0 0000 EEEE FF00"
	$"3FFF FFFF FFFF FF00 0333 3333 3333 30"
};

resource 'ics8' (128) {
	$"0000 0000 0000 0000 0000 0000 FFFF 0000"
	$"0000 0000 FF00 0000 0000 00FF 17FF 0000"
	$"FFFF F9FF FFF9 F9F9 F9F9 FF17 FFF9 F900"
	$"FF00 FFFF FF5E 5E5E FFFF 17FF 0000 FF00"
	$"FFFF FFC0 FFF9 F9F9 0017 FF00 FFFF FF00"
	$"FFFF C0C0 FF2B FF00 17FF 0000 00FF FFFF"
	$"FFFF C0C0 FF00 FFFF FFFF 0000 0000 FC20"
	$"00FF C0C0 FF2B 17FF 0000 00FF 0000 FC20"
	$"FFFF C0C0 FFFC FF2B FFFF FFFF FFFF 20FF"
	$"FFFF C0C0 FF00 FCFC 0000 0000 00FF FF00"
	$"00FF C0C0 FF2B 2B2B 2B2B 2B00 00FF 0000"
	$"FFFF C0FF FF00 00FC FCFC 0000 00FF 0000"
	$"FFFF FFFF 002B 2B2B 2B2B 2B00 00FF 0000"
	$"00FF FF00 0000 0000 FCFC FCFC FFFF 0000"
	$"D8FF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
	$"00D8 D8D8 D8D8 D8D8 D8D8 D8D8 D8"
};

#else	// qOleInPlace

type 'OUTC' as 'STR ';

resource 'OUTC' (0) {
	"OLE 2.0 Container Sample Code"
};

resource 'BNDL' (128) {
	'OUTC',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		}
	}
};

data 'FREF' (128) {
	$"4150 504C 0000 00"                                  /* APPL... */
};

resource 'icl4' (128) {
	$"0000 0000 0000 0000 0000 0000 00FF 0000"
	$"0000 0000 0000 0000 0000 0000 0F2F 0000"
	$"0000 0000 0000 0000 0000 0000 F2F0 0000"
	$"0000 0000 0000 0000 0000 000F 2F00 0000"
	$"0000 0000 0000 0000 0000 00F2 F000 0000"
	$"0000 0000 0000 0000 0000 0F2F 0000 0000"
	$"0FFF FFFF FFFF FFFF FFFF F2FF FFFF 0000"
	$"0F00 FDBD BDBD BDBD F00F 2FFF BFBF 0000"
	$"0F00 FBDB DBDB DBDF 0CF2 F000 FFDF 0000"
	$"0FFF FFFF FFFF FFF0 CF2F 0000 0FFF 0000"
	$"0F00 0000 0000 0F0C F2FC 0000 000F FFF0"
	$"0FCC CCCC CCCC CFCF 2FFC 0000 0000 F34F"
	$"0F00 0000 0000 0FF2 F0FC 0000 0000 F43F"
	$"0F00 CCCC CCCC CFFF FFFC 0000 0000 F34F"
	$"0F00 0000 0000 FF00 0000 0000 0000 F43F"
	$"0F00 CCCC CCCF 2FFF F000 00CF FCCF 434F"
	$"0F00 0000 0F0F F000 0FFF FFF0 0FF4 343F"
	$"0F00 0000 CCEC CCCC CCCC CCC0 0F43 43F0"
	$"0F00 0000 0EEE EE00 0000 0000 00FF FF00"
	$"0F0C CCCC CCCC CCCC CCCC CCCC C0FF 0000"
	$"0F00 0000 CEEE EEE0 0000 0000 000F 0000"
	$"0F00 000C CCCC CCCC CCCC CCCC CCCF 0000"
	$"0F00 0000 0EEE EEEE E000 0000 000F 0000"
	$"0F00 000C CCCC CCCC CCCC CCCC C00F 0000"
	$"0F00 0000 0000 EEEE EE00 0000 000F 0000"
	$"0F00 000C CCCC CCCC CCCC CCC0 000F 0000"
	$"0F00 0000 0000 000E EEEE EE00 000F 0000"
	$"0F00 0000 000C CCCC CEEE EEEE E00F 0000"
	$"0FFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (128) {
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 FFFF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 00FF 17FF 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 FF17 FF00 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 00FF 17FF 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 FF17 FF00 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 00FF 17FF 0000 0000 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FF17 FFFF FFFF FFFF 0000 0000"
	$"00FF 0000 FFF9 5EF9 5EF9 5EF9 5EF9 5EF9"
	$"FF00 00FF 17FF FFFF 5EFF 5EFF 0000 0000"
	$"00FF 0000 FF5E F95E F95E F95E F95E F9FF"
	$"002B FF17 FF00 0000 FFFF F9FF 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
	$"2BFF 17FF 0000 0000 00FF FFFF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 00FF 002B"
	$"FF17 FF2B 0000 0000 0000 00FF FFFF FF00"
	$"00FF 2B2B 2B2B 2B2B 2B2B 2B2B 2BFF 2BFF"
	$"17FF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF 0000 0000 0000 0000 0000 00FF FF17"
	$"FF00 FF2B 0000 0000 0000 0000 FF20 D8FF"
	$"00FF 0000 2B2B 2B2B 2B2B 2B2B 2BFF FFFF"
	$"FFFF FF2B 0000 0000 0000 0000 FFD8 20FF"
	$"00FF 0000 0000 0000 0000 0000 FFFF 0000"
	$"0000 0000 0000 0000 0000 0000 FF20 D8FF"
	$"00FF 0000 2B2B 2B2B 2B2B 2BFF 17FF FFFF"
	$"FF00 0000 0000 2BFF FF2B 2BFF 20D8 20FF"
	$"00FF 0000 0000 0000 00FF 00FF FF00 0000"
	$"00FF FFFF FFFF FF00 00FF FF20 D820 D8FF"
	$"00FF 0000 0000 0000 2B2B FC2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B00 00FF 20D8 20D8 FF00"
	$"00FF 0000 0000 0000 00FC FCFC FCFC 0000"
	$"0000 0000 0000 0000 0000 FFFF FFFF 0000"
	$"00FF 002B 2B2B 2B2B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B00 FFFF 0000 0000"
	$"00FF 0000 0000 0000 2BFC FCFC FCFC FC00"
	$"0000 0000 0000 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B2B 2BFF 0000 0000"
	$"00FF 0000 0000 0000 00FC FCFC FCFC FCFC"
	$"FC00 0000 0000 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B2B 2B00 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 FCFC FCFC"
	$"FCFC 0000 0000 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 002B 2B2B 2B2B 2B2B 2B2B"
	$"2B2B 2B2B 2B2B 2B00 0000 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 0000 00FC"
	$"FCFC FCFC FCFC 0000 0000 00FF 0000 0000"
	$"00FF 0000 0000 0000 0000 002B 2B2B 2B2B"
	$"2BFC FCFC FCFC FCFC FC00 00FF 0000 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0030 0000 0050 0000 00A0 0000 0140"
		$"0000 0280 0000 0500 7FFF FBF0 4AAA 9750"
		$"4D55 28D0 7FFE 5070 4004 A01E 5555 600D"
		$"4006 A009 4557 E00D 400C 0009 4557 8195"
		$"4058 7E61 4035 5456 407C 003C 4555 5510"
		$"407E 0010 4155 5550 407F 8010 4155 5510"
		$"400F C010 4155 5510 4001 FC10 4015 7F90"
		$"7FFF FFF0",
		/* [2] */
		$"0000 0030 0000 0070 0000 00E0 0000 01C0"
		$"0000 0380 0000 0700 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFFE 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF"
		$"7FFF FFFF 7FFF FFFE 7FFF FFFC 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0 7FFF FFF0 7FFF FFF0 7FFF FFF0"
		$"7FFF FFF0"
	}
};

resource 'ics#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"000C 001C 0038 FFFC BF6C E2C7 97C3 AB1F"
		$"8EFF 8506 8704 8284 83C4 815C FFFC",
		/* [2] */
		$"000C 001C 0038 FFFC FFFC FFFF FFFF FFFF"
		$"FFFF FFFE FFFC FFFC FFFC FFFC FFFC"
	}
};

resource 'ics4' (128) {
	$"0000 0000 0000 FF00 0000 0000 000F 2F00"
	$"0000 0000 00F2 F000 FFFF FFFF FF2F FF00"
	$"F0FF FFFF 02F0 FF00 FFCC CCF0 2F00 0FFF"
	$"F0CC CCF2 FF00 00FF F0CC CF2F 000F FF4F"
	$"F000 FFFC FFFF FF4F FCCC EEEC CCCC CFF0"
	$"F00C EEEE CCCC CF00 F00C EEEE ECCC CF00"
	$"F00C CCEE ECCC 0F00 F000 0CCE EEEE EF00"
	$"FFFF FFFF FFFF FF"
};

resource 'ics8' (128) {
	$"0000 0000 0000 0000 0000 0000 FFFF 0000"
	$"0000 0000 0000 0000 0000 00FF 17FF 0000"
	$"0000 0000 0000 0000 0000 FF17 FF00 0000"
	$"FFFF FFFF FFFF FFFF FFFF 17FF FFFF 0000"
	$"FF00 FFFF FFFF FFFF 0017 FF00 FFFF 0000"
	$"FFFF 2B2B 2B2B FF00 17FF 0000 00FF FFFF"
	$"FF00 2B2B 2B2B FF17 FFFF 0000 0000 FFFF"
	$"FF00 2B2B 2BFF 17FF 0000 00FF FFFF 20FF"
	$"FF00 0000 FFFF FF2B FFFF FFFF FFFF 20FF"
	$"FF2B 2B2B FCFC FC2B 2B2B 2B2B 2BFF FF00"
	$"FF00 002B FCFC FCFC 2B2B 2B2B 2BFF 0000"
	$"FF00 002B FCFC FCFC FC2B 2B2B 2BFF 0000"
	$"FF00 002B 2B2B FCFC FC2B 2B2B 00FF 0000"
	$"FF00 0000 002B 2BFC FCFC FCFC FCFF 0000"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

#endif
