// zap.h : declaration of the CZap class.  This class handles zapping the files
//          of a project off of which we're basing the generated custom
//          AppWizard The files are zapped into templates used by the generated
//          custom AppWizard.  Class and file names from the original project
//          are "macroized" so that the generated custom AppWizard will create
//          new projects with class and file names derived from the new
//          projects' names, rather than from the original project's name.
//
// Copyright (c) 1985-1995, Microsoft Corporation. All rights reserved.
//

#ifndef __ZAP_H__
#define __ZAP_H__

// Each ZRDRootType represents a string derived from the original project
//  name.
#define NUM_ROOT_TYPES 10
enum ZRDRootType
{
	ZRD_ROOT,
	ZRD_ROOT_UPR,
	ZRD_SAFE_ROOT,
	ZRD_CLASS,
	ZRD_FILEBASE,
	ZRD_DOC,
	ZRD_DOC_UPR,
	ZRD_MAC_TYPE,
	ZRD_R_FILE,
	ZRD_R_FILE_UPR,
};

// Each instance of this structure contains a recipe for matching one
//  string in the original project, and replacing it with a string
//  to be put in the generated custom AppWizard's templates.
struct ZapRawData
{
	// Strings composing item to match
	LPCTSTR lpszPre;
	ZRDRootType nRootType;
	LPCTSTR lpszPost;

	// Strings to replace it with
	LPCTSTR lpszReplace[2];
};

class OutputStream;

// There is only one CZap instantiated at a time.  It corresponds to the
//  project off of which we're basing the custom AppWizard.  It's capable of
//  macroizing ("zapping") individual filenames (ZapFileName) and
//  template-izing ("zapping") entire files (ZapFile).
class CZap
{
public:
	CZap()
		{ m_hFile = NULL; m_hMapping = NULL; m_pStrMatches = NULL; m_bBinary = FALSE; m_posTplName = NULL; }
	~CZap();
	
	void DefineGeneratedNewprojInfMacro() 
		{ DefineStringMacro(_T("GENERATED_NEWPROJ_INF_FILES"), m_strGeneratedNewProjInfo); }

	LPCTSTR LoadFile(LPCTSTR lpszResource, DWORD& dwSize);
	void ZapFile(LPCTSTR lpszInput, DWORD dwSize, OutputStream* pOutput);
	void ZapFileName(LPCTSTR lpszFileName, CString& rStrZappedFile, int iReplace = 0);
	void UnloadFile();
	void SetRoot(LPCTSTR lpszDir, LPCTSTR lpszRoot);

protected:
	void InitMatches();
	void FreeMatches();
	void ZapLine(CString& strLine, int iReplace = 0);
	void AddToNewProjInf();

	BOOL m_bBinary;				// Is the file we've loaded binary?
	HANDLE m_hFile;				// Handle to file we're currently zapping
	HANDLE m_hMapping;			// Handle to memory-mapping of that file
	LPCTSTR m_lpszFile;			// Pointer to view of file mapped to memory
	CString m_strRoot;			// Remembers name of project; used for matching
								//  strings to replace
	POSITION m_posTplName;		// Current POSITION in the TemplateNames CStringList.
	CString m_strRootDir;		// Remembers root directory of original project;
								//  used to preserve nesting from original project
								//  files to projects generated by the custom
								//  AppWizard we're generating
	CString m_strSubdir;		// Nesting level of file we're currently zapping.
	CString m_strFile;			// Name of file we're currently zapping
	CString m_strBaseFileName;	// Base name (no path/ext) of that file
	CString m_strFileExt;		// Extension of that file

	CString m_strGeneratedNewProjInfo;	// Value to set "GENERATED_NEWPROJ_INF_FILES"
										//  macro to.

	CString* m_pStrMatches;		// Array of strings to search for when zapping a
								//  file.  The entries correspond 1-to-1 with
								//  entries of the zrdGeneral[] array defined
								//  in zap.cpp
};
		
#endif //__ZAP_H__
