VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "VisDataClass"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "VisData Data Access Server Application"
'---------------------------------------------------
'this method is used as a call from the
'add-in stub VDADD16.EXE or VDADD32.EXE
'---------------------------------------------------
Sub VDSetAddIn(ByVal VBInst As Object)
  On Error GoTo LVDErr
    
  'this sets the VB instance handle
  'that is used by the DataFormDesigner form
  Set gobjIDEAppInst = VBInst
  frmMDI.mnuUDataFormDesigner.Visible = True
  frmMDI.mnuDBMakeAddIn.Visible = False
  frmMDI.WindowState = vbNormal
  
  Exit Sub
    
LVDErr:
  MsgBox Error$
  Exit Sub
    
End Sub


'---------------------------------------------------
'this method can be called from
'any vb app through OLE automation as in:
'Dim x As Object
'Set x = CreateObject("VisData.VisDataClass")
'x.VDOpenDatabase "c:\vb\biblio.mdb", "", False
'---------------------------------------------------
Sub VDOpenDatabase(sDatabaseName As String, sConnect As String, bReadOnly As Integer)
  On Error GoTo RVDErr
    
  frmMDI.mnuUDataFormDesigner.Visible = False
  frmMDI.mnuDBMakeAddIn.Visible = False
  
  gnReadOnly = bReadOnly
  If Len(sConnect) = 0 Then
    'must be a Jet MDB
    gsDataType = gsJETMDB
    gsDBName = sDatabaseName
    OpenLocalDB True
  ElseIf UCase(Left(sConnect, 5)) = gsSQLDB Then
    'must be an ODBC database
    gsDataType = gsSQLDB
    'set the other variables for ODBC
    GetODBCConnectParts sConnect
    gsDBName = sDatabaseName
    SendKeys "%FOO{Enter}"
  Else
    'must be a local ISAM database
    gsDataType = sConnect
    gsDBName = sDatabaseName
    OpenLocalDB True
  End If
  
  Exit Sub
    
RVDErr:
  MsgBox Error$
  Exit Sub
  
End Sub

'---------------------------------------------------
'this method simply closes visdata from the client
'---------------------------------------------------
Sub VDClose()
  ShutDownVisData
End Sub


