VERSION 4.00
Begin VB.Form frmAttachments 
   Caption         =   "Attachments"
   ClientHeight    =   2895
   ClientLeft      =   5565
   ClientTop       =   2175
   ClientWidth     =   6075
   Height          =   3300
   HelpContextID   =   2016086
   Icon            =   "ATTACH.frx":0000
   Left            =   5505
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MDIChild        =   -1  'True
   ScaleHeight     =   2895
   ScaleWidth      =   6075
   Top             =   1830
   Width           =   6195
   Begin VB.PictureBox picButtons 
      Align           =   2  'Align Bottom
      Appearance      =   0  'Flat
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   405
      Left            =   0
      ScaleHeight     =   405
      ScaleWidth      =   6075
      TabIndex        =   0
      Top             =   2490
      Width           =   6075
      Begin VB.CommandButton cmdNew 
         Caption         =   "&New"
         Height          =   330
         Left            =   120
         TabIndex        =   3
         Top             =   45
         Width           =   1815
      End
      Begin VB.CommandButton cmdReAttach 
         Caption         =   "&ReAttach"
         Height          =   330
         Left            =   2160
         TabIndex        =   2
         Top             =   45
         Width           =   1845
      End
      Begin VB.CommandButton cmdClose 
         Caption         =   "&Close"
         Height          =   330
         Left            =   4200
         TabIndex        =   1
         Top             =   45
         Width           =   1845
      End
   End
   Begin MSGrid.Grid grdTables 
      Height          =   2415
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   6015
      _version        =   65536
      _extentx        =   10610
      _extenty        =   4260
      _stockprops     =   77
      backcolor       =   16777215
      cols            =   3
   End
End
Attribute VB_Name = "frmAttachments"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Sub cmdClose_Click()
  Unload Me
End Sub

Sub cmdNew_Click()
  frmNewAttach.Show vbModal
End Sub

Sub cmdReAttach_Click()
  On Error GoTo REAErr
  
  Dim i As Integer
  Dim sTmp As String
  
  SetHourglass

  'execute the refreshlink method on all the selected items
  grdTables.Col = 0
  For i = grdTables.SelStartRow To grdTables.SelEndRow
    grdTables.Row = i
    sTmp = grdTables.Text
    gdbCurrentDB.TableDefs(sTmp).RefreshLink
  Next
  
  MsgBar gsNULL_STR, False
  Screen.MousePointer = vbDefault
  Exit Sub
  
REAErr:
  ShowError
  If i > 0 Then
    Resume Next    'try to continue
  End If
  Exit Sub
  
End Sub

Sub Form_Load()
  On Error GoTo FLErr

  Dim tdf As TableDef
  Dim i As Integer
  
  'center it on the MDI form
  Me.Top = (frmMDI.Height - Me.Height) \ 2
  Me.Left = (frmMDI.Width - Me.Width) \ 2
  
  With grdTables
    .Row = 0
    .Col = 0
    .Text = "Table"
    .Col = 1
    .Text = "SourceTable"
    .Col = 2
    .Text = "Connect"
    .FixedRows = 1
    .ColWidth(0) = 1500
    .ColWidth(1) = 2000
    .ColWidth(2) = .Width - 3600
  End With

  'get the attached tables from the tabledefs collection
  For Each tdf In gdbCurrentDB.TableDefs
    If (tdf.Attributes And dbAttachedTable) = dbAttachedTable Or _
       (tdf.Attributes And dbAttachedODBC) = dbAttachedODBC Then
      grdTables.AddItem tdf.Name & Chr(9) & tdf.SourceTableName & Chr(9) & tdf.Connect
    End If
  Next
  
  'remove the first blank row if there are some entries
  If grdTables.Rows > 2 Then
    grdTables.RemoveItem 1
  End If
  
  Screen.MousePointer = vbDefault
  Exit Sub
  
FLErr:
  ShowError
  Unload Me
  Exit Sub
  
End Sub

Private Sub grdTables_DblClick()
  On Error GoTo GTDErr
  
  SetHourglass
  grdTables.Col = 0
  gdbCurrentDB.TableDefs(grdTables.Text).RefreshLink
  Screen.MousePointer = vbDefault
  Exit Sub
  
GTDErr:
  ShowError
  Exit Sub

End Sub


Sub grdTables_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  On Error GoTo TMErr
  Dim sTmp As String

  If Button <> 2 Then Exit Sub
  
  grdTables.Row = Y \ frmAttachments.grdTables.RowHeight(0)
  grdTables.Col = 0
  sTmp = grdTables.Text
  ShowProperties "TableDef", gdbCurrentDB.TableDefs(sTmp)
  Exit Sub
  
TMErr:
  ShowError
  Exit Sub

End Sub


Private Sub Form_Resize()
  On Error Resume Next
  
  If Me.WindowState = 1 Then Exit Sub
  
  grdTables.Width = Me.Width - 375
  grdTables.Height = Me.Height - 970
  grdTables.ColWidth(2) = grdTables.Width - 3600
End Sub
