VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "FileEventSpy"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "File Event Spy Sample Addin"
'Place to keep our instance of the VBInstance object that was passed to us in
'ConnectAddIn.
Private ThisInstance As VBIDE.Application

'Place to keep the menuline object given to us when we installed out menu line
'in Visual Basic.
Private SpyMenuLine As VBIDE.MenuLine

'Make our instance of the event handler object.
Private SpyHandler As New SpyEvents

'Place to store the connect cookies that are handed to us.
Private FileEventID As Long
Private AfterClickID As Long


Sub ConnectAddIn(VBInstance As VBIDE.Application)
    'Stash away our copy of VBInstance, so we can disconnect from the right
    'instance of Visual Basic
    Set ThisInstance = VBInstance
    
    'Install our menu line in Visual Basic's Add-In menu
    Set SpyMenuLine = ThisInstance.AddInMenu.MenuItems.Add("File Event Spy")
    
    'Pass our event handler the MenuLine.
    Set SpyHandler.SpyMenuLine = SpyMenuLine
    
    'Connect in our event handler to the menu line
    AfterClickID = SpyMenuLine.ConnectEvents(SpyHandler)
    
    'Let SpyHandler Check the menu line.
    SpyHandler.AfterClick
    
    'Connect our event handler to the FileControl object
    FileEventID = ThisInstance.FileControl.ConnectEvents(SpyHandler)
End Sub

Sub DisconnectAddIn(Mode As Integer)
    SpyMenuLine.DisconnectEvents AfterClickID
    With ThisInstance
        .FileControl.DisconnectEvents FileEventID
        .AddInMenu.MenuItems.Remove SpyMenuLine
    End With
End Sub
