Attribute VB_Name = "MainModule"
Option Explicit
#If Win16 Then
    Declare Function WritePrivateProfileString Lib "KERNEL" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$) As Integer
    Declare Function GetPrivateProfileString Lib "KERNEL" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Integer, ByVal FileName$) As Integer
#Else
    Declare Function WritePrivateProfileString Lib "Kernel32" Alias "WritePrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$) As Long
    Declare Function GetPrivateProfileString Lib "Kernel32" Alias "GetPrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Long, ByVal FileName$) As Long
#End If

'How many entries are we going to allow in the ListBox? One modification
'is to let the user set the number of entries we keep.
Private NumberOfEntries As Long

Sub Main()
Dim ReturnString As String
Dim Section$
'--- Check to see if we are in the VB.INI File.  If not, Add ourselves to the INI file
    #If Win16 Then
        Section$ = "Add-Ins16"
    #Else
        Section$ = "Add-Ins32"
    #End If
    'Check to see if the Align.Connector entry is already in the VB.INI file.  Add if not.
    ReturnString = String$(255, Chr$(0))
    GetPrivateProfileString Section$, "SpySample.FileEventSpy", "NotFound", ReturnString, Len(ReturnString) + 1, "VB.INI"
    If Left(ReturnString, InStr(ReturnString, Chr(0)) - 1) = "NotFound" Then
        WritePrivateProfileString Section$, "SpySample.FileEventSpy", "0", "VB.INI"
    End If
    
    NumberOfEntries = 100
End Sub

'This subroutine essentially adds the passed string to the listbox, and then
'deletes the oldest entries if the number of entries exceeds the limit
Sub AddEntry(AddString As String)
Dim i%
    With SpyShow.lstEvents
        .AddItem AddString
        For i% = 1 To .ListCount - NumberOfEntries
            .RemoveItem 0
        Next i%
        .ListIndex = .ListCount - 1
    End With
End Sub

