Attribute VB_Name = "Module1"
Dim ArrayNum As Integer     ' Index value for the menu control array mnuFileArray.
Public Filename As String   ' This variable keeps track of the filename information for opening and closing files.

Sub CloseFile(Filename As String)
Dim F As Integer
On Error GoTo CloseError    ' If there is an error, display the error message below.
    
    If Dir(Filename) <> "" Then         ' File already exists, so ask if the user wants to overwrite the file.
        response = MsgBox("Overwrite existing file?", vbYesNo + vbQuestion + vbDefaultButton2)
        If response = vbNo Then Exit Sub
    End If
    F = FreeFile
    Open Filename For Output As F       ' Otherwise, open the filename for output.
    Print #F, frmEditor!txtEdit.Text    ' Print the current text to the opened file.
    Close F                             ' Close the file.
    Filename = "Untitled"               ' Reset the caption of the main form.
    Exit Sub
CloseError:
    MsgBox "Error occurred while trying to close file, please retry.", 48
    Exit Sub
End Sub

Sub DoUnLoadPreCheck(UnloadMode As Integer)
    If UnloadMode = 0 Or UnloadMode = 3 Then
            Unload frmAbout
            Unload frmEditor
            End
    End If
End Sub

Sub OpenFile(Filename As String)
Dim F As Integer
    If "Text Editor: " + Filename = frmEditor.Caption Then  ' Avoid opening a file if it is already loaded.
        Exit Sub
    Else
        On Error GoTo errhandler
            F = FreeFile
            Open Filename For Input As F                    ' Open the file selected in the File Open About dialog box.
            frmEditor!txtEdit.Text = Input(LOF(F), F)
            Close F                                         ' Close the file.
            ' frmEditor.mnuFileItem(3).Enabled = True         ' Enable the Close command on the File menu.
            UpdateMenu
            frmEditor.Caption = "Text Editor: " + Filename
            Exit Sub
    End If
errhandler:
        MsgBox "Error encountered while trying to open file, please retry.", 48, "Text Editor"
        Close F
        Exit Sub
End Sub

Sub UpdateMenu()
    frmEditor.mnuFileArray(0).Visible = True            ' Make the initial element visible and display separator bar.
    ArrayNum = ArrayNum + 1                             ' Increment the Index property of the menu control array.
    ' Check to see if Filename is already on the menu list.
    For i = 0 To ArrayNum - 1
        If frmEditor.mnuFileArray(i).Caption = Filename Then
            ArrayNum = ArrayNum - 1
            Exit Sub
        End If
    Next i
    
    ' If filename is not on the menu list, add the menu item.
    Load frmEditor.mnuFileArray(ArrayNum)               ' Create a new menu control.
    frmEditor.mnuFileArray(ArrayNum).Caption = Filename ' Set the caption of the new menu item.
    frmEditor.mnuFileArray(ArrayNum).Visible = True     ' Make the new menu item visible.
End Sub

