VERSION 4.00
Begin VB.Form frmNotePad 
   Caption         =   "Untitled"
   ClientHeight    =   3990
   ClientLeft      =   1515
   ClientTop       =   3315
   ClientWidth     =   5670
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   4680
   Left            =   1455
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3990
   ScaleMode       =   0  'User
   ScaleWidth      =   101.07
   Top             =   2685
   Visible         =   0   'False
   Width           =   5790
   Begin VB.TextBox Text1 
      Height          =   3975
      HideSelection   =   0   'False
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   0
      Width           =   5655
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      WindowList      =   -1  'True
      Begin VB.Menu mnuFNew 
         Caption         =   "&New"
      End
      Begin VB.Menu mnuFOpen 
         Caption         =   "&Open..."
      End
      Begin VB.Menu mnuFClose 
         Caption         =   "&Close"
      End
      Begin VB.Menu mnuFSave 
         Caption         =   "&Save"
      End
      Begin VB.Menu mnuFSaveAs 
         Caption         =   "Save &As..."
      End
      Begin VB.Menu mnuFSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFExit 
         Caption         =   "E&xit"
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "-"
         Index           =   0
         Visible         =   0   'False
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "RecentFile1"
         Index           =   1
         Visible         =   0   'False
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "RecentFile2"
         Index           =   2
         Visible         =   0   'False
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "RecentFile3"
         Index           =   3
         Visible         =   0   'False
      End
      Begin VB.Menu mnuRecentFile 
         Caption         =   "RecentFile4"
         Index           =   4
         Visible         =   0   'False
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuECut 
         Caption         =   "Cu&t"
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuECopy 
         Caption         =   "&Copy"
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuEPaste 
         Caption         =   "&Paste"
         Shortcut        =   ^V
      End
      Begin VB.Menu mnuEDelete 
         Caption         =   "De&lete"
         Shortcut        =   {DEL}
      End
      Begin VB.Menu mnuESep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuESelectAll 
         Caption         =   "Select &All"
      End
      Begin VB.Menu mnuETime 
         Caption         =   "Time/&Date"
      End
   End
   Begin VB.Menu mnuSearch 
      Caption         =   "&Search"
      Begin VB.Menu mnuSFind 
         Caption         =   "&Find"
      End
      Begin VB.Menu mnuSFindNext 
         Caption         =   "Find &Next"
         Shortcut        =   {F3}
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuOToolbar 
         Caption         =   "&Toolbar"
      End
      Begin VB.Menu mnuFont 
         Caption         =   "&Font"
         Begin VB.Menu mnuFontName 
            Caption         =   "FontName"
            Index           =   0
         End
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&Window"
      Begin VB.Menu mnuWCascade 
         Caption         =   "&Cascade"
      End
      Begin VB.Menu mnuWTile 
         Caption         =   "&Tile"
      End
      Begin VB.Menu mnuWArrange 
         Caption         =   "&Arrange Icons"
      End
   End
End
Attribute VB_Name = "frmNotePad"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Private Sub Form_Load()
    Dim i As Integer
    
    mnuFontName(0).Caption = Screen.Fonts(0)
    For i = 1 To Screen.FontCount - 1
        Load mnuFontName(i)
        mnuFontName(0).Caption = Screen.Fonts(i)
    Next
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Dim Msg, Filename, NL
    Dim Response As Integer

    If FState(Me.Tag).Dirty Then
        Filename = Me.Caption
        NL = Chr(10) & Chr(13)
        Msg = "The text in [" & Filename & "] has changed."
        Msg = Msg & NL
        Msg = Msg & "Do you want to save the changes?"
        Response = MsgBox(Msg, 51, frmMDI.Caption)
        Select Case Response
            Case 6      ' User chose Yes.
            If Left(Me.Caption, 8) = "Untitled" Then
            ' The file hasn't been saved yet.
            Filename = "untitled.txt"
            ' Get the filename, and then call the save procedure, GetFileName.
                Filename = GetFileName(Filename)
            Else
                ' The form's Caption contains the name of the open file.
                Filename = Me.Caption
            End If
            ' Call the save procedure. If Filename = Empty, then
            ' the user chose Cancel in the Save As dialog box; otherwise,
            ' save the file.
            If Filename <> "" Then
                SaveFileAs Filename
            End If
            Case 7      ' User chose No. Unload the file.
                Cancel = False
            Case 2      ' User chose Cancel. Cancel the unload.
                Cancel = True
        End Select
    End If
End Sub

Private Sub Form_Resize()
    If WindowState <> 1 And ScaleHeight <> 0 Then
        Text1.Visible = False
        Text1.Height = ScaleHeight
        Text1.Width = ScaleWidth
        
        Text1.Visible = True
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    FState(Me.Tag).Deleted = True
    
    ' Hide the toolbar edit buttons if no notepad windows exist.
    If Not AnyPadsLeft() Then
        frmMDI!imgcutbutton.Visible = False
        frmMDI!imgcopybutton.Visible = False
        frmMDI!imgPasteButton.Visible = False
        gToolsHidden = True
        GetRecentFiles
    End If
End Sub

Private Sub mnuECopy_Click()
    EditCopyProc
End Sub

Private Sub mnuECut_Click()
    EditCutProc
End Sub

Private Sub mnuEDelete_Click()
    ' If the mouse pointer is not at the end of the notepad...
    If Screen.ActiveControl.SelStart <> Len(Screen.ActiveControl.TEXT) Then
        ' If nothing is selected, extend the selection by one.
        If Screen.ActiveControl.SelLength = 0 Then
            Screen.ActiveControl.SelLength = 1
            ' If the mouse pointer is on a blank line, extend the selection by two.
            If Asc(Screen.ActiveControl.SelText) = 13 Then
                Screen.ActiveControl.SelLength = 2
            End If
        End If
        ' Delete the selected text.
        Screen.ActiveControl.SelText = ""
    End If
End Sub

Private Sub mnuEPaste_Click()
    EditPasteProc
End Sub

Private Sub mnuESelectAll_Click()
    frmMDI.ActiveForm.Text1.SelStart = 0
    frmMDI.ActiveForm.Text1.SelLength = Len(frmMDI.ActiveForm.Text1.TEXT)
End Sub

Private Sub mnuETime_Click()
    Dim TimeStr As String, DateStr As String
    
    Text1.SelText = Now
End Sub

Private Sub mnuFClose_Click()
    Unload Me
End Sub

Private Sub mnuFExit_Click()
    ' Unloading the MDI form invokes the QueryUnload event
    ' for each child form, and then the MDI form.
    ' Setting the Cancel argument to True in any of the
    ' QueryUnload events cancels the unload.
    Unload frmMDI
End Sub

Private Sub mnuFNew_Click()
    FileNew
End Sub

Private Sub mnuFontName_Click(index As Integer)
    Text1.FontName = mnuFontName(index).Caption
End Sub

Private Sub mnuFOpen_Click()
    FOpenProc
End Sub

Private Sub mnuFSave_Click()
    Dim Filename As String

    If Left(Me.Caption, 8) = "Untitled" Then
        ' The file hasn't been saved yet.
        ' Get the filename, and then call the save procedure, GetFileName.
        Filename = GetFileName(Filename)
    Else
        ' The form's Caption contains the name of the open file.
        Filename = Me.Caption
    End If
    ' Call the save procedure. If Filename = Empty, then
    ' the user chose Cancel in the Save As dialog box; otherwise,
    ' save the file.
    If Filename <> "" Then
        SaveFileAs Filename
    End If
End Sub

Private Sub mnuFSaveAs_Click()
    Dim SaveFileName As String
    Dim DefaultName As String
    DefaultName = Me.Caption
    If Left(Me.Caption, 8) = "Untitled" Then
        ' The file hasn't been saved yet.
        ' Get the filename, and then call the save procedure, SaveFileName.
        
        SaveFileName = GetFileName("Untitled.txt")
        If SaveFileName <> "" Then SaveFileAs (SaveFileName)
        ' Update the list of recently opened files in the File menu control array.
        UpdateFileMenu (SaveFileName)
    Else
        ' The form's Caption contains the name of the open file.
        
        SaveFileName = GetFileName(DefaultName)
        If SaveFileName <> "" Then SaveFileAs (SaveFileName)
        ' Update the list of recently opened files in the File menu control array.
        UpdateFileMenu (SaveFileName)
    End If

End Sub

Private Sub mnuOptions_Click()
    mnuOToolbar.Checked = frmMDI!picToolbar.Visible
End Sub

Private Sub mnuOToolbar_Click()
    OptionsToolbarProc Me
End Sub

Private Sub mnuRecentFile_Click(index As Integer)
    OpenFile (mnuRecentFile(index).Caption)
    ' Update the list of recently opened files in the File menu control array.
    GetRecentFiles
End Sub

Private Sub mnuSFind_Click()
    If Me!Text1.SelText <> "" Then
        frmFind!Text1.TEXT = Me!Text1.SelText
    Else
        frmFind!Text1.TEXT = gFindString
    End If
    gFirstTime = True
    If (gFindCase) Then
        frmFind.chkCase = 1
    End If
    frmFind.Show
End Sub

Private Sub mnuSFindNext_Click()
    If Len(gFindString) > 0 Then
        FindIt
    Else
        mnuSFind_Click
    End If
End Sub

Private Sub mnuWArrange_Click()
    frmMDI.Arrange vbArrangeIcons
End Sub

Private Sub mnuWCascade_Click()
    frmMDI.Arrange vbCascade
End Sub

Private Sub mnuWTile_Click()
    frmMDI.Arrange vbTileHorizontal
End Sub

Private Sub Text1_Change()
    FState(Me.Tag).Dirty = True
End Sub

Private Sub Text1_GotFocus()
    If frmFind.Visible Then
        frmFind.ZOrder 0
    End If
End Sub

