/*
 * Decompiled with CFR 0.152.
 */
package dev.net;

import dev.lang.BitTools;
import dev.net.NetworkDiscoveryListener;
import dev.net.NetworkDiscoveryPacket;
import dev.util.StringUtils;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class NetworkDiscovery {
    public static final int SOCKET_PORT_NUMBER = 1972;
    public static final int SOCKET_TIME_TO_LIVE = 2;
    public static final String SOCKET_GROUP_NAME;
    public static final int SOCKET_BUFFER_SIZE = 1024;
    public static final int SOCKET_TIMEOUT = 0;
    public static String SIGNTATURE;
    protected int fSocketPortNumber;
    protected int fSocketTimeToLive;
    protected String fSocketGroupName;
    protected int fSocketBufferSize;
    protected int fSocketTimeout;
    protected String fHostID;
    protected long fTimestamp;
    protected String fSignature;
    protected MulticastSocket fMulticastSocket;
    protected Thread fRunnerTread;
    protected boolean fRunning;
    public static final int MODE_CLIENT = 1;
    public static final int MODE_SERVER = 2;
    protected int fMode;
    protected Set fDiscoveredAddresses;
    protected InetAddress fGroup;
    protected boolean fVerbose;
    public static final int POLICY_SAME_HOST = 1;
    public static final int POLICY_DIFFERENT_HOST = 2;
    public static final int POLICY_ANY_HOST = 3;
    protected int fCheckHostPolicy;
    transient Vector fNetworkDiscoveryListeners;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String A;

    public NetworkDiscovery() throws UnknownHostException {
        this(null, 3);
    }

    public NetworkDiscovery(int n) throws UnknownHostException {
        this(null, n);
    }

    public NetworkDiscovery(String string, int n) throws UnknownHostException {
        block5: {
            block4: {
                boolean bl = z;
                this.fSocketPortNumber = 1972;
                this.fSocketTimeToLive = 2;
                this.fSocketGroupName = SOCKET_GROUP_NAME;
                this.fSocketBufferSize = 1024;
                this.fSocketTimeout = 0;
                this.fTimestamp = System.currentTimeMillis();
                this.fSignature = SIGNTATURE;
                this.fRunning = false;
                this.fMode = 3;
                this.fDiscoveredAddresses = new HashSet();
                this.fVerbose = false;
                this.fCheckHostPolicy = 3;
                if (string != null) break block4;
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.fHostID = inetAddress.getHostName();
                if (this.fHostID == null) {
                    this.fHostID = inetAddress.getHostAddress();
                }
                if (!bl) break block5;
                StringUtils.z = !StringUtils.z;
            }
            this.fHostID = string;
        }
        this.fMode = n;
    }

    public int getSocketTimeout() {
        return this.fSocketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.fSocketTimeout = n;
    }

    public int getSocketBufferSize() {
        return this.fSocketBufferSize;
    }

    public void setSocketBufferSize(int n) {
        this.fSocketBufferSize = n;
    }

    public String getSocketGroupName() {
        return this.fSocketGroupName;
    }

    public void setSocketGroupName(String string) {
        this.fSocketGroupName = string;
        this.fGroup = null;
    }

    public int getSocketTimeToLive() {
        return this.fSocketTimeToLive;
    }

    public void setSocketTimeToLive(int n) {
        this.fSocketTimeToLive = n;
    }

    public int getSocketPortNumber() {
        return this.fSocketPortNumber;
    }

    public void setSocketPortNumber(int n) {
        this.fSocketPortNumber = n;
    }

    public synchronized void start() {
        if (this.fRunning) {
            return;
        }
        this.fDiscoveredAddresses.clear();
        this.createMulticastSocket();
        this.fRunnerTread = new Thread(new Runnable(){

            public void run() {
                boolean bl = z;
                try {
                    int n = NetworkDiscovery.this.fMulticastSocket.getReceiveBufferSize();
                    DatagramPacket datagramPacket = new DatagramPacket(new byte[n], n);
                    NetworkDiscovery.this.fRunning = true;
                    try {
                        while (NetworkDiscovery.this.fRunning) {
                            NetworkDiscovery.this.fMulticastSocket.receive(datagramPacket);
                            NetworkDiscovery.this.processDatagramPacket(datagramPacket);
                            if (!bl) continue;
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    NetworkDiscovery.this.stop();
                }
                catch (Exception exception) {
                    NetworkDiscovery.this.error(exception);
                }
                NetworkDiscovery.this.fireNetworkDiscoveryFinished();
            }
        });
        this.fRunnerTread.start();
        this.fireNetworkDiscoveryStarted();
        if (this.isClient()) {
            this.send(this.createRequest());
        }
    }

    public boolean isClient() {
        return BitTools.checkBit(this.fMode, 1);
    }

    public boolean isServer() {
        return BitTools.checkBit(this.fMode, 2);
    }

    private void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (!this.fRunning) {
            return;
        }
        this.fRunning = false;
        if (this.fRunnerTread.isAlive()) {
            this.fRunnerTread.interrupt();
        }
        this.releaseMulticastSocket();
    }

    protected boolean isRunning() {
        return this.fRunning;
    }

    public Set getDiscoveredAddresses() {
        return this.fDiscoveredAddresses;
    }

    protected void send(NetworkDiscoveryPacket networkDiscoveryPacket) {
        if (this.fMulticastSocket == null) {
            throw new IllegalStateException(A);
        }
        try {
            byte[] byArray = networkDiscoveryPacket.toByteArray();
            networkDiscoveryPacket.fromByteArray(byArray, 0, byArray.length);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.getGroup(), this.getSocketPortNumber());
            this.fMulticastSocket.send(datagramPacket);
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    protected synchronized void createMulticastSocket() {
        try {
            this.fMulticastSocket = new MulticastSocket(this.getSocketPortNumber());
            this.fMulticastSocket.setTimeToLive(this.getSocketTimeToLive());
            this.fMulticastSocket.setSendBufferSize(this.getSocketBufferSize());
            this.fMulticastSocket.setSoTimeout(this.getSocketTimeout());
            this.fMulticastSocket.joinGroup(this.getGroup());
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    protected InetAddress getGroup() throws UnknownHostException {
        if (this.fGroup == null) {
            this.fGroup = InetAddress.getByName(this.getSocketGroupName());
        }
        return this.fGroup;
    }

    protected synchronized void releaseMulticastSocket() {
        try {
            this.fMulticastSocket.leaveGroup(this.getGroup());
            this.fMulticastSocket.close();
            this.fMulticastSocket = null;
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void processDatagramPacket(DatagramPacket datagramPacket) {
        block5: {
            try {
                NetworkDiscoveryPacket networkDiscoveryPacket = new NetworkDiscoveryPacket();
                networkDiscoveryPacket.fromByteArray(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                if (networkDiscoveryPacket.getType() == 0) {
                    if (!this.isServer() || !this.checkRequest(networkDiscoveryPacket)) break block5;
                    this.send(this.createResponce());
                    if (!z) break block5;
                }
                if (networkDiscoveryPacket.getType() == 1 && this.isClient() && this.checkResponce(networkDiscoveryPacket)) {
                    InetAddress inetAddress = datagramPacket.getAddress();
                    this.fDiscoveredAddresses.add(inetAddress);
                    this.fireAddressDiscovered(inetAddress, networkDiscoveryPacket);
                }
            }
            catch (Throwable throwable) {
                this.error(throwable);
            }
        }
    }

    public int getCheckHostPolicy() {
        return this.fCheckHostPolicy;
    }

    public void setCheckHostPolicy(int n) {
        this.fCheckHostPolicy = n;
    }

    protected boolean checkResponce(NetworkDiscoveryPacket networkDiscoveryPacket) {
        return this.acceptsResponce(networkDiscoveryPacket) && this.checkHost(networkDiscoveryPacket) && networkDiscoveryPacket.getTimestamp() != this.fTimestamp;
    }

    protected boolean checkRequest(NetworkDiscoveryPacket networkDiscoveryPacket) {
        return this.acceptsRequest(networkDiscoveryPacket);
    }

    protected boolean checkHost(NetworkDiscoveryPacket networkDiscoveryPacket) {
        boolean bl = true;
        switch (this.fCheckHostPolicy) {
            case 1: {
                bl = StringUtils.equals(networkDiscoveryPacket.getHostID(), this.fHostID);
                if (!z) break;
            }
            case 2: {
                bl = !StringUtils.equals(networkDiscoveryPacket.getHostID(), this.fHostID);
            }
        }
        return bl;
    }

    protected NetworkDiscoveryPacket createResponce() {
        return new NetworkDiscoveryPacket(this.fSignature, this.fHostID, this.fTimestamp, 1);
    }

    protected boolean acceptsResponce(NetworkDiscoveryPacket networkDiscoveryPacket) {
        return this.fSignature.equals(networkDiscoveryPacket.getSignature());
    }

    protected boolean acceptsRequest(NetworkDiscoveryPacket networkDiscoveryPacket) {
        return this.fSignature.equals(networkDiscoveryPacket.getSignature());
    }

    protected NetworkDiscoveryPacket createRequest() {
        return new NetworkDiscoveryPacket(this.fSignature, this.fHostID, this.fTimestamp, 0);
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String string) {
        this.fSignature = string;
    }

    public static void main(String[] stringArray) {
        try {
            NetworkDiscovery networkDiscovery = new NetworkDiscovery();
            networkDiscovery.start();
            Thread.currentThread();
            Thread.sleep(5000L);
            networkDiscovery.stop();
            networkDiscovery.getDiscoveredAddresses().toString();
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addNetworkDiscoveryListener(NetworkDiscoveryListener networkDiscoveryListener) {
        Vector vector;
        Vector vector2 = vector = this.fNetworkDiscoveryListeners == null ? new Vector(2) : (Vector)this.fNetworkDiscoveryListeners.clone();
        if (!vector.contains(networkDiscoveryListener)) {
            vector.addElement(networkDiscoveryListener);
            this.fNetworkDiscoveryListeners = vector;
        }
    }

    public synchronized void removeNetworkDiscoveryListener(NetworkDiscoveryListener networkDiscoveryListener) {
        if (this.fNetworkDiscoveryListeners != null && this.fNetworkDiscoveryListeners.contains(networkDiscoveryListener)) {
            Vector vector = (Vector)this.fNetworkDiscoveryListeners.clone();
            vector.removeElement(networkDiscoveryListener);
            this.fNetworkDiscoveryListeners = vector;
        }
    }

    protected void fireNetworkDiscoveryStarted() {
        boolean bl = z;
        if (this.fNetworkDiscoveryListeners != null) {
            Vector vector = this.fNetworkDiscoveryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((NetworkDiscoveryListener)vector.elementAt(i)).networkDiscoveryStarted(this);
                if (!bl) continue;
            }
        }
    }

    protected void fireNetworkDiscoveryFinished() {
        boolean bl = z;
        if (this.fNetworkDiscoveryListeners != null) {
            Vector vector = this.fNetworkDiscoveryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((NetworkDiscoveryListener)vector.elementAt(i)).networkDiscoveryFinished(this);
                if (!bl) continue;
            }
        }
    }

    protected void fireAddressDiscovered(InetAddress inetAddress, NetworkDiscoveryPacket networkDiscoveryPacket) {
        boolean bl = z;
        if (this.fNetworkDiscoveryListeners != null) {
            Vector vector = this.fNetworkDiscoveryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((NetworkDiscoveryListener)vector.elementAt(i)).addressDiscovered(this, inetAddress, networkDiscoveryPacket);
                if (!bl) continue;
            }
        }
    }

    static {
        Object var0 = null;
        A = NetworkDiscovery.z(NetworkDiscovery.z("Q\u0011JS!m\u001f\u001e@'l\u0017QR+m\r\u001eM=?\u001aQPnl\u0000_V:z\u0010"));
        var0 = null;
        SOCKET_GROUP_NAME = NetworkDiscovery.z(NetworkDiscovery.z("-F\n\n~1D\u0010\u0015"));
        var0 = null;
        SIGNTATURE = NetworkDiscovery.z(NetworkDiscovery.z("5^\u0014\u0004\u0000z\u0000IK<tYzM=|\u001bHA<fT\u0014\u000ed"));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x4E);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 31;
                            break;
                        }
                        case 1: {
                            n6 = 116;
                            break;
                        }
                        case 2: {
                            n6 = 62;
                            break;
                        }
                        case 3: {
                            n6 = 36;
                            break;
                        }
                        default: {
                            n6 = 78;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

