/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.JFormattedTextFieldEx;
import dev.gui.JTextFieldEx;
import dev.gui.wizard.FormComponent;
import dev.gui.wizard.FormComponentDef;
import dev.gui.wizard.FormWizardPane;
import dev.gui.wizard.TextFieldFormComponentDef;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class TextFieldFormComponent
implements FormComponent {
    protected JLabel lblCaption;
    protected JTextComponent edtValue;
    protected TextFieldFormComponentDef fFormComponentDef;

    public static String getValue(JTextComponent jTextComponent) {
        if (jTextComponent instanceof JFormattedTextField) {
            Object object = null;
            try {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)jTextComponent;
                jFormattedTextField.commitEdit();
                object = jFormattedTextField.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return object != null ? object.toString() : null;
        }
        return jTextComponent.getText();
    }

    public static void setValue(JTextComponent jTextComponent, String string) {
        if (jTextComponent instanceof JFormattedTextField) {
            ((JFormattedTextField)jTextComponent).setValue(string);
        } else {
            jTextComponent.setText(string);
        }
    }

    public static boolean checkValid(JTextComponent jTextComponent, boolean bl) {
        boolean bl2 = false;
        if (jTextComponent instanceof JFormattedTextField) {
            try {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)jTextComponent;
                jFormattedTextField.commitEdit();
                Object object = jFormattedTextField.getValue();
                bl2 = bl ? !StringUtils.noValue(object != null ? object.toString() : null) : true;
            }
            catch (ParseException parseException) {}
        } else {
            bl2 = !bl || !StringUtils.noValue(jTextComponent.getText());
        }
        return bl2;
    }

    public TextFieldFormComponent(TextFieldFormComponentDef textFieldFormComponentDef) {
        this.fFormComponentDef = textFieldFormComponentDef;
    }

    public FormComponentDef getFormComponentDef() {
        return this.fFormComponentDef;
    }

    public String getValue() {
        return TextFieldFormComponent.getValue(this.edtValue);
    }

    public void setValue(String string) {
        TextFieldFormComponent.setValue(this.edtValue, string);
    }

    public boolean checkValid() {
        return TextFieldFormComponent.checkValid(this.edtValue, this.fFormComponentDef.isMandatory());
    }

    public boolean requestFocus() {
        this.edtValue.requestFocus();
        return true;
    }

    public int createFormComponents(FormWizardPane formWizardPane, int n) {
        String string = formWizardPane.expandMacro(this.fFormComponentDef.getName());
        if (!StringUtils.noValue(string)) {
            string = string + ":";
        }
        this.lblCaption = new JLabel(string);
        String string2 = formWizardPane.expandMacro(this.fFormComponentDef.getMask());
        this.edtValue = !StringUtils.noValue(string2) ? new JFormattedTextFieldEx(string2) : new JTextFieldEx();
        this.edtValue.setText(formWizardPane.expandMacro(this.fFormComponentDef.getDefaultValue()));
        String string3 = formWizardPane.expandMacro(this.fFormComponentDef.getDescription());
        this.edtValue.setToolTipText(!StringUtils.noValue(string3) ? string3 : null);
        Insets insets = (Insets)this.fFormComponentDef.getInsets().clone();
        insets.top += 5;
        formWizardPane.getContentPane().add((Component)this.lblCaption, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(insets.top, insets.left, insets.bottom, 0), 0, 0));
        formWizardPane.getContentPane().add((Component)this.edtValue, new GridBagConstraints(1, n, 10, 1, 1.0, 0.0, 17, 2, new Insets(insets.top, 5, insets.bottom, insets.right), 0, 0));
        return 1;
    }

    public void releaseFormComponents(FormWizardPane formWizardPane) {
        formWizardPane.getContentPane().remove(this.edtValue);
        this.edtValue = null;
        formWizardPane.getContentPane().remove(this.lblCaption);
        this.lblCaption = null;
    }
}

