/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.FlowLayoutEx;
import dev.gui.LafColor;
import dev.gui.ResourceUtils;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class ProgressWizardPane
extends WizardPane {
    static ResourceBundle res;
    protected WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    protected JPanel pnlOperations = new JPanel();
    protected FlowLayoutEx fOperationsLayout = new FlowLayoutEx(0, 0, 5);
    protected JPanel pnlFill = new JPanel();
    protected HashMap fOperationsMap = new HashMap();
    protected List fOperations = new ArrayList();
    public static final ImageIcon ICON_READY;
    public static final ImageIcon ICON_COMPLETED;
    public static final ImageIcon ICON_FAILED;
    public static final ImageIcon ICON_IN_PROGRESS;
    private static final /* synthetic */ String[] z;

    public boolean canFinish() {
        return false;
    }

    public int finish() {
        return 0;
    }

    public boolean canBack() {
        return false;
    }

    public boolean canNext() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    protected String getCancelPrompt() {
        return res.getString(z[5]);
    }

    public boolean cancel() {
        boolean bl;
        String string = this.getCancelPrompt();
        boolean bl2 = string != null ? WizardDialog.prompt(this, string) == 0 : (bl = true);
        if (bl) {
            bl = this.stop();
        }
        return bl;
    }

    public void activate(String string) {
        super.activate(string);
        this.start();
    }

    public boolean start() {
        this.setOperationStatus(1);
        return true;
    }

    public abstract boolean stop();

    public List getOperations() {
        return Collections.unmodifiableList(this.fOperations);
    }

    public void addOperation(Operation operation, int n) {
        OperationPane operationPane = new OperationPane();
        operationPane.setVisible(operation.isVisible());
        this.fOperationsMap.put(operation, operationPane);
        operation.addPropertyChangeListener(this);
        this.fOperationsMap.put(operation, operationPane);
        this.fOperations.add(n, operation);
        this.pnlOperations.add((Component)operationPane, n);
        this.updateLabel(operation);
    }

    protected void updateLabel(Operation operation) {
        this.getLabel(operation).setOperation(operation);
    }

    public void addOperation(Operation operation) {
        this.addOperation(operation, this.fOperations.size());
    }

    public void removeOperation(Operation operation) {
        if (this.fOperationsMap.containsKey(operation)) {
            JLabel jLabel = (JLabel)this.fOperationsMap.remove(operation);
            this.fOperations.remove(operation);
            operation.removePropertyChangeListener(this);
            this.pnlOperations.remove(jLabel);
        }
    }

    public OperationPane getLabel(Operation operation) {
        return (OperationPane)this.fOperationsMap.get(operation);
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() instanceof Operation) {
            final Operation operation = (Operation)propertyChangeEvent.getSource();
            if (SwingUtilities.isEventDispatchThread()) {
                if (propertyChangeEvent.getPropertyName().equals(z[4])) {
                    this.getLabel(operation).setVisible(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                    this.pnlOperations.revalidate();
                } else {
                    this.updateLabel(operation);
                    this.pnlOperations.revalidate();
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    private static final /* synthetic */ String z;

                    public void run() {
                        if (propertyChangeEvent.getPropertyName().equals(z)) {
                            ProgressWizardPane.this.getLabel(operation).setVisible(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                            ProgressWizardPane.this.pnlOperations.revalidate();
                        } else {
                            ProgressWizardPane.this.updateLabel(operation);
                            ProgressWizardPane.this.pnlOperations.revalidate();
                        }
                    }

                    /*
                     * Handled impossible loop by duplicating code
                     * Enabled aggressive block sorting
                     */
                    static {
                        char[] cArray;
                        block10: {
                            int n;
                            int n2;
                            char[] cArray2;
                            int n3;
                            block9: {
                                Object var0 = null;
                                char[] cArray3 = "9\u007fKa3#s".toCharArray();
                                n3 = 0;
                                int n4 = cArray3.length;
                                cArray2 = cArray3;
                                n2 = n4;
                                if (n4 <= 1) break block9;
                                cArray = cArray2;
                                n = n2;
                                if (n2 <= n3) break block10;
                            }
                            do {
                                char[] cArray4 = cArray2;
                                char[] cArray5 = cArray2;
                                int n5 = n3;
                                while (true) {
                                    int n6;
                                    char c = cArray4[n5];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n6 = 79;
                                            break;
                                        }
                                        case 1: {
                                            n6 = 22;
                                            break;
                                        }
                                        case 2: {
                                            n6 = 56;
                                            break;
                                        }
                                        case 3: {
                                            n6 = 8;
                                            break;
                                        }
                                        default: {
                                            n6 = 81;
                                        }
                                    }
                                    cArray4[n5] = (char)(c ^ n6);
                                    ++n3;
                                    cArray2 = cArray5;
                                    n2 = n2;
                                    if (n2 != 0) break;
                                    cArray5 = cArray2;
                                    n = n2;
                                    n5 = n2;
                                    cArray4 = cArray2;
                                }
                                cArray = cArray2;
                                n = n2;
                            } while (n2 > n3);
                        }
                        z = new String(cArray).intern();
                    }
                });
            }
        }
    }

    public void setOperationStatus(int n) {
        for (Operation operation : this.fOperations) {
            operation.setStatus(n);
        }
    }

    protected static ImageIcon getOperationStatusIcon(int n) {
        ImageIcon imageIcon = null;
        switch (n) {
            case 1: {
                imageIcon = ICON_READY;
                break;
            }
            case 2: {
                imageIcon = ICON_IN_PROGRESS;
                break;
            }
            case 3: {
                imageIcon = ICON_COMPLETED;
                break;
            }
            case 4: {
                imageIcon = ICON_FAILED;
            }
        }
        return imageIcon;
    }

    protected String getOperationStatusText(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = z[0];
                break;
            }
            case 2: {
                string = z[1];
                break;
            }
            case 3: {
                string = z[2];
                break;
            }
            case 4: {
                string = z[3];
            }
        }
        return string;
    }

    public ProgressWizardPane() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.fOperationsLayout.setOrientation(1);
        this.fOperationsLayout.setRetainComponentsWidth(true);
        this.pnlOperations.setLayout(this.fOperationsLayout);
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.pnlFill.setPreferredSize(new Dimension(0, 0));
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlOperations, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    static {
        String[] stringArray = new String[6];
        Object var0 = null;
        stringArray[0] = ProgressWizardPane.z(ProgressWizardPane.z("zf7\u000e."));
        var0 = null;
        stringArray[1] = ProgressWizardPane.z(ProgressWizardPane.z("zv8\u0004>fdXdY"));
        var0 = null;
        stringArray[2] = ProgressWizardPane.z(ProgressWizardPane.z("kl;\u001a;mw3\u000e"));
        var0 = null;
        stringArray[3] = ProgressWizardPane.z(ProgressWizardPane.z("nb?\u00062l"));
        var0 = null;
        stringArray[4] = ProgressWizardPane.z(ProgressWizardPane.z("^J\u0005#\u0015DF"));
        var0 = null;
        stringArray[5] = ProgressWizardPane.z(ProgressWizardPane.z("kB\u0018)\u0012D|&8\u0018ES\u0002"));
        z = stringArray;
        var0 = null;
        res = ResourceBundle.getBundle(ProgressWizardPane.z(ProgressWizardPane.z("LF\u0000d\u0010]JX=\u001eRB\u0004.YzF\u0005")));
        var0 = null;
        ICON_READY = ResourceUtils.loadImageIcon(ProgressWizardPane.class, ProgressWizardPane.z(ProgressWizardPane.z("ZF\u0005e\u0005MB\u00123YXM\u0011")));
        var0 = null;
        ICON_COMPLETED = ResourceUtils.loadImageIcon(ProgressWizardPane.class, ProgressWizardPane.z(ProgressWizardPane.z("ZF\u0005e\u0014GN\u0006&\u0012\\F\u0012d\u0007FD")));
        var0 = null;
        ICON_FAILED = ResourceUtils.loadImageIcon(ProgressWizardPane.class, ProgressWizardPane.z(ProgressWizardPane.z("ZF\u0005e\u0011IJ\u001a/\u0013\u0006S\u0018-")));
        var0 = null;
        ICON_IN_PROGRESS = ResourceUtils.loadImageIcon(ProgressWizardPane.class, ProgressWizardPane.z(ProgressWizardPane.z("ZF\u0005e\u0003@Q\u0019(\u0015MQX-\u001eN")));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x77);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 40;
                            break;
                        }
                        case 1: {
                            n6 = 35;
                            break;
                        }
                        case 2: {
                            n6 = 118;
                            break;
                        }
                        case 3: {
                            n6 = 74;
                            break;
                        }
                        default: {
                            n6 = 119;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }

    public static class Operation {
        public static final String PROPERTY_STATUS;
        public static final String PROPERTY_NAME;
        public static final String PROPERTY_DESCRIPTION;
        public static final String PROPERTY_STATUS_TEXT;
        public static final String PROPERTY_VISIBLE;
        public static final String PROPERTY_MESSAGE;
        public static final int STATUS_READY = 1;
        public static final int STATUS_IN_PROGRESS = 2;
        public static final int STATUS_COMPLETED = 3;
        public static final int STATUS_FAILED = 4;
        protected PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
        protected int fStatus = 1;
        protected String fName;
        protected String fDescription;
        protected String fStatusText;
        protected boolean fVisible = true;
        protected String fMessage;

        public Operation() {
        }

        public Operation(String string, String string2) {
            this.fName = string;
            this.fDescription = string2;
        }

        protected synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public String getDescription() {
            return this.fDescription;
        }

        public void setDescription(String string) {
            if (!StringUtils.equals(this.fDescription, string)) {
                String string2 = this.fDescription;
                this.fDescription = string;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_DESCRIPTION, string2, this.fDescription);
            }
        }

        public String getMessage() {
            return this.fMessage;
        }

        public void setMessage(String string) {
            if (!StringUtils.equals(this.fMessage, string)) {
                String string2 = this.fMessage;
                this.fMessage = string;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_MESSAGE, string2, this.fMessage);
            }
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String string) {
            if (!StringUtils.equals(this.fName, string)) {
                String string2 = this.fName;
                this.fName = string;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_NAME, string2, this.fName);
            }
        }

        public int getStatus() {
            return this.fStatus;
        }

        public void setStatus(int n) {
            if (this.fStatus != n) {
                int n2 = this.fStatus;
                this.fStatus = n;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_STATUS, n2, this.fStatus);
            }
        }

        public String getStatusText() {
            return this.fStatusText;
        }

        public void setStatusText(String string) {
            if (!StringUtils.equals(this.fStatusText, string)) {
                String string2 = this.fStatusText;
                this.fStatusText = string;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_STATUS_TEXT, string2, this.fStatusText);
            }
        }

        public boolean isVisible() {
            return this.fVisible;
        }

        public void setVisible(boolean bl) {
            if (this.fVisible != bl) {
                this.fVisible = bl;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_VISIBLE, !this.fVisible, this.fVisible);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block65: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block64: {
                    char[] cArray3;
                    Object var0;
                    block63: {
                        int n4;
                        int n5;
                        char[] cArray4;
                        block62: {
                            char[] cArray5;
                            block61: {
                                int n6;
                                int n7;
                                char[] cArray6;
                                block60: {
                                    char[] cArray7;
                                    block59: {
                                        int n8;
                                        int n9;
                                        char[] cArray8;
                                        block58: {
                                            char[] cArray9;
                                            block57: {
                                                int n10;
                                                int n11;
                                                char[] cArray10;
                                                block56: {
                                                    char[] cArray11;
                                                    block55: {
                                                        int n12;
                                                        int n13;
                                                        char[] cArray12;
                                                        block54: {
                                                            var0 = null;
                                                            char[] cArray13 = "\u000b8Cu\u0011\u00114".toCharArray();
                                                            n3 = 0;
                                                            int n14 = cArray13.length;
                                                            cArray12 = cArray13;
                                                            n13 = n14;
                                                            if (n14 <= 1) break block54;
                                                            cArray11 = cArray12;
                                                            n12 = n13;
                                                            if (n13 <= n3) break block55;
                                                        }
                                                        do {
                                                            char[] cArray14 = cArray12;
                                                            char[] cArray15 = cArray12;
                                                            int n15 = n3;
                                                            while (true) {
                                                                int n16;
                                                                char c = cArray14[n15];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n16 = 125;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n16 = 81;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n16 = 48;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n16 = 28;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n16 = 115;
                                                                    }
                                                                }
                                                                cArray14[n15] = (char)(c ^ n16);
                                                                ++n3;
                                                                cArray12 = cArray15;
                                                                n13 = n13;
                                                                if (n13 != 0) break;
                                                                cArray15 = cArray12;
                                                                n12 = n13;
                                                                n15 = n13;
                                                                cArray14 = cArray12;
                                                            }
                                                            cArray11 = cArray12;
                                                            n12 = n13;
                                                        } while (n13 > n3);
                                                    }
                                                    PROPERTY_VISIBLE = new String(cArray11).intern();
                                                    var0 = null;
                                                    char[] cArray16 = "\u00130]y".toCharArray();
                                                    n3 = 0;
                                                    int n17 = cArray16.length;
                                                    cArray10 = cArray16;
                                                    n11 = n17;
                                                    if (n17 <= 1) break block56;
                                                    cArray9 = cArray10;
                                                    n10 = n11;
                                                    if (n11 <= n3) break block57;
                                                }
                                                do {
                                                    char[] cArray17 = cArray10;
                                                    char[] cArray18 = cArray10;
                                                    int n18 = n3;
                                                    while (true) {
                                                        int n19;
                                                        char c = cArray17[n18];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n19 = 125;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n19 = 81;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n19 = 48;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n19 = 28;
                                                                break;
                                                            }
                                                            default: {
                                                                n19 = 115;
                                                            }
                                                        }
                                                        cArray17[n18] = (char)(c ^ n19);
                                                        ++n3;
                                                        cArray10 = cArray18;
                                                        n11 = n11;
                                                        if (n11 != 0) break;
                                                        cArray18 = cArray10;
                                                        n10 = n11;
                                                        n18 = n11;
                                                        cArray17 = cArray10;
                                                    }
                                                    cArray9 = cArray10;
                                                    n10 = n11;
                                                } while (n11 > n3);
                                            }
                                            PROPERTY_NAME = new String(cArray9).intern();
                                            var0 = null;
                                            char[] cArray19 = "\u00104Co\u0012\u001a4".toCharArray();
                                            n3 = 0;
                                            int n20 = cArray19.length;
                                            cArray8 = cArray19;
                                            n9 = n20;
                                            if (n20 <= 1) break block58;
                                            cArray7 = cArray8;
                                            n8 = n9;
                                            if (n9 <= n3) break block59;
                                        }
                                        do {
                                            char[] cArray20 = cArray8;
                                            char[] cArray21 = cArray8;
                                            int n21 = n3;
                                            while (true) {
                                                int n22;
                                                char c = cArray20[n21];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n22 = 125;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n22 = 81;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n22 = 48;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n22 = 28;
                                                        break;
                                                    }
                                                    default: {
                                                        n22 = 115;
                                                    }
                                                }
                                                cArray20[n21] = (char)(c ^ n22);
                                                ++n3;
                                                cArray8 = cArray21;
                                                n9 = n9;
                                                if (n9 != 0) break;
                                                cArray21 = cArray8;
                                                n8 = n9;
                                                n21 = n9;
                                                cArray20 = cArray8;
                                            }
                                            cArray7 = cArray8;
                                            n8 = n9;
                                        } while (n9 > n3);
                                    }
                                    PROPERTY_MESSAGE = new String(cArray7).intern();
                                    var0 = null;
                                    char[] cArray22 = "\u000e%Qh\u0006\u000e".toCharArray();
                                    n3 = 0;
                                    int n23 = cArray22.length;
                                    cArray6 = cArray22;
                                    n7 = n23;
                                    if (n23 <= 1) break block60;
                                    cArray5 = cArray6;
                                    n6 = n7;
                                    if (n7 <= n3) break block61;
                                }
                                do {
                                    char[] cArray23 = cArray6;
                                    char[] cArray24 = cArray6;
                                    int n24 = n3;
                                    while (true) {
                                        int n25;
                                        char c = cArray23[n24];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n25 = 125;
                                                break;
                                            }
                                            case 1: {
                                                n25 = 81;
                                                break;
                                            }
                                            case 2: {
                                                n25 = 48;
                                                break;
                                            }
                                            case 3: {
                                                n25 = 28;
                                                break;
                                            }
                                            default: {
                                                n25 = 115;
                                            }
                                        }
                                        cArray23[n24] = (char)(c ^ n25);
                                        ++n3;
                                        cArray6 = cArray24;
                                        n7 = n7;
                                        if (n7 != 0) break;
                                        cArray24 = cArray6;
                                        n6 = n7;
                                        n24 = n7;
                                        cArray23 = cArray6;
                                    }
                                    cArray5 = cArray6;
                                    n6 = n7;
                                } while (n7 > n3);
                            }
                            PROPERTY_STATUS = new String(cArray5).intern();
                            var0 = null;
                            char[] cArray25 = "\u000e%Qh\u0006\u000e\u0005Ud\u0007".toCharArray();
                            n3 = 0;
                            int n26 = cArray25.length;
                            cArray4 = cArray25;
                            n5 = n26;
                            if (n26 <= 1) break block62;
                            cArray3 = cArray4;
                            n4 = n5;
                            if (n5 <= n3) break block63;
                        }
                        do {
                            char[] cArray26 = cArray4;
                            char[] cArray27 = cArray4;
                            int n27 = n3;
                            while (true) {
                                int n28;
                                char c = cArray26[n27];
                                switch (n3 % 5) {
                                    case 0: {
                                        n28 = 125;
                                        break;
                                    }
                                    case 1: {
                                        n28 = 81;
                                        break;
                                    }
                                    case 2: {
                                        n28 = 48;
                                        break;
                                    }
                                    case 3: {
                                        n28 = 28;
                                        break;
                                    }
                                    default: {
                                        n28 = 115;
                                    }
                                }
                                cArray26[n27] = (char)(c ^ n28);
                                ++n3;
                                cArray4 = cArray27;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray27 = cArray4;
                                n4 = n5;
                                n27 = n5;
                                cArray26 = cArray4;
                            }
                            cArray3 = cArray4;
                            n4 = n5;
                        } while (n5 > n3);
                    }
                    PROPERTY_STATUS_TEXT = new String(cArray3).intern();
                    var0 = null;
                    char[] cArray28 = "\u00194C\u007f\u0001\u0014!Du\u001c\u0013".toCharArray();
                    n3 = 0;
                    int n29 = cArray28.length;
                    cArray2 = cArray28;
                    n2 = n29;
                    if (n29 <= 1) break block64;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block65;
                }
                do {
                    char[] cArray29 = cArray2;
                    char[] cArray30 = cArray2;
                    int n30 = n3;
                    while (true) {
                        int n31;
                        char c = cArray29[n30];
                        switch (n3 % 5) {
                            case 0: {
                                n31 = 125;
                                break;
                            }
                            case 1: {
                                n31 = 81;
                                break;
                            }
                            case 2: {
                                n31 = 48;
                                break;
                            }
                            case 3: {
                                n31 = 28;
                                break;
                            }
                            default: {
                                n31 = 115;
                            }
                        }
                        cArray29[n30] = (char)(c ^ n31);
                        ++n3;
                        cArray2 = cArray30;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray30 = cArray2;
                        n = n2;
                        n30 = n2;
                        cArray29 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            PROPERTY_DESCRIPTION = new String(cArray).intern();
        }
    }

    public static class OperationPane
    extends JPanel {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JLabel lblStatus = new JLabel();
        JLabel lblStatusText = new JLabel();
        JLabel lblMessage = new JLabel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Math.min(dimension.height, 64);
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = Math.min(dimension.height, 64);
                return dimension;
            }
        };
        protected Operation fOperation;
        private static final /* synthetic */ String[] z;

        public OperationPane() {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.lblMessage.setVisible(false);
            this.lblMessage.setBorder(new CompoundBorder(new LineBorder(new LafColor(z[1], -0.8f)), new EmptyBorder(1, 2, 1, 2)));
            this.lblMessage.setOpaque(true);
            this.lblMessage.setVerticalAlignment(1);
            this.lblMessage.setBackground(new LafColor(z[1], 0.95f));
            this.add((Component)this.lblStatus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.lblStatusText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 21, 2, new Insets(2, 0, 0, 0), 0, 0));
        }

        public void setOperation(Operation operation) {
            this.fOperation = operation;
            if (this.fOperation != null) {
                this.setStatus(operation.getName());
                this.setStatusIcon(ProgressWizardPane.getOperationStatusIcon(operation.getStatus()));
                this.setStatusText(operation.getStatusText());
                this.setDescription(operation.getDescription());
                this.setMessage(operation.getMessage());
                switch (this.fOperation.getStatus()) {
                    case 1: 
                    case 3: {
                        this.lblStatusText.setForeground(UIManager.getColor(z[0]));
                        break;
                    }
                    case 2: {
                        this.lblStatusText.setForeground(Color.DARK_GRAY);
                        break;
                    }
                    case 4: {
                        this.lblStatusText.setForeground(Color.RED);
                    }
                }
            }
        }

        public String getStatus() {
            return this.lblStatus.getText();
        }

        public void setStatus(String string) {
            this.lblStatus.setText(string);
        }

        public Icon getStatusIcon() {
            return this.lblStatus.getIcon();
        }

        public void setStatusIcon(Icon icon) {
            this.lblStatus.setIcon(icon);
        }

        public String getStatusText() {
            return this.lblStatusText.getText();
        }

        public void setStatusText(String string) {
            this.lblStatusText.setText(!StringUtils.noValue(string) ? "[" + string + "]" : null);
            this.lblStatusText.setToolTipText(string);
        }

        public String getDescription() {
            return this.lblStatus.getToolTipText();
        }

        public void setDescription(String string) {
            this.lblStatus.setToolTipText(string);
        }

        public String getMessage() {
            return this.lblMessage.getText();
        }

        public void setMessage(String string) {
            this.lblMessage.setText(string);
            this.lblMessage.setVisible(!StringUtils.noValue(string));
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            String[] stringArray;
            block21: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block20: {
                    char[] cArray3;
                    Object var0;
                    block19: {
                        int n4;
                        int n5;
                        char[] cArray4;
                        block18: {
                            stringArray = new String[2];
                            var0 = null;
                            char[] cArray5 = "\u000f\u0011\u0001*'m\u0016\f=.$\u0002\f:%'".toCharArray();
                            n3 = 0;
                            int n6 = cArray5.length;
                            cArray4 = cArray5;
                            n5 = n6;
                            if (n6 <= 1) break block18;
                            cArray3 = cArray4;
                            n4 = n5;
                            if (n5 <= n3) break block19;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n7 = n3;
                            while (true) {
                                int n8;
                                char c = cArray6[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n8 = 67;
                                        break;
                                    }
                                    case 1: {
                                        n8 = 112;
                                        break;
                                    }
                                    case 2: {
                                        n8 = 99;
                                        break;
                                    }
                                    case 3: {
                                        n8 = 79;
                                        break;
                                    }
                                    default: {
                                        n8 = 75;
                                    }
                                }
                                cArray6[n7] = (char)(c ^ n8);
                                ++n3;
                                cArray4 = cArray7;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray7 = cArray4;
                                n4 = n5;
                                n7 = n5;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n4 = n5;
                        } while (n5 > n3);
                    }
                    stringArray[0] = new String(cArray3).intern();
                    var0 = null;
                    char[] cArray8 = "\u000f\u0011\u0001*'m\u0012\u0002, $\u0002\f:%'".toCharArray();
                    n3 = 0;
                    int n9 = cArray8.length;
                    cArray2 = cArray8;
                    n2 = n9;
                    if (n9 <= 1) break block20;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block21;
                }
                do {
                    char[] cArray9 = cArray2;
                    char[] cArray10 = cArray2;
                    int n10 = n3;
                    while (true) {
                        int n11;
                        char c = cArray9[n10];
                        switch (n3 % 5) {
                            case 0: {
                                n11 = 67;
                                break;
                            }
                            case 1: {
                                n11 = 112;
                                break;
                            }
                            case 2: {
                                n11 = 99;
                                break;
                            }
                            case 3: {
                                n11 = 79;
                                break;
                            }
                            default: {
                                n11 = 75;
                            }
                        }
                        cArray9[n10] = (char)(c ^ n11);
                        ++n3;
                        cArray2 = cArray10;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray10 = cArray2;
                        n = n2;
                        n10 = n2;
                        cArray9 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            stringArray[1] = new String(cArray).intern();
            z = stringArray;
        }
    }
}

