/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.insight;

import dev.gui.ComponentPainterHolder;
import dev.gui.IconComponentPainter;
import dev.gui.InitializableComponentPainter;
import dev.gui.insight.TextInsightConsumer;
import dev.gui.insight.TextInsightDelegate;
import dev.gui.insight.TextInsightDelegateProxy;
import dev.lang.BitTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class TextInsightDelegateSupport
extends MouseAdapter
implements KeyListener,
TextInsightConsumer {
    protected JTextComponent fComponent;
    protected TextInsightDelegate fInsightDelegate;
    protected boolean fEnabled = false;
    protected Class fInsightDelegateClass = TextInsightDelegate.class;
    protected MarkComponentPainter fMarkComponentPainter = new MarkComponentPainter();

    public TextInsightDelegateSupport(JTextComponent jTextComponent) {
        this.fComponent = jTextComponent;
        this.fComponent.addMouseListener(this);
        this.fComponent.addKeyListener(this);
    }

    protected int getFlipHeight() {
        try {
            Rectangle rectangle = this.fComponent.modelToView(this.fComponent.getCaretPosition());
            return rectangle.height;
        }
        catch (BadLocationException badLocationException) {
            return this.fComponent.getHeight();
        }
    }

    protected Point getInsightLocation() {
        try {
            Rectangle rectangle = this.fComponent.modelToView(this.fComponent.getCaretPosition());
            Point point = rectangle.getLocation();
            point.y += rectangle.height;
            return point;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String[] doPrimaryAction() {
        return this.fInsightDelegate.doPrimaryAction(this.fComponent, this, this.getInsightLocation(), this.getFlipHeight());
    }

    protected String[] doSecondaryAction() {
        return this.fInsightDelegate.doSecondaryAction(this.fComponent, this, this.getInsightLocation(), this.getFlipHeight());
    }

    protected void processInsightResult(String[] stringArray) {
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
            }
            this.fComponent.replaceSelection(stringBuffer.toString());
        }
    }

    public void consumePrimaryAction(String[] stringArray) {
        if (stringArray != null) {
            this.processInsightResult(stringArray);
        }
    }

    public void consumeSecondaryAction(String[] stringArray) {
        if (stringArray != null) {
            this.processInsightResult(stringArray);
        }
    }

    public TextInsightDelegate getInsightDelegate() {
        return this.fInsightDelegate;
    }

    public void setInsightDelegate(TextInsightDelegate textInsightDelegate) {
        if (this.fInsightDelegate != null && this.fComponent instanceof ComponentPainterHolder) {
            ((ComponentPainterHolder)((Object)this.fComponent)).removeComponentPainter(this.fMarkComponentPainter);
        }
        this.fInsightDelegate = textInsightDelegate;
        if (this.fInsightDelegate != null && this.fComponent instanceof ComponentPainterHolder) {
            ((ComponentPainterHolder)((Object)this.fComponent)).addComponentPainter(this.fMarkComponentPainter);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fInsightDelegate != null && BitTools.checkBit(mouseEvent.getModifiers(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            mouseEvent.consume();
            this.processInsightResult(this.doPrimaryAction());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (this.fInsightDelegate != null && keyEvent.getKeyCode() == 32 && BitTools.checkBit(keyEvent.getModifiers(), n)) {
            keyEvent.consume();
            if (keyEvent.getModifiers() == (n | 1)) {
                this.processInsightResult(this.doSecondaryAction());
            } else if (keyEvent.getModifiers() == n) {
                this.processInsightResult(this.doPrimaryAction());
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.fEnabled != bl) {
            this.fEnabled = bl;
            if (this.fEnabled) {
                this.onAddNotify();
            } else {
                this.onRemoveNotify();
            }
        }
    }

    public Class getInsightDelegateClass() {
        return this.fInsightDelegateClass;
    }

    public void setInsightDelegateClass(Class clazz) {
        this.fInsightDelegateClass = clazz;
    }

    public void onAddNotify() {
        if (this.isEnabled()) {
            TextInsightDelegate textInsightDelegate = null;
            for (Container container = this.fComponent.getParent(); textInsightDelegate == null && container != null; container = container.getParent()) {
                if (this.fInsightDelegateClass.isAssignableFrom(container.getClass())) {
                    textInsightDelegate = (TextInsightDelegate)((Object)container);
                    continue;
                }
                if (!TextInsightDelegateProxy.class.isAssignableFrom(container.getClass()) || !this.fInsightDelegateClass.isAssignableFrom(((TextInsightDelegateProxy)((Object)container)).getTextInsightDelegate().getClass())) continue;
                textInsightDelegate = ((TextInsightDelegateProxy)((Object)container)).getTextInsightDelegate();
            }
            this.setInsightDelegate(textInsightDelegate);
        }
    }

    public void onRemoveNotify() {
        this.setInsightDelegate(null);
    }

    public static class MarkComponentPainter
    extends IconComponentPainter
    implements InitializableComponentPainter,
    FocusListener,
    Icon {
        public static final Color COLOR = new Color(0, 0, 255, 192);

        public MarkComponentPainter() {
            this.setIcon(this);
            this.fAlignment = 12;
        }

        public void init(Component component) {
            component.addFocusListener(this);
        }

        public void release(Component component) {
            component.removeFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        public int getIconHeight() {
            return 5;
        }

        public int getIconWidth() {
            return 5;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.hasFocus()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
                Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(COLOR);
                graphics2D.fillPolygon(new int[]{5, 5, 0}, new int[]{0, 5, 5}, 3);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
        }
    }
}

