/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class IndicatorBorder
extends AbstractBorder {
    protected String fIndicator = "*";
    protected Color fColor = Color.red;
    protected static final int H_GAP = 2;

    public IndicatorBorder(String string) {
        this.fIndicator = string;
    }

    public IndicatorBorder() {
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.fIndicator == null) {
            return;
        }
        Dimension dimension = this.getIndicatorSize(component);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        if (component.getParent() != null) {
            graphics.setColor(component.getParent().getBackground());
            int n5 = this.getBorderInsets((Component)component).right;
            graphics.fillRect(n + n3 - n5, n2, n5, n4);
        }
        graphics.setColor(component.isEnabled() ? this.fColor : SystemColor.controlShadow);
        graphics.setFont(component.getFont());
        graphics.drawString(this.fIndicator, n + n3 - 2 - dimension.width, n2 + n4 - (n4 - dimension.height) / 2);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public String getIndicator() {
        return this.fIndicator;
    }

    public void setIndicator(String string) {
        this.fIndicator = string;
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 0;
        insets.top = 0;
        insets.left = 0;
        Dimension dimension = this.getIndicatorSize(component);
        insets.right = dimension.width + 4;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getIndicatorSize(Component component) {
        FontMetrics fontMetrics = this.getFontMetrics(component);
        return this.fIndicator != null ? new Dimension(fontMetrics.charsWidth(this.fIndicator.toCharArray(), 0, this.fIndicator.length()), fontMetrics.getHeight()) : new Dimension();
    }

    protected FontMetrics getFontMetrics(Component component) {
        return component.getFontMetrics(component.getFont());
    }

    public static class CompoundBorder
    extends javax.swing.border.CompoundBorder
    implements UIResource {
        public CompoundBorder() {
        }

        public CompoundBorder(Border border, Border border2) {
            super(border, border2);
        }
    }
}

