/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.util.collections.HashedBoundList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Throbber
extends JComponent
implements ActionListener {
    protected int fTicksNumber = 15;
    protected Area[] fTickAreas;
    protected Color[] fTickColors;
    protected int fTickColorOffset = 0;
    public static final int STYLE_BARS = 1;
    public static final int STYLE_DOTS = 2;
    protected int fStyle = 1;
    protected double fScale = 1.0;
    protected Timer fTimer = new Timer(100, this);
    protected Rectangle fRelativeTicksBounds;
    protected Rectangle fTicksBounds;
    protected AffineTransform fTransform;
    protected double fFillBoundsScale = 1.0;
    protected boolean fFillBounds = false;
    protected int fRadius = 48;
    protected static final int BAR_WIDTH = 32;
    protected static final int BAR_HEIGHT = 16;
    private static final /* synthetic */ String[] z;

    public Throbber() {
        this.buildTicks();
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int n) {
        if (this.fStyle != n) {
            this.fStyle = n;
            this.buildTicks();
        }
    }

    public int getTicksNumber() {
        return this.fTicksNumber;
    }

    public void setTicksNumber(int n) {
        if (n < 5) {
            throw new IllegalArgumentException(z[0] + n);
        }
        if (this.fTicksNumber != n) {
            this.fTicksNumber = n;
            this.buildTicks();
            this.repaint();
        }
    }

    public double getScale() {
        return this.fScale;
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(z[1] + d);
        }
        if (this.fScale != d) {
            this.fScale = d;
            this.calcRelativeTicksBounds();
            this.repaint();
        }
    }

    protected double getScaleInt() {
        return this.isFillBounds() ? this.fFillBoundsScale : this.fScale;
    }

    public boolean isFillBounds() {
        return this.fFillBounds;
    }

    public void setFillBounds(boolean bl) {
        if (this.fFillBounds != bl) {
            this.fFillBounds = bl;
            this.updateFillBoundsScale();
            this.calcRelativeTicksBounds();
            this.repaint();
        }
    }

    private void updateFillBoundsScale() {
        if (this.fTicksBounds != null) {
            int n = 1;
            Insets insets = this.getInsets();
            int n2 = this.getWidth() - insets.left - insets.right;
            int n3 = this.getHeight() - insets.top - insets.bottom;
            this.fFillBoundsScale = Math.min((double)(n2 - 2 * n) / (double)this.fTicksBounds.width, (double)(n3 - 2 * n) / (double)this.fTicksBounds.height);
        }
    }

    public int getRadius() {
        return this.fRadius;
    }

    public void setRadius(int n) {
        if (this.fRadius != n) {
            this.fRadius = n;
            this.buildTicks();
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void buildTicks() {
        this.fTickColorOffset = 0;
        this.buildTickAreas();
        this.buildTickColors();
        this.calcTicksBounds();
        this.updateFillBoundsScale();
        this.calcRelativeTicksBounds();
    }

    protected void calcTicksBounds() {
        boolean bl = HashedBoundList.z;
        this.fTicksBounds = new Rectangle();
        for (int i = 0; i < this.fTickAreas.length; ++i) {
            this.fTicksBounds = this.fTicksBounds.union(this.fTickAreas[i].getBounds());
            if (!bl) continue;
        }
    }

    protected void buildTickColors() {
        boolean bl = HashedBoundList.z;
        this.fTickColors = new Color[this.fTicksNumber];
        Color color = this.getForeground();
        if (color == null) {
            color = Color.BLACK;
        }
        float f = color.getRed();
        float f2 = color.getGreen();
        float f3 = color.getBlue();
        float f4 = color.getAlpha();
        Color color2 = this.getBackground();
        if (color2 == null) {
            color2 = Color.LIGHT_GRAY;
        }
        float f5 = color2.getRed();
        float f6 = color2.getGreen();
        float f7 = color2.getBlue();
        float f8 = color2.getAlpha();
        double d = ((double)f - (double)f5) / (double)this.fTicksNumber;
        double d2 = ((double)f2 - (double)f6) / (double)this.fTicksNumber;
        double d3 = ((double)f3 - (double)f7) / (double)this.fTicksNumber;
        double d4 = ((double)f4 - (double)f8) / (double)this.fTicksNumber;
        for (int i = 0; i < this.fTickAreas.length; ++i) {
            int n = (int)Math.round((double)f5 + (double)(this.fTicksNumber - i) * d);
            int n2 = (int)Math.round((double)f6 + (double)(this.fTicksNumber - i) * d2);
            int n3 = (int)Math.round((double)f7 + (double)(this.fTicksNumber - i) * d3);
            int n4 = (int)Math.round((double)f8 + (double)(this.fTicksNumber - i) * d4);
            this.fTickColors[i] = new Color(n, n2, n3, n4);
            if (!bl) continue;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.buildTickColors();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.buildTickColors();
    }

    protected void buildTickAreas() {
        boolean bl = HashedBoundList.z;
        this.fTickAreas = new Area[this.fTicksNumber];
        double d = Math.PI * 2 / (double)this.fTicksNumber;
        for (int i = 0; i < this.fTicksNumber; ++i) {
            Area area;
            switch (this.fStyle) {
                case 2: {
                    area = this.buildDot();
                    if (!bl) break;
                }
                default: {
                    area = this.buildBar();
                }
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.concatenate(AffineTransform.getTranslateInstance(this.fRadius, -8.0));
            area.transform(affineTransform);
            area.transform(AffineTransform.getRotateInstance(d * (double)(-i), 0.0, 0.0));
            this.fTickAreas[i] = area;
            if (!bl) continue;
        }
    }

    protected Area buildBar() {
        Area area = new Area(new Rectangle2D.Double(8.0, 0.0, 32.0, 16.0));
        area.add(new Area(new Ellipse2D.Double(0.0, 0.0, 16.0, 16.0)));
        area.add(new Area(new Ellipse2D.Double(32.0, 0.0, 16.0, 16.0)));
        return area;
    }

    protected Area buildDot() {
        return new Area(new Ellipse2D.Double(0.0, 0.0, 16.0, 16.0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        bl = HashedBoundList.z;
                        if (this.fTickColorOffset != this.fTicksNumber - 1) break block4;
                        this.fTickColorOffset = 0;
                        if (!bl) break block5;
                    }
                    ++this.fTickColorOffset;
                }
                if (this.fRelativeTicksBounds == null) break block6;
                this.repaint(this.fRelativeTicksBounds);
                if (!bl) break block7;
            }
            this.repaint();
        }
    }

    public void start() {
        this.fTimer.start();
    }

    public boolean isRunning() {
        return this.fTimer.isRunning();
    }

    public void setRunning(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.fTimer.start();
                if (!HashedBoundList.z) break block3;
            }
            this.fTimer.stop();
        }
    }

    public void stop() {
        this.fTimer.stop();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.isRunning()) {
            this.stop();
        }
    }

    public void removeNotify() {
        if (this.isRunning()) {
            this.stop();
        }
        super.removeNotify();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateFillBoundsScale();
        this.calcRelativeTicksBounds();
    }

    protected void calcRelativeTicksBounds() {
        this.fTransform = new AffineTransform();
        this.fTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double d = this.getScaleInt();
        this.fTransform.scale(d, d);
        if (this.fTicksBounds != null) {
            Area area = new Area(this.fTicksBounds);
            area.transform(this.fTransform);
            this.fRelativeTicksBounds = area.getBounds();
        }
    }

    protected void paintComponent(Graphics graphics) {
        block7: {
            int n;
            Graphics2D graphics2D;
            boolean bl;
            block6: {
                bl = HashedBoundList.z;
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.transform(this.fTransform);
                if (!this.isRunning()) break block6;
                n = 0;
                int n2 = this.fTickColorOffset;
                while (n < this.fTickAreas.length) {
                    if (n2 >= this.fTickColors.length) {
                        n2 = 0;
                    }
                    graphics2D.setColor(this.fTickColors[n2]);
                    graphics2D.fill(this.fTickAreas[n]);
                    ++n;
                    ++n2;
                    if (!bl) continue;
                }
                if (!bl) break block7;
            }
            graphics2D.setColor(this.fTickColors[this.fTickColors.length / 2]);
            for (n = 0; n < this.fTickAreas.length; ++n) {
                graphics2D.fill(this.fTickAreas[n]);
                if (!bl) continue;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "0rFL\r\u0010x\u0010Y\b\u001aw\u0010C\u0014\u0014~U_[Y".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 121;
                                    break;
                                }
                                case 1: {
                                    n8 = 28;
                                    break;
                                }
                                case 2: {
                                    n8 = 48;
                                    break;
                                }
                                case 3: {
                                    n8 = 45;
                                    break;
                                }
                                default: {
                                    n8 = 97;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "0rFL\r\u0010x\u0010^\u0002\u0018pU\u0017".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 121;
                            break;
                        }
                        case 1: {
                            n11 = 28;
                            break;
                        }
                        case 2: {
                            n11 = 48;
                            break;
                        }
                        case 3: {
                            n11 = 45;
                            break;
                        }
                        default: {
                            n11 = 97;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
    }
}

