/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentFontSupport;
import dev.gui.ComponentPainter;
import dev.gui.ComponentPainterHolder;
import dev.gui.ComponentPainterSupport;
import dev.gui.FixedCharsDocument;
import dev.gui.IconComponentPainter;
import dev.gui.IndicatorHolder;
import dev.gui.InitializableComponentPainter;
import dev.gui.TooltipProvider;
import dev.gui.border.IndicatorBorder;
import dev.gui.insight.TextInsightDelegateSupport;
import dev.gui.res.Images;
import dev.util.StringUtils;
import dev.util.collections.HashedBoundList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JTextFieldEx
extends JTextField
implements IndicatorHolder,
FocusListener,
ComponentPainterHolder {
    protected boolean fSelectAllOnFocusGain = true;
    protected boolean fIgnoreOnceSelectAllOnFocusGain = false;
    protected boolean fReturnEmptyText = true;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;
    protected IndicatorBorder fIndicatorBorder;
    protected Border fOriginalBorder;
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected ComponentPainterSupport fComponentPainterSupport;
    protected TextInsightDelegateSupport fTextInsightDelegateSupport = new TextInsightDelegateSupport(this){

        protected String[] doPrimaryAction() {
            JTextFieldEx.this.fIgnoreOnceSelectAllOnFocusGain = true;
            return super.doPrimaryAction();
        }
    };
    protected PromptTextComponentPainter fPromptTextComponentPainter;
    protected ComponentFontSupport fComponentFontSupport = new ComponentFontSupport(this);
    protected IconComponentPainter fI18NComponentPainter;
    protected boolean fI18NCapable = false;
    private static final /* synthetic */ String z;

    public JTextFieldEx() {
        this.init();
    }

    public JTextFieldEx(String string) {
        super(string);
        this.init();
    }

    public JTextFieldEx(int n) {
        super(n);
        this.init();
    }

    public JTextFieldEx(String string, int n) {
        super(string, n);
        this.init();
    }

    public JTextFieldEx(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    protected void init() {
        this.addFocusListener(this);
        this.setDocument(new FixedCharsDocument());
    }

    public int getMaxChars() {
        return this.getDocument() instanceof FixedCharsDocument ? ((FixedCharsDocument)this.getDocument()).getMaxChars() : -1;
    }

    public void setMaxChars(int n) {
        if (this.getDocument() instanceof FixedCharsDocument) {
            ((FixedCharsDocument)this.getDocument()).setMaxChars(n);
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.fSelectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean bl) {
        this.fSelectAllOnFocusGain = bl;
    }

    protected void onFocusGained() {
        if (this.isSelectAllOnFocusGain() && !this.fIgnoreOnceSelectAllOnFocusGain) {
            this.selectAllOnFocusGain();
        }
        this.fIgnoreOnceSelectAllOnFocusGain = false;
    }

    protected void selectAllOnFocusGain() {
        this.selectAll();
    }

    public void setText(String string) {
        if (string != null) {
            int n = string.indexOf(10);
            if (n == -1) {
                n = string.indexOf(13);
            }
            if (n == -1) {
                n = string.indexOf(12);
            }
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        String string2 = this.getText();
        super.setText(string);
        if (!StringUtils.equals(string2, string)) {
            this.firePropertyChange(z, string2, string);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Insets insets = this.getInsets();
        dimension.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fPreferredWidth != -1) {
            dimension.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            dimension.height = this.fPreferredHeight;
        }
        return dimension;
    }

    public boolean isReturnEmptyText() {
        return this.fReturnEmptyText;
    }

    public void setReturnEmptyText(boolean bl) {
        this.fReturnEmptyText = bl;
    }

    public String getText() {
        String string = super.getText();
        return this.isReturnEmptyText() ? string : (StringUtils.noValue(string) ? null : string);
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int n) {
        this.fPreferredHeight = n;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int n) {
        this.fPreferredWidth = n;
    }

    public void updateUI() {
        super.updateUI();
        if (!(this.getBorder() instanceof IndicatorBorder.CompoundBorder)) {
            this.fOriginalBorder = this.getBorder();
        }
        this.updateBorder();
    }

    private void updateBorder() {
        block3: {
            block2: {
                if (StringUtils.noValue(this.getIndicator())) break block2;
                this.setBorder(new IndicatorBorder.CompoundBorder(this.fIndicatorBorder, this.fOriginalBorder));
                if (!HashedBoundList.z) break block3;
            }
            this.setBorder(this.fOriginalBorder);
        }
    }

    public String getIndicator() {
        return this.getIndicatorBorder().getIndicator();
    }

    public void setIndicator(String string) {
        if (string != this.getIndicator()) {
            this.getIndicatorBorder().setIndicator(string);
            this.updateBorder();
        }
    }

    protected IndicatorBorder getIndicatorBorder() {
        if (this.fIndicatorBorder == null) {
            this.fIndicatorBorder = new IndicatorBorder(null);
        }
        return this.fIndicatorBorder;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Insets insets = this.getInsets();
        dimension.height = this.getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        if (this.fMinimumWidth != -1) {
            dimension.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            dimension.height = this.fMinimumHeight;
        }
        return dimension;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.fMinimumHeight = n;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.fMinimumWidth = n;
    }

    protected ComponentPainterSupport getComponentPainterSupport() {
        if (this.fComponentPainterSupport == null) {
            this.fComponentPainterSupport = new ComponentPainterSupport(this);
        }
        return this.fComponentPainterSupport;
    }

    public void addComponentPainter(ComponentPainter componentPainter) {
        this.getComponentPainterSupport().addComponentPainter(componentPainter);
    }

    public void removeComponentPainter(ComponentPainter componentPainter) {
        this.getComponentPainterSupport().removeComponentPainter(componentPainter);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fComponentPainterSupport != null) {
            this.fComponentPainterSupport.paintComponent(graphics);
        }
    }

    public boolean isInsightEnabled() {
        return this.fTextInsightDelegateSupport.isEnabled();
    }

    public void setInsightEnabled(boolean bl) {
        this.fTextInsightDelegateSupport.setEnabled(bl);
    }

    public Class getInsightDelegateClass() {
        return this.fTextInsightDelegateSupport.getInsightDelegateClass();
    }

    public void setInsightDelegateClass(Class clazz) {
        this.fTextInsightDelegateSupport.setInsightDelegateClass(clazz);
    }

    public void addNotify() {
        super.addNotify();
        this.fTextInsightDelegateSupport.onAddNotify();
    }

    public void removeNotify() {
        this.fTextInsightDelegateSupport.onRemoveNotify();
        super.removeNotify();
    }

    public String getPromptText() {
        return this.fPromptTextComponentPainter != null ? this.fPromptTextComponentPainter.getText() : null;
    }

    public void setPromptText(String string) {
        this.setPromptText(string, 2);
    }

    public void setPromptText(String string, int n) {
        block6: {
            block4: {
                boolean bl;
                block5: {
                    bl = HashedBoundList.z;
                    if (StringUtils.noValue(string)) break block4;
                    if (this.fPromptTextComponentPainter != null) break block5;
                    this.fPromptTextComponentPainter = new PromptTextComponentPainter(this, string, false, n);
                    this.addComponentPainter(this.fPromptTextComponentPainter);
                    if (!bl) break block6;
                }
                this.fPromptTextComponentPainter.setText(string);
                if (!this.isShowing()) break block6;
                this.fPromptTextComponentPainter.updateTextVisibility();
                if (!bl) break block6;
            }
            if (this.fPromptTextComponentPainter != null) {
                this.removeComponentPainter(this.fPromptTextComponentPainter);
                this.fPromptTextComponentPainter = null;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.onFocusGained();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (this.fComponentPainterSupport instanceof TooltipProvider) {
            string = this.fComponentPainterSupport.getToolTipText(mouseEvent);
        }
        string = string != null ? string : super.getToolTipText(mouseEvent);
        return StringUtils.noValue(string) ? null : string;
    }

    public void setFont(Font font) {
        super.setFont(this.fComponentFontSupport != null ? this.fComponentFontSupport.getFont(font) : font);
    }

    public int getFontStyle() {
        return this.fComponentFontSupport.getFontStyle();
    }

    public void setFontStyle(int n) {
        this.fComponentFontSupport.setFontStyle(n);
    }

    public int getFontIncrement() {
        return this.fComponentFontSupport.getFontIncrement();
    }

    public void setFontIncrement(int n) {
        this.fComponentFontSupport.setFontIncrement(n);
    }

    public float getFontSize() {
        return this.fComponentFontSupport.getFontSize();
    }

    public void setFontSize(float f) {
        this.fComponentFontSupport.setFontSize(f);
    }

    public boolean isI18NCapable() {
        return this.fI18NCapable;
    }

    public void setI18NCapable(boolean bl) {
        if (this.fI18NCapable != bl) {
            if (this.fI18NCapable) {
                this.removeComponentPainter(this.fI18NComponentPainter);
                this.fI18NComponentPainter = null;
            }
            this.fI18NCapable = bl;
            if (this.fI18NCapable) {
                this.fI18NComponentPainter = new IconComponentPainter(Images.I18N, 24);
                this.addComponentPainter(this.fI18NComponentPainter);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "\u0012!<f".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 102;
                            break;
                        }
                        case 1: {
                            n6 = 68;
                            break;
                        }
                        case 2: {
                            n6 = 68;
                            break;
                        }
                        case 3: {
                            n6 = 18;
                            break;
                        }
                        default: {
                            n6 = 45;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }

    public static class PromptTextComponentPainter
    extends dev.gui.TextComponentPainter
    implements InitializableComponentPainter,
    FocusListener,
    PropertyChangeListener,
    DocumentListener {
        protected boolean fHideOnFocusGain = true;
        protected JTextComponent fComponent;
        protected boolean fShowPromptText = false;
        protected Font fLabelFont;
        protected Font fFont;
        protected Document fDocument;
        private static final /* synthetic */ String[] z;

        public PromptTextComponentPainter(JTextComponent jTextComponent, String string, boolean bl, int n) {
            super(string, n);
            this.fComponent = jTextComponent;
            this.fHideOnFocusGain = bl;
        }

        protected Font getFont(Component component) {
            Font font = UIManager.getFont(z[2]);
            if (this.fFont == null || font != null && !font.equals(this.fLabelFont)) {
                this.fLabelFont = font;
                this.fFont = this.fLabelFont.deriveFont(0);
            }
            return this.fFont;
        }

        protected void paintImpl(Graphics graphics, Component component) {
            if (this.fShowPromptText) {
                Font font = graphics.getFont();
                Color color = graphics.getColor();
                graphics.setFont(this.getFont(component));
                graphics.setColor(this.getTextColor());
                super.paintImpl(graphics, component);
                graphics.setColor(color);
                graphics.setFont(font);
            }
        }

        public Color getTextColor() {
            return UIManager.getColor(z[0]);
        }

        public void init(Component component) {
            this.setDocument(this.fComponent.getDocument());
            this.fComponent.addFocusListener(this);
            this.fComponent.addPropertyChangeListener(this);
            this.updateTextVisibility();
        }

        public void release(Component component) {
            this.fComponent.removePropertyChangeListener(this);
            this.fComponent.removeFocusListener(this);
            this.setDocument(null);
            this.fComponent = null;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.updateTextVisibility();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.updateTextVisibility();
        }

        protected Document getDocument() {
            return this.fDocument;
        }

        protected void setDocument(Document document) {
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener(this);
            }
            this.fDocument = document;
            if (this.fDocument != null) {
                this.fDocument.addDocumentListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (z[1].equals(propertyChangeEvent.getPropertyName())) {
                this.setDocument((Document)propertyChangeEvent.getNewValue());
            }
        }

        protected void setShowText(boolean bl) {
            if (this.fShowPromptText != bl) {
                this.fShowPromptText = bl;
                this.fComponent.repaint();
            }
        }

        public void updateTextVisibility() {
            boolean bl;
            block3: {
                block2: {
                    bl = false;
                    if (this.fDocument.getLength() <= 0) break block2;
                    bl = false;
                    if (!HashedBoundList.z) break block3;
                }
                bl = !this.fComponent.hasFocus() || !this.fHideOnFocusGain;
            }
            this.setShowText(bl);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateTextVisibility();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateTextVisibility();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            String[] stringArray;
            block32: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block31: {
                    char[] cArray3;
                    Object var0;
                    block30: {
                        int n4;
                        int n5;
                        char[] cArray4;
                        block29: {
                            char[] cArray5;
                            block28: {
                                int n6;
                                int n7;
                                char[] cArray6;
                                block27: {
                                    stringArray = new String[3];
                                    var0 = null;
                                    char[] cArray7 = "-s#v9Ov(`4\u0003~$w\u0013\u000e`$t'\u000eg/w".toCharArray();
                                    n3 = 0;
                                    int n8 = cArray7.length;
                                    cArray6 = cArray7;
                                    n7 = n8;
                                    if (n8 <= 1) break block27;
                                    cArray5 = cArray6;
                                    n6 = n7;
                                    if (n7 <= n3) break block28;
                                }
                                do {
                                    char[] cArray8 = cArray6;
                                    char[] cArray9 = cArray6;
                                    int n9 = n3;
                                    while (true) {
                                        int n10;
                                        char c = cArray8[n9];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n10 = 97;
                                                break;
                                            }
                                            case 1: {
                                                n10 = 18;
                                                break;
                                            }
                                            case 2: {
                                                n10 = 65;
                                                break;
                                            }
                                            case 3: {
                                                n10 = 19;
                                                break;
                                            }
                                            default: {
                                                n10 = 85;
                                            }
                                        }
                                        cArray8[n9] = (char)(c ^ n10);
                                        ++n3;
                                        cArray6 = cArray9;
                                        n7 = n7;
                                        if (n7 != 0) break;
                                        cArray9 = cArray6;
                                        n6 = n7;
                                        n9 = n7;
                                        cArray8 = cArray6;
                                    }
                                    cArray5 = cArray6;
                                    n6 = n7;
                                } while (n7 > n3);
                            }
                            stringArray[0] = new String(cArray5).intern();
                            var0 = null;
                            char[] cArray10 = "\u0005}\"f8\u0004|5".toCharArray();
                            n3 = 0;
                            int n11 = cArray10.length;
                            cArray4 = cArray10;
                            n5 = n11;
                            if (n11 <= 1) break block29;
                            cArray3 = cArray4;
                            n4 = n5;
                            if (n5 <= n3) break block30;
                        }
                        do {
                            char[] cArray11 = cArray4;
                            char[] cArray12 = cArray4;
                            int n12 = n3;
                            while (true) {
                                int n13;
                                char c = cArray11[n12];
                                switch (n3 % 5) {
                                    case 0: {
                                        n13 = 97;
                                        break;
                                    }
                                    case 1: {
                                        n13 = 18;
                                        break;
                                    }
                                    case 2: {
                                        n13 = 65;
                                        break;
                                    }
                                    case 3: {
                                        n13 = 19;
                                        break;
                                    }
                                    default: {
                                        n13 = 85;
                                    }
                                }
                                cArray11[n12] = (char)(c ^ n13);
                                ++n3;
                                cArray4 = cArray12;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray12 = cArray4;
                                n4 = n5;
                                n12 = n5;
                                cArray11 = cArray4;
                            }
                            cArray3 = cArray4;
                            n4 = n5;
                        } while (n5 > n3);
                    }
                    stringArray[1] = new String(cArray3).intern();
                    var0 = null;
                    char[] cArray13 = "-s#v9Ot.}!".toCharArray();
                    n3 = 0;
                    int n14 = cArray13.length;
                    cArray2 = cArray13;
                    n2 = n14;
                    if (n14 <= 1) break block31;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block32;
                }
                do {
                    char[] cArray14 = cArray2;
                    char[] cArray15 = cArray2;
                    int n15 = n3;
                    while (true) {
                        int n16;
                        char c = cArray14[n15];
                        switch (n3 % 5) {
                            case 0: {
                                n16 = 97;
                                break;
                            }
                            case 1: {
                                n16 = 18;
                                break;
                            }
                            case 2: {
                                n16 = 65;
                                break;
                            }
                            case 3: {
                                n16 = 19;
                                break;
                            }
                            default: {
                                n16 = 85;
                            }
                        }
                        cArray14[n15] = (char)(c ^ n16);
                        ++n3;
                        cArray2 = cArray15;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray15 = cArray2;
                        n = n2;
                        n15 = n2;
                        cArray14 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            stringArray[2] = new String(cArray).intern();
            z = stringArray;
        }
    }

    public static class TextComponentPainter
    extends dev.gui.TextComponentPainter
    implements InitializableComponentPainter,
    FocusListener {
        private static final /* synthetic */ String z;

        public TextComponentPainter() {
            this(null);
        }

        public TextComponentPainter(String string) {
            this(string, 2);
        }

        public TextComponentPainter(String string, int n) {
            super(string, n);
        }

        protected void paintImpl(Graphics graphics, Component component) {
            if (!component.hasFocus() && this.needPaint(component)) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor(z));
                super.paintImpl(graphics, component);
                graphics.setColor(color);
            }
        }

        protected boolean needPaint(Component component) {
            return StringUtils.noValue(((JTextComponent)component).getText()) && !StringUtils.noValue(this.getText());
        }

        public void init(Component component) {
            component.addFocusListener(this);
        }

        public void release(Component component) {
            component.removeFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (this.needPaint(component)) {
                component.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (this.needPaint(component)) {
                component.repaint();
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block9: {
                    Object var0 = null;
                    char[] cArray3 = "w\u0014\u001c\u000ew\u0015\u0011\u0017\u0018zY\u0019\u001b\u000f]T\u0007\u001b\fiT\u0000\u0010\u000f".toCharArray();
                    n3 = 0;
                    int n4 = cArray3.length;
                    cArray2 = cArray3;
                    n2 = n4;
                    if (n4 <= 1) break block9;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n5 = n3;
                    while (true) {
                        int n6;
                        char c = cArray4[n5];
                        switch (n3 % 5) {
                            case 0: {
                                n6 = 59;
                                break;
                            }
                            case 1: {
                                n6 = 117;
                                break;
                            }
                            case 2: {
                                n6 = 126;
                                break;
                            }
                            case 3: {
                                n6 = 107;
                                break;
                            }
                            default: {
                                n6 = 27;
                            }
                        }
                        cArray4[n5] = (char)(c ^ n6);
                        ++n3;
                        cArray2 = cArray5;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray5 = cArray2;
                        n = n2;
                        n5 = n2;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            z = new String(cArray).intern();
        }
    }
}

