/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.DelayedInvoker;
import dev.gui.ExternalBrowser;
import dev.util.collections.HashedBoundList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicLabelUI;

public class HyperlinkLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    public static int HIDE_TIMEOUT;
    private DelayedInvoker fDelayedInvoker = new DelayedInvoker(HIDE_TIMEOUT, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            HyperlinkLabel.this.onMouseExited();
        }
    });
    private boolean fMouseIn = false;
    private Cursor fSavedCursor = null;
    private Color fSavedForeground = null;
    protected boolean fCallBrowser = true;
    private static HyperlinkLabelUI fHyperlinkLabelUI;
    private String fHyperlinkURL = null;
    private Color fHyperlinkColor = null;
    protected boolean fExpireRollover = true;
    private transient Vector fHyperlinkListeners;
    private static final /* synthetic */ String z;

    public HyperlinkLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.initListeners();
    }

    public HyperlinkLabel(String string, int n) {
        super(string, n);
        this.initListeners();
    }

    public HyperlinkLabel(String string) {
        super(string);
        this.initListeners();
    }

    public HyperlinkLabel(Icon icon, int n) {
        super(icon, n);
        this.initListeners();
    }

    public HyperlinkLabel(Icon icon) {
        super(icon);
        this.initListeners();
    }

    public HyperlinkLabel() {
        this.initListeners();
    }

    private void initListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fMouseIn = false;
    }

    public boolean isMouseIn() {
        return this.fMouseIn;
    }

    public void setMouseIn(boolean bl) {
        block2: {
            block3: {
                if (this.fMouseIn == bl) break block2;
                this.fMouseIn = bl;
                if (this.fHyperlinkColor == null) break block2;
                if (!this.fMouseIn) break block3;
                this.fSavedForeground = this.getForeground();
                this.setForeground(this.fHyperlinkColor);
                if (!HashedBoundList.z) break block2;
            }
            this.setForeground(this.fSavedForeground);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseEntered();
    }

    public void onMouseEntered() {
        if (!this.fMouseIn) {
            if (this.isExpireRollover()) {
                this.fDelayedInvoker.takeUp();
            }
            this.fMouseIn = true;
            this.fSavedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (this.fHyperlinkColor != null) {
                this.fSavedForeground = this.getForeground();
                this.setForeground(this.fHyperlinkColor);
            }
            this.repaint();
            this.fireHyperlinkUpdate(HyperlinkEvent.EventType.ENTERED);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseExited();
    }

    public void onMouseExited() {
        if (this.fMouseIn) {
            if (this.isExpireRollover()) {
                this.fDelayedInvoker.stop();
            }
            this.fMouseIn = false;
            this.setCursor(this.fSavedCursor);
            if (this.fHyperlinkColor != null) {
                this.setForeground(this.fSavedForeground);
            }
            this.repaint();
            this.fireHyperlinkUpdate(HyperlinkEvent.EventType.EXITED);
        }
    }

    public boolean isCallBrowser() {
        return this.fCallBrowser;
    }

    public void setCallBrowser(boolean bl) {
        this.fCallBrowser = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.onMouseExited();
        if (this.fHyperlinkURL != null && this.fCallBrowser) {
            ExternalBrowser.callBrowser(this.fHyperlinkURL, (Component)this);
        }
        this.fireHyperlinkUpdate(HyperlinkEvent.EventType.ACTIVATED);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void updateUI() {
        this.setUI(fHyperlinkLabelUI);
    }

    public Color getHyperlinkColor() {
        return this.fHyperlinkColor != null ? this.fHyperlinkColor : this.getForeground();
    }

    public void setHyperlinkColor(Color color) {
        this.fHyperlinkColor = color;
    }

    public String getHyperlinkURL() {
        return this.fHyperlinkURL;
    }

    public void setHyperlinkURL(String string) {
        this.fHyperlinkURL = string;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block6: {
            block5: {
                if (!this.isEnabled()) {
                    return;
                }
                if (this.fMouseIn) break block5;
                this.onMouseEntered();
                if (!HashedBoundList.z) break block6;
            }
            if (this.isExpireRollover()) {
                this.fDelayedInvoker.takeUp();
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.onMouseExited();
        }
    }

    public boolean isExpireRollover() {
        return this.fExpireRollover;
    }

    public void setExpireRollover(boolean bl) {
        this.fExpireRollover = bl;
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        if (this.fHyperlinkListeners != null && this.fHyperlinkListeners.contains(hyperlinkListener)) {
            Vector vector = (Vector)this.fHyperlinkListeners.clone();
            vector.removeElement(hyperlinkListener);
            this.fHyperlinkListeners = vector;
        }
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        Vector vector;
        Vector vector2 = vector = this.fHyperlinkListeners == null ? new Vector(2) : (Vector)this.fHyperlinkListeners.clone();
        if (!vector.contains(hyperlinkListener)) {
            vector.addElement(hyperlinkListener);
            this.fHyperlinkListeners = vector;
        }
    }

    protected void fireHyperlinkUpdate(HyperlinkEvent.EventType eventType) {
        block3: {
            boolean bl = HashedBoundList.z;
            try {
                HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, eventType, new URL(this.fHyperlinkURL == null ? z : this.fHyperlinkURL), this.getToolTipText());
                if (this.fHyperlinkListeners == null) break block3;
                Vector vector = this.fHyperlinkListeners;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((HyperlinkListener)vector.elementAt(i)).hyperlinkUpdate(hyperlinkEvent);
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "-*\u0000xCjq".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 69;
                            break;
                        }
                        case 1: {
                            n6 = 94;
                            break;
                        }
                        case 2: {
                            n6 = 116;
                            break;
                        }
                        case 3: {
                            n6 = 8;
                            break;
                        }
                        default: {
                            n6 = 121;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
        HIDE_TIMEOUT = 7000;
        fHyperlinkLabelUI = new HyperlinkLabelUI();
    }

    static class HyperlinkLabelUI
    extends BasicLabelUI {
        public static final int UNDERLINE_OFFSET = 2;
        private static Insets paintViewInsets;
        private static Rectangle paintViewR;
        private static Rectangle paintIconR;
        private static Rectangle paintTextR;
        private static final /* synthetic */ String z;

        HyperlinkLabelUI() {
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)jComponent;
            String string = hyperlinkLabel.getText();
            if (!hyperlinkLabel.isMouseIn() || string == null || jComponent.getClientProperty(z) != null) {
                return;
            }
            Icon icon = hyperlinkLabel.isEnabled() ? hyperlinkLabel.getIcon() : hyperlinkLabel.getDisabledIcon();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            paintViewInsets = jComponent.getInsets(paintViewInsets);
            HyperlinkLabelUI.paintViewR.x = HyperlinkLabelUI.paintViewInsets.left;
            HyperlinkLabelUI.paintViewR.y = HyperlinkLabelUI.paintViewInsets.top;
            HyperlinkLabelUI.paintViewR.width = jComponent.getWidth() - (HyperlinkLabelUI.paintViewInsets.left + HyperlinkLabelUI.paintViewInsets.right);
            HyperlinkLabelUI.paintViewR.height = jComponent.getHeight() - (HyperlinkLabelUI.paintViewInsets.top + HyperlinkLabelUI.paintViewInsets.bottom);
            HyperlinkLabelUI.paintIconR.height = 0;
            HyperlinkLabelUI.paintIconR.width = 0;
            HyperlinkLabelUI.paintIconR.y = 0;
            HyperlinkLabelUI.paintIconR.x = 0;
            HyperlinkLabelUI.paintTextR.height = 0;
            HyperlinkLabelUI.paintTextR.width = 0;
            HyperlinkLabelUI.paintTextR.y = 0;
            HyperlinkLabelUI.paintTextR.x = 0;
            this.layoutCL(hyperlinkLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
            int n = HyperlinkLabelUI.paintTextR.x;
            int n2 = HyperlinkLabelUI.paintTextR.y + fontMetrics.getAscent();
            graphics.setColor(hyperlinkLabel.getHyperlinkColor());
            graphics.drawLine(n, n2 + 2, n + HyperlinkLabelUI.paintTextR.width, n2 + 2);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block9: {
                    Object var0 = null;
                    char[] cArray3 = "iW=\"".toCharArray();
                    n3 = 0;
                    int n4 = cArray3.length;
                    cArray2 = cArray3;
                    n2 = n4;
                    if (n4 <= 1) break block9;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n5 = n3;
                    while (true) {
                        int n6;
                        char c = cArray4[n5];
                        switch (n3 % 5) {
                            case 0: {
                                n6 = 1;
                                break;
                            }
                            case 1: {
                                n6 = 35;
                                break;
                            }
                            case 2: {
                                n6 = 80;
                                break;
                            }
                            case 3: {
                                n6 = 78;
                                break;
                            }
                            default: {
                                n6 = 120;
                            }
                        }
                        cArray4[n5] = (char)(c ^ n6);
                        ++n3;
                        cArray2 = cArray5;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray5 = cArray2;
                        n = n2;
                        n5 = n2;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            z = new String(cArray).intern();
            paintViewInsets = new Insets(0, 0, 0, 0);
            paintViewR = new Rectangle();
            paintIconR = new Rectangle();
            paintTextR = new Rectangle();
        }
    }
}

