/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import dev.gui.ComponentPainter;
import dev.gui.InitializableComponentPainter;
import dev.gui.TooltipProvider;
import dev.util.collections.HashedBoundList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ComponentPainterSupport
implements TooltipProvider {
    protected Component fOwner;
    protected List fComponentPainters;

    public ComponentPainterSupport(Component component) {
        this.fOwner = component;
    }

    public void addComponentPainter(ComponentPainter componentPainter) {
        if (this.fComponentPainters == null) {
            this.fComponentPainters = new ArrayList();
        }
        this.fComponentPainters.add(componentPainter);
        if (componentPainter instanceof InitializableComponentPainter) {
            ((InitializableComponentPainter)((Object)componentPainter)).init(this.fOwner);
        }
        if (this.fOwner.isShowing()) {
            this.fOwner.repaint();
        }
    }

    public void removeComponentPainter(ComponentPainter componentPainter) {
        if (componentPainter instanceof InitializableComponentPainter) {
            ((InitializableComponentPainter)((Object)componentPainter)).release(this.fOwner);
        }
        if (this.fComponentPainters != null && this.fComponentPainters.remove(componentPainter) && this.fOwner.isShowing()) {
            this.fOwner.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = HashedBoundList.z;
        if (this.fComponentPainters != null) {
            int n = this.fComponentPainters.size();
            for (int i = 0; i < n; ++i) {
                ((ComponentPainter)this.fComponentPainters.get(i)).paint(graphics, this.fOwner);
                if (!bl) continue;
            }
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        boolean bl = HashedBoundList.z;
        String string = null;
        if (this.fComponentPainters != null) {
            int n = this.fComponentPainters.size();
            for (int i = 0; string == null && i < n; ++i) {
                if (!(this.fComponentPainters.get(i) instanceof TooltipProvider)) continue;
                string = ((TooltipProvider)this.fComponentPainters.get(i)).getToolTipText(mouseEvent);
                if (!bl) continue;
            }
        }
        return string;
    }
}

