/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.utils;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseImpl;
import com.jp.protection.utils.DumpUtils;
import com.jp.util.IndexedPropertiesSupport;
import dev.entities.Customer;
import dev.util.PropertiesUtil;
import dev.util.StringUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.Preferences;

public class LicenseUtils {
    public static final String PROPERTY_LICENSE_NUMBER;
    public static final String PROPERTY_LICENSE_TYPE;
    public static final String PROPERTY_LICENSE_OPTIONS;
    public static final String PROPERTY_LICENSE_EXPIRE_DATE;
    public static final String PROPERTY_LICENSE_ISSUE_DATE;
    public static final String PROPERTY_NUMBER_COPIES;
    public static final String PROPERTY_GRACE_PERIOD;
    public static final String PROPERTY_PRODUCT;
    public static final String PROPERTY_PRODUCT_EDITION;
    public static final String PROPERTY_PRODUCT_MAJOR_VERSION;
    public static final String PROPERTY_PRODUCT_MINOR_VERSION;
    public static final String PROPERTY_PRODUCT_FEATURE;
    public static final String PROPERTY_PRODUCT_FEATURE_COUNT;
    public static final String PROPERTY_USER_LICENSING_MODEL;
    public static final String PROPERTY_LICENSE_PROP;
    public static final String PROPERTY_LICENSE_PROP_NAME = "n";
    public static final String PROPERTY_LICENSE_PROP_VALUE = "v";
    public static final String PROPERTY_LICENSE_TEXT;
    public static final String PATTERN_TRUE;
    public static final String PATTERN_FALSE;
    public static final String FEATURE_NAME_VALUE_DELIMITER;
    public static final String FEATURE_VALUE_DELIMITER = ",";
    private static final Set PROTECTION_LICENSE_PROPERIES;
    public static final String ARGUMENT_LICENSE_PROPERTY_FREFIX;
    public static final String ARGUMENT_LICENSE_FEATURE_PREFIX;
    public static final String ARGUMENT_LICENSE_EULA;
    public static final String ARGUMENT_LICENSE_USER_MODEL;
    public static final String BYTE_DELIMITER = ",";
    public static final String LONG_DELIMITER = ",";
    protected static int javaVersion;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public static void save(License license, Properties properties) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        if (license.getLicenseNumber() != null) {
            properties.setProperty(PROPERTY_LICENSE_NUMBER, license.getLicenseNumber());
        }
        properties.setProperty(PROPERTY_LICENSE_TYPE, String.valueOf(license.getLicenseType()));
        properties.setProperty(PROPERTY_LICENSE_OPTIONS, String.valueOf(license.getLicenseOptions()));
        if (license.getLicenseIssueDate() != null) {
            properties.setProperty(PROPERTY_LICENSE_ISSUE_DATE, String.valueOf(license.getLicenseIssueDate().getTime()));
        }
        if (license.getLicenseExpireDate() != null) {
            properties.setProperty(PROPERTY_LICENSE_EXPIRE_DATE, String.valueOf(license.getLicenseExpireDate().getTime()));
        }
        properties.setProperty(PROPERTY_NUMBER_COPIES, String.valueOf(license.getNumberCopies()));
        properties.setProperty(PROPERTY_GRACE_PERIOD, String.valueOf(license.getGracePeriod()));
        if (license.getProduct() != null) {
            properties.setProperty(PROPERTY_PRODUCT, license.getProduct());
        }
        if (license.getProductEdition() != null) {
            properties.setProperty(PROPERTY_PRODUCT_EDITION, license.getProductEdition());
        }
        properties.setProperty(PROPERTY_PRODUCT_MAJOR_VERSION, String.valueOf(license.getProductMajorVersion()));
        properties.setProperty(PROPERTY_PRODUCT_MINOR_VERSION, String.valueOf(license.getProductMinorVersion()));
        if (license.getLicenseText() != null) {
            properties.setProperty(PROPERTY_LICENSE_TEXT, license.getLicenseText());
        }
        properties.setProperty(PROPERTY_USER_LICENSING_MODEL, String.valueOf(license.getUserLicensingModel()));
        LicenseUtils.saveLicenseFeatures(license, properties);
        LicenseUtils.saveLicenseProperties(license, properties);
        if (StringUtils.z) {
            DumpUtils.PropertyPresentationImpl.z = !bl;
        }
    }

    private static void saveLicenseProperties(License license, Properties properties) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(properties);
        indexedPropertiesSupport.setIndexName(PROPERTY_LICENSE_PROP);
        indexedPropertiesSupport.setItemCount(license.getPropertyNames().size());
        int n = 0;
        Iterator iterator = license.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            indexedPropertiesSupport.setIndex(n++);
            indexedPropertiesSupport.setProperty(PROPERTY_LICENSE_PROP_NAME, string);
            indexedPropertiesSupport.setProperty(PROPERTY_LICENSE_PROP_VALUE, license.getProperty(string, ""));
            if (!bl) continue;
        }
    }

    private static void saveLicenseFeatures(License license, Properties properties) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        Collection collection = license.getProductFeatureNames();
        if (collection.size() > 0) {
            properties.setProperty(PROPERTY_PRODUCT_FEATURE_COUNT, String.valueOf(collection.size()));
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i <= 4; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(license.isProductFeatureSupported(string, i) ? PATTERN_TRUE : PATTERN_FALSE);
                    if (!bl) continue;
                }
                stringBuffer.insert(0, FEATURE_NAME_VALUE_DELIMITER);
                stringBuffer.insert(0, string);
                properties.setProperty(A[9] + n + "]", stringBuffer.toString());
                ++n;
                if (!bl) continue;
            }
        }
    }

    public static void load(License license, Properties properties) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        LicenseImpl licenseImpl = (LicenseImpl)license;
        licenseImpl.setLicenseNumber(properties.getProperty(PROPERTY_LICENSE_NUMBER));
        licenseImpl.setLicenseType(Integer.parseInt(properties.getProperty(PROPERTY_LICENSE_TYPE)));
        licenseImpl.setLicenseOptions(Integer.parseInt(properties.getProperty(PROPERTY_LICENSE_OPTIONS, "0")));
        String string = properties.getProperty(PROPERTY_LICENSE_ISSUE_DATE);
        if (string != null) {
            licenseImpl.setLicenseIssueDate(new Date(Long.parseLong(string)));
        }
        if ((string = properties.getProperty(PROPERTY_LICENSE_EXPIRE_DATE)) != null) {
            licenseImpl.setLicenseExpireDate(new Date(Long.parseLong(string)));
        }
        licenseImpl.setNumberCopies(Integer.parseInt(properties.getProperty(PROPERTY_NUMBER_COPIES)));
        licenseImpl.setGracePeriod(Integer.parseInt(properties.getProperty(PROPERTY_GRACE_PERIOD)));
        licenseImpl.setProduct(properties.getProperty(PROPERTY_PRODUCT));
        licenseImpl.setProductEdition(properties.getProperty(PROPERTY_PRODUCT_EDITION));
        licenseImpl.setProductMajorVersion(Integer.parseInt(properties.getProperty(PROPERTY_PRODUCT_MAJOR_VERSION)));
        licenseImpl.setProductMinorVersion(Integer.parseInt(properties.getProperty(PROPERTY_PRODUCT_MINOR_VERSION)));
        licenseImpl.setLicenseText(properties.getProperty(PROPERTY_LICENSE_TEXT));
        licenseImpl.setUserLicensingModel(Integer.parseInt(properties.getProperty(PROPERTY_USER_LICENSING_MODEL, String.valueOf(0))));
        LicenseUtils.loadProductFeatures(licenseImpl, properties);
        LicenseUtils.loadProductProperties(licenseImpl, properties);
        if (bl) {
            StringUtils.z = !StringUtils.z;
        }
    }

    private static void loadProductProperties(LicenseImpl licenseImpl, Properties properties) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        IndexedPropertiesSupport indexedPropertiesSupport = new IndexedPropertiesSupport(properties);
        indexedPropertiesSupport.setIndexName(PROPERTY_LICENSE_PROP);
        int n = indexedPropertiesSupport.getItemCount();
        for (int i = 0; i < n; ++i) {
            indexedPropertiesSupport.setIndex(i);
            licenseImpl.putProperty(indexedPropertiesSupport.getProperty(PROPERTY_LICENSE_PROP_NAME), indexedPropertiesSupport.getProperty(PROPERTY_LICENSE_PROP_VALUE));
            if (!bl) continue;
        }
    }

    private static void loadProductFeatures(LicenseImpl licenseImpl, Properties properties) throws NumberFormatException {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        int n = Integer.parseInt(properties.getProperty(PROPERTY_PRODUCT_FEATURE_COUNT, "0"));
        for (int i = 0; i < n; ++i) {
            String string = properties.getProperty(A[9] + i + "]");
            int n2 = string.indexOf(FEATURE_NAME_VALUE_DELIMITER);
            if (n2 == -1) continue;
            String string2 = string.substring(0, n2);
            String[] stringArray = string.substring(n2 + FEATURE_NAME_VALUE_DELIMITER.length(), string.length()).split(",");
            Boolean[] booleanArray = new Boolean[stringArray.length];
            if (booleanArray.length == 1) {
                licenseImpl.getProductFeaturesMap().put(string2, stringArray[0].equals(PATTERN_TRUE) ? Boolean.TRUE : Boolean.FALSE);
                if (!bl) continue;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                booleanArray[j] = stringArray[j].equals(PATTERN_TRUE) ? Boolean.TRUE : Boolean.FALSE;
                if (!bl) continue;
            }
            licenseImpl.getProductFeaturesMap().put(string2, booleanArray);
            if (!bl) continue;
        }
    }

    public static Preferences getCustomerPreferences(String string) {
        return Preferences.userRoot().node(string + A[0]);
    }

    public static int getTimeZoneOffset(Calendar calendar) {
        return (calendar.get(15) + calendar.get(16)) / 60000;
    }

    public static Date getLicenseIssueDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        return LicenseUtils.getLicenseIssueDate(calendar);
    }

    public static Date getLicenseIssueDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLicenseExpirationDate() {
        return LicenseUtils.getLicenseExpirationDate(Calendar.getInstance());
    }

    public static Date getLicenseExpirationDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return LicenseUtils.getLicenseExpirationDate(calendar);
    }

    public static Date getLicenseExpirationDate(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isProtectionLicenseProperty(String string) {
        return PROTECTION_LICENSE_PROPERIES.contains(string);
    }

    protected static String getPrefixedLicensePropertyName(String string) {
        return ARGUMENT_LICENSE_PROPERTY_FREFIX + string;
    }

    protected static boolean isPrefixedLicensePropertyName(String string) {
        return string.startsWith(ARGUMENT_LICENSE_PROPERTY_FREFIX);
    }

    protected static String getLicensePropertyName(String string) {
        return string.substring(ARGUMENT_LICENSE_PROPERTY_FREFIX.length(), string.length());
    }

    protected static String getPrefixedLicenseFeatureName(String string) {
        return ARGUMENT_LICENSE_FEATURE_PREFIX + string;
    }

    protected static boolean isPrefixedLicenseFeatureName(String string) {
        return string.startsWith(ARGUMENT_LICENSE_FEATURE_PREFIX);
    }

    protected static String getLicenseFeatureName(String string) {
        return string.substring(ARGUMENT_LICENSE_FEATURE_PREFIX.length(), string.length());
    }

    public static void properties2Arguments(Map map, Map map2) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            map.put(LicenseUtils.getPrefixedLicensePropertyName(string), map2.get(string));
            if (!bl) continue;
        }
    }

    public static void arguments2Properties(Map map, Map map2) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (LicenseUtils.isPrefixedLicensePropertyName(string)) {
                map2.put(LicenseUtils.getLicensePropertyName(string), map.get(string));
            }
            if (!bl) continue;
        }
    }

    public static void features2Arguments(Map map, Map map2) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            block7: {
                Object v;
                block6: {
                    stringBuffer.setLength(0);
                    string = (String)iterator.next();
                    v = map2.get(string);
                    if (!(v instanceof Boolean)) break block6;
                    stringBuffer.append(LicenseUtils.boolean2String((Boolean)v));
                    if (!bl) break block7;
                }
                Boolean[] booleanArray = (Boolean[])v;
                for (int i = 0; i < booleanArray.length; ++i) {
                    Boolean bl2 = booleanArray[i];
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(LicenseUtils.boolean2String(bl2));
                    if (!bl) continue;
                }
            }
            map.put(LicenseUtils.getPrefixedLicenseFeatureName(string), stringBuffer.toString());
            if (!bl) continue;
        }
    }

    public static void arguments2Features(Map map, Map map2) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (LicenseUtils.isPrefixedLicenseFeatureName(string)) {
                String[] stringArray = ((String)map.get(string)).split(",");
                Boolean[] booleanArray = new Boolean[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    booleanArray[i] = LicenseUtils.string2Boolean(stringArray[i]);
                    if (!bl) continue;
                }
                map2.put(LicenseUtils.getLicenseFeatureName(string), booleanArray);
            }
            if (!bl) continue;
        }
    }

    private static Boolean string2Boolean(String string) {
        return "1".equals(string) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String boolean2String(Boolean bl) {
        return Boolean.TRUE.equals(bl) ? "1" : "0";
    }

    public static String toString(byte[] byArray) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(byArray[i]);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static byte[] toBytes(String string) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        String[] stringArray = string.split(",");
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i].trim());
            if (!bl) continue;
        }
        return byArray;
    }

    public static String toString(long[] lArray) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(lArray[i]);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static long[] toLongs(String string) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        String[] stringArray = string.split(",");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i].trim());
            if (!bl) continue;
        }
        return lArray;
    }

    protected static void putProperty(LicenseImpl licenseImpl, String string, String string2) {
        block3: {
            block2: {
                if (StringUtils.noValue(string2)) break block2;
                licenseImpl.getProperties().put(string, string2);
                if (!DumpUtils.PropertyPresentationImpl.z) break block3;
            }
            licenseImpl.getProperties().remove(string);
        }
    }

    public static void fromLicense(License license, Customer customer) {
        customer.setFirstName(license.getProperty(A[15], null));
        customer.setLastName(license.getProperty(A[10], null));
        customer.setTitle(license.getProperty(A[11], null));
        customer.setCompany(license.getProperty(A[20], null));
        customer.setPhone(license.getProperty(A[13], null));
        customer.setEmail(license.getProperty(A[14], null));
        customer.setAddress(license.getProperty(A[19], null));
        customer.setCity(license.getProperty(A[12], null));
        customer.setZip(license.getProperty(A[17], null));
        customer.setState(license.getProperty(A[16], null));
        customer.setCountry(license.getProperty(A[18], null));
    }

    public static void toLicense(LicenseImpl licenseImpl, Customer customer) {
        LicenseUtils.putProperty(licenseImpl, A[15], customer.getFirstName());
        LicenseUtils.putProperty(licenseImpl, A[10], customer.getLastName());
        LicenseUtils.putProperty(licenseImpl, A[11], customer.getTitle());
        LicenseUtils.putProperty(licenseImpl, A[20], customer.getCompany());
        LicenseUtils.putProperty(licenseImpl, A[13], customer.getPhone());
        LicenseUtils.putProperty(licenseImpl, A[14], customer.getEmail());
        LicenseUtils.putProperty(licenseImpl, A[19], customer.getAddress());
        LicenseUtils.putProperty(licenseImpl, A[12], customer.getCity());
        LicenseUtils.putProperty(licenseImpl, A[17], customer.getZip());
        LicenseUtils.putProperty(licenseImpl, A[16], customer.getState());
        LicenseUtils.putProperty(licenseImpl, A[18], customer.getCountry());
    }

    public static String toHexString(String string) {
        return LicenseUtils.toHexString(Long.parseLong(string));
    }

    public static String toHexString(long[] lArray) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(A[1]);
            }
            stringBuffer.append(LicenseUtils.toHexString(lArray[i]));
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static String toHexString(long l) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l).toUpperCase());
        while (stringBuffer.length() < 12) {
            stringBuffer.insert(0, "0");
            if (!bl) continue;
        }
        for (int i = 2; i < stringBuffer.length(); i += 2) {
            stringBuffer.insert(i++, "-");
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static long fromHexString(String string) {
        String string2 = string.replaceAll("-", "");
        return Long.parseLong(string2, 16);
    }

    public static long[] fromHexStrings(String string) {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        String[] stringArray = string.split(",");
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = LicenseUtils.fromHexString(stringArray[i].trim());
            if (!bl) continue;
        }
        return lArray;
    }

    public static void checkJRE() throws IllegalStateException {
        String string = System.getProperty(A[6]);
        if (string.equals(A[5])) {
            throw new IllegalStateException(A[3] + string);
        }
        String string2 = System.getProperty(A[4]);
        int n = Integer.parseInt(string2.substring(2, 3));
        int n2 = Integer.parseInt(string2.substring(4, 5));
        if (n < 4 || n == 4 && n2 < 2) {
            throw new IllegalStateException(A[2] + string2);
        }
    }

    public static void checkJRELibExt() throws IllegalStateException {
        boolean bl = DumpUtils.PropertyPresentationImpl.z;
        String string = System.getProperty(A[25]);
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                File[] fileArray = new File(stringArray[i]).listFiles();
                for (int j = 0; fileArray != null && j < fileArray.length; ++j) {
                    String string2 = fileArray[j].getName();
                    if (!A[26].equals(string2) && !A[24].equals(string2) && !A[23].equals(string2) && !string2.matches(A[27])) continue;
                    throw new IllegalStateException(fileArray[j].getAbsolutePath() + A[22] + A[21]);
                }
                if (!bl) continue;
            }
        }
    }

    public static int getJavaVersion() {
        if (javaVersion == -1) {
            try {
                String[] stringArray = System.getProperty(A[8]).split(A[7]);
                javaVersion = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return javaVersion;
    }

    static {
        String[] stringArray = new String[28];
        Object var0 = null;
        PROPERTY_PRODUCT_MINOR_VERSION = LicenseUtils.z(LicenseUtils.z("3M\u0011"));
        var0 = null;
        PROPERTY_PRODUCT = LicenseUtils.z(LicenseUtils.z(".V\u0010"));
        var0 = null;
        PATTERN_FALSE = LicenseUtils.z(LicenseUtils.z("8E\u0013\u0005\u0005"));
        var0 = null;
        PROPERTY_LICENSE_NUMBER = LicenseUtils.z(LicenseUtils.z("0Q\u0012"));
        var0 = null;
        PROPERTY_LICENSE_OPTIONS = LicenseUtils.z(LicenseUtils.z("1T\u000b"));
        var0 = null;
        PROPERTY_PRODUCT_MAJOR_VERSION = LicenseUtils.z(LicenseUtils.z("3E\u0015"));
        var0 = null;
        PROPERTY_PRODUCT_FEATURE = LicenseUtils.z(LicenseUtils.z("8A\u001e"));
        var0 = null;
        PROPERTY_GRACE_PERIOD = LicenseUtils.z(LicenseUtils.z("9T"));
        var0 = null;
        PROPERTY_LICENSE_ISSUE_DATE = LicenseUtils.z(LicenseUtils.z("7W\u001b"));
        var0 = null;
        ARGUMENT_LICENSE_EULA = LicenseUtils.z(LicenseUtils.z("zH\u0016\u0015\u00050W\u001a35\u0012e["));
        var0 = null;
        PATTERN_TRUE = LicenseUtils.z(LicenseUtils.z("*V\n\u0013"));
        var0 = null;
        PROPERTY_NUMBER_COPIES = LicenseUtils.z(LicenseUtils.z("0Q\u001c"));
        var0 = null;
        PROPERTY_PRODUCT_FEATURE_COUNT = LicenseUtils.z(LicenseUtils.z("8G\u0011\u0002"));
        var0 = null;
        PROPERTY_LICENSE_TEXT = LicenseUtils.z(LicenseUtils.z("*\\\u000b"));
        var0 = null;
        ARGUMENT_LICENSE_USER_MODEL = LicenseUtils.z(LicenseUtils.z("zH\u0016\u0015\u00050W\u001a#\u0013;V2\u0019\u0004;H["));
        var0 = null;
        PROPERTY_PRODUCT_EDITION = LicenseUtils.z(LicenseUtils.z(".V\u001a"));
        var0 = null;
        PROPERTY_LICENSE_TYPE = LicenseUtils.z(LicenseUtils.z("*]\u000f"));
        var0 = null;
        PROPERTY_LICENSE_EXPIRE_DATE = LicenseUtils.z(LicenseUtils.z(";\\\u001b"));
        var0 = null;
        PROPERTY_USER_LICENSING_MODEL = LicenseUtils.z(LicenseUtils.z("+H\u0012"));
        var0 = null;
        FEATURE_NAME_VALUE_DELIMITER = LicenseUtils.z(LicenseUtils.z("~\t_"));
        var0 = null;
        ARGUMENT_LICENSE_PROPERTY_FREFIX = LicenseUtils.z(LicenseUtils.z("zH\u0016\u0015\u00050W\u001a&\u00121T\u001a\u0004\u0014'\u0000"));
        var0 = null;
        PROPERTY_LICENSE_PROP = LicenseUtils.z(LicenseUtils.z(".V\u0010\u0006"));
        var0 = null;
        ARGUMENT_LICENSE_FEATURE_PREFIX = LicenseUtils.z(LicenseUtils.z("zH\u0016\u0015\u00050W\u001a0\u0005?P\n\u0004\u0005z"));
        var0 = null;
        stringArray[0] = LicenseUtils.z(LicenseUtils.z("qg\n\u0005\u00141I\u001a\u0004$?P\u001e"));
        var0 = null;
        stringArray[1] = LicenseUtils.z(LicenseUtils.z("r\u0004"));
        var0 = null;
        stringArray[2] = LicenseUtils.z(LicenseUtils.z("\nL\u001aV*\bi_\u0000\u0005,W\u0016\u0019\u000e~M\fV\u000e1P_\u0005\u0015.T\u0010\u0004\u0014;@EV"));
        var0 = null;
        stringArray[3] = LicenseUtils.z(LicenseUtils.z("\nL\u001aV*\bi_\u001f\u0013~J\u0010\u0002@-Q\u000f\u0006\u000f,P\u001a\u0012Z~"));
        var0 = null;
        stringArray[4] = LicenseUtils.z(LicenseUtils.z("4E\t\u0017N,Q\u0011\u0002\t3AQ\u0000\u0005,W\u0016\u0019\u000e"));
        var0 = null;
        stringArray[5] = LicenseUtils.z(LicenseUtils.z("\u001ca>V*\fK\u001c\u001d\t*\f-_"));
        var0 = null;
        stringArray[6] = LicenseUtils.z(LicenseUtils.z("4E\t\u0017N(IQ\u0018\u00013A"));
        var0 = null;
        stringArray[7] = LicenseUtils.z(LicenseUtils.z("\u0005\n\""));
        var0 = null;
        stringArray[8] = LicenseUtils.z(LicenseUtils.z("4E\t\u0017N(A\r\u0005\t1J"));
        var0 = null;
        stringArray[9] = LicenseUtils.z(LicenseUtils.z("8A\u001e-"));
        var0 = null;
        stringArray[10] = LicenseUtils.z(LicenseUtils.z(".VQ\u001a\u0001-P1\u0017\r;"));
        var0 = null;
        stringArray[11] = LicenseUtils.z(LicenseUtils.z(".VQ\u0002\t*H\u001a"));
        var0 = null;
        stringArray[12] = LicenseUtils.z(LicenseUtils.z(".VQ\u0015\t*]"));
        var0 = null;
        stringArray[13] = LicenseUtils.z(LicenseUtils.z(".VQ\u0006\b1J\u001a"));
        var0 = null;
        stringArray[14] = LicenseUtils.z(LicenseUtils.z(".VQ\u0013\r?M\u0013"));
        var0 = null;
        stringArray[15] = LicenseUtils.z(LicenseUtils.z(".VQ\u0010\t,W\u000b8\u00013A"));
        var0 = null;
        stringArray[16] = LicenseUtils.z(LicenseUtils.z(".VQ\u0005\u0014?P\u001a"));
        var0 = null;
        stringArray[17] = LicenseUtils.z(LicenseUtils.z(".VQ\f\t."));
        var0 = null;
        stringArray[18] = LicenseUtils.z(LicenseUtils.z(".VQ\u0015\u000f+J\u000b\u0004\u0019"));
        var0 = null;
        stringArray[19] = LicenseUtils.z(LicenseUtils.z(".VQ\u0017\u0004:V\u001a\u0005\u0013"));
        var0 = null;
        stringArray[20] = LicenseUtils.z(LicenseUtils.z(".VQ\u0015\u000f3T\u001e\u0018\u0019"));
        var0 = null;
        stringArray[21] = LicenseUtils.z(LicenseUtils.z("Tp\u0017\u0013@.V\u001a\u0005\u00050G\u001aV\u000f8\u0004\u000b\u001e\t-\u0004\u0013\u001f\u0002,E\r\u000f@3E\u0006V\u0010,A\t\u0013\u000e*\u0004/\u0004\u000f*A\u001c\u0002\t1J^V\u0006,K\u0012V\u00171V\u0014\u001f\u000e9\u0004\u000f\u0004\u000f.A\r\u001a\u0019p"));
        var0 = null;
        stringArray[22] = LicenseUtils.z(LicenseUtils.z("TH\u0016\u0014\u0012?V\u0006V\r+W\u000bV\u000e1P_\u0014\u0005~H\u0010\u0015\u0001*A\u001bV\t0\u0004\u000b\u001e\u0005~H\u0016\u0014O;\\\u000bV\u00061H\u001b\u0013\u0012~K\u0019V\u00146A_<2\u001b\n"));
        var0 = null;
        stringArray[23] = LicenseUtils.z(LicenseUtils.z("4Q\u0018X\n?V"));
        var0 = null;
        stringArray[24] = LicenseUtils.z(LicenseUtils.z("\u000eV\u0010\u0002\u0005=P\u0016\u0019\u000e\u000eV\u0016\u0000N4E\r"));
        var0 = null;
        stringArray[25] = LicenseUtils.z(LicenseUtils.z("4E\t\u0017N;\\\u000bX\u00047V\f"));
        var0 = null;
        stringArray[26] = LicenseUtils.z(LicenseUtils.z("\u000eV\u0010\u0002\u0005=P\u0016\u0019\u000epN\u001e\u0004"));
        var0 = null;
        stringArray[27] = LicenseUtils.z(LicenseUtils.z("vN\u001c\u0013\u001c<G\u000f\u0004\u000f(\rR\u001c\u00045\u007fO[Y\u0003_M\u000bM\u0005\u0015RO=%\u0017\u0002X\n?V"));
        A = stringArray;
        PROTECTION_LICENSE_PROPERIES = new HashSet();
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u0017\u000b")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u0017\u0007.")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u0005O0")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u0003\u00132")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u0003\u0007.")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u001a\u0013?@\u001b\u0004")));
        var0 = null;
        PROTECTION_LICENSE_PROPERIES.add(LicenseUtils.z(LicenseUtils.z(".VQ\u001a\u0007.")));
        PROTECTION_LICENSE_PROPERIES.add(A[15]);
        PROTECTION_LICENSE_PROPERIES.add(A[10]);
        PROTECTION_LICENSE_PROPERIES.add(A[11]);
        PROTECTION_LICENSE_PROPERIES.add(A[20]);
        PROTECTION_LICENSE_PROPERIES.add(A[13]);
        PROTECTION_LICENSE_PROPERIES.add(A[14]);
        PROTECTION_LICENSE_PROPERIES.add(A[19]);
        PROTECTION_LICENSE_PROPERIES.add(A[12]);
        PROTECTION_LICENSE_PROPERIES.add(A[17]);
        PROTECTION_LICENSE_PROPERIES.add(A[16]);
        PROTECTION_LICENSE_PROPERIES.add(A[18]);
        javaVersion = -1;
        PropertiesUtil.addPrefix(new Properties(), "a");
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x60);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 94;
                            break;
                        }
                        case 1: {
                            n6 = 36;
                            break;
                        }
                        case 2: {
                            n6 = 127;
                            break;
                        }
                        case 3: {
                            n6 = 118;
                            break;
                        }
                        default: {
                            n6 = 96;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

