/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.security;

import com.jp.protection.security.BouncyCastleSecurityProvider;
import com.jp.protection.security.RSASecurityProvider;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SunJCESecurityProvider;
import com.jp.protection.utils.LicenseUtils;
import dev.util.HashedListStrategy;
import dev.util.collections.HashedBoundList;
import java.util.ArrayList;
import java.util.List;

public class SecurityProviderFactory {
    private static HashedBoundList fSecurityProviders;
    protected static SecurityProvider fDefaultSecurityProvider;
    protected static boolean fUseBouncyCastleSecurityProvider;
    private static final /* synthetic */ String[] z;

    public static void setUseBouncyCastleSecurityProvider(boolean bl) {
        fUseBouncyCastleSecurityProvider = bl;
    }

    public static boolean isUseBouncyCastleSecurityProvider() {
        return LicenseUtils.getJavaVersion() < 6 || fUseBouncyCastleSecurityProvider && !z[0].equals(System.getProperty(z[1]));
    }

    protected static void initSecurityProviders() {
        if (fSecurityProviders.isEmpty()) {
            SecurityProviderFactory.registerSecurityProvider(new RSASecurityProvider());
            if (SecurityProviderFactory.isUseBouncyCastleSecurityProvider()) {
                BouncyCastleSecurityProvider.registerSecurityProvider();
            }
            if (LicenseUtils.getJavaVersion() >= 6) {
                SunJCESecurityProvider.registerSecurityProvider();
            }
            if (fDefaultSecurityProvider == null) {
                fDefaultSecurityProvider = (SecurityProvider)SecurityProviderFactory.getSecurityProviders().get(SecurityProviderFactory.getSecurityProviders().size() - 1);
            }
        }
    }

    public static boolean isLegacySecurityProvider(SecurityProvider securityProvider) {
        return securityProvider instanceof RSASecurityProvider;
    }

    public static SecurityProvider getDefaultSecurityProvider() {
        SecurityProviderFactory.initSecurityProviders();
        return fDefaultSecurityProvider;
    }

    public static List getSecurityProviders() {
        SecurityProviderFactory.initSecurityProviders();
        return fSecurityProviders;
    }

    public static void registerSecurityProvider(SecurityProvider securityProvider) {
        fSecurityProviders.add(securityProvider);
    }

    public static void unRegisterSecurityProvider(String string) {
        fSecurityProviders.remove(SecurityProviderFactory.getSecurityProvider(string));
    }

    public static synchronized SecurityProvider getSecurityProvider(String string) {
        SecurityProviderFactory.initSecurityProviders();
        return (SecurityProvider)fSecurityProviders.get(string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "];\u0015}M".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 59;
                                    break;
                                }
                                case 1: {
                                    n8 = 90;
                                    break;
                                }
                                case 2: {
                                    n8 = 121;
                                    break;
                                }
                                case 3: {
                                    n8 = 14;
                                    break;
                                }
                                default: {
                                    n8 = 40;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "X5\u0014 BKt\t|GO?\u001azAT4W}MX/\u000bg\\Bt\f}My5\f`KB\u0019\u0018}\\W?*kKN(\u0010zQk(\u0016xA_?\u000b".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 59;
                            break;
                        }
                        case 1: {
                            n11 = 90;
                            break;
                        }
                        case 2: {
                            n11 = 121;
                            break;
                        }
                        case 3: {
                            n11 = 14;
                            break;
                        }
                        default: {
                            n11 = 40;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
        fSecurityProviders = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

            public Object getKeyForObject(Object object) {
                return ((SecurityProvider)object).getID();
            }
        });
        fUseBouncyCastleSecurityProvider = true;
    }
}

