/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.network;

import com.jp.protection.pub.pro.network.NetworkCheckListener;
import com.jp.protection.pub.pro.network.NetworkCheckPacket;
import dev.util.StringUtils;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Vector;

public class NetworkCheck {
    public static final int SOCKET_PORT_NUMBER = 1971;
    public static final int SOCKET_TIME_TO_LIVE = 2;
    public static final String SOCKET_GROUP_NAME;
    public static final int SOCKET_BUFFER_SIZE = 1024;
    public static final int SOCKET_TIMEOUT = 0;
    public static String SIGNATURE;
    protected int fSocketPortNumber = 1971;
    protected int fSocketTimeToLive = 2;
    protected String fSocketGroupName = SOCKET_GROUP_NAME;
    protected int fSocketBufferSize = 1024;
    protected int fSocketTimeout = 0;
    protected String fHostID;
    protected long fHostTimestamp = System.currentTimeMillis();
    protected String fSignature = SIGNATURE;
    protected MulticastSocket fMulticastSocket;
    protected Thread fRunnerTread;
    protected boolean fRunning = false;
    protected HashSet fResponceAddresses = new HashSet();
    protected String fProductID;
    protected String fLicenseNumber;
    protected int fNumberCopies = 0;
    protected InetAddress fGroup;
    protected boolean fVerbose = true;
    private transient Vector fNetworkCheckListeners;
    public static final int POLICY_SAME_HOST = 1;
    public static final int POLICY_DIFFERENT_HOST = 2;
    public static final int POLICY_ANY_HOST = 3;
    protected int fDefaultCheckHostPolicy = 2;
    protected int fCheckHostPolicy = 2;
    protected int fResponseCount = 0;
    public static /* synthetic */ int z;
    private static final /* synthetic */ String A;

    public NetworkCheck() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.fHostID = inetAddress.getHostName();
            if (this.fHostID == null) {
                this.fHostID = inetAddress.toString();
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public int getSocketTimeout() {
        return this.fSocketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.fSocketTimeout = n;
    }

    public int getSocketBufferSize() {
        return this.fSocketBufferSize;
    }

    public void setSocketBufferSize(int n) {
        this.fSocketBufferSize = n;
    }

    public String getSocketGroupName() {
        return this.fSocketGroupName;
    }

    public void setSocketGroupName(String string) {
        this.fSocketGroupName = string;
        this.fGroup = null;
    }

    public int getSocketTimeToLive() {
        return this.fSocketTimeToLive;
    }

    public void setSocketTimeToLive(int n) {
        this.fSocketTimeToLive = n;
    }

    public int getSocketPortNumber() {
        return this.fSocketPortNumber;
    }

    public void setSocketPortNumber(int n) {
        this.fSocketPortNumber = n;
    }

    public synchronized void start() {
        if (this.fRunning) {
            return;
        }
        this.createMulticastSocket();
        this.fRunnerTread = new Thread(new Runnable(){

            public void run() {
                int n = z;
                try {
                    int n2 = NetworkCheck.this.fMulticastSocket.getReceiveBufferSize();
                    DatagramPacket datagramPacket = new DatagramPacket(new byte[n2], n2);
                    NetworkCheck.this.fRunning = true;
                    try {
                        while (NetworkCheck.this.fRunning) {
                            NetworkCheck.this.fMulticastSocket.receive(datagramPacket);
                            NetworkCheck.this.processDatagramPacket(datagramPacket);
                            if (n == 0) continue;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NetworkCheck.this.stop();
                }
                catch (Exception exception) {
                    NetworkCheck.this.error(exception);
                }
            }
        });
        this.fRunnerTread.start();
    }

    private void error(Exception exception) {
        if (this.isVerbose()) {
            exception.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (!this.fRunning) {
            return;
        }
        this.fRunning = false;
        if (this.fRunnerTread.isAlive()) {
            this.fRunnerTread.interrupt();
            this.fMulticastSocket.close();
        }
    }

    protected boolean isRunning() {
        return this.fRunning;
    }

    public String getProductID() {
        return this.fProductID;
    }

    public void setProductID(String string) {
        this.fProductID = string;
    }

    public String getLicenseNumber() {
        return this.fLicenseNumber;
    }

    public void setLicenseNumber(String string) {
        this.fLicenseNumber = string;
    }

    public int getNumberCopies() {
        return this.fNumberCopies;
    }

    public void setNumberCopies(int n) {
        this.fNumberCopies = n;
    }

    public synchronized void check() {
        if (!this.isRunning()) {
            this.start();
        }
        this.fResponceAddresses.clear();
        this.sendRequest(this.fProductID, this.fLicenseNumber);
    }

    protected void send(NetworkCheckPacket networkCheckPacket) {
        if (this.fMulticastSocket == null) {
            throw new IllegalStateException(A);
        }
        try {
            byte[] byArray = networkCheckPacket.toByteArray();
            networkCheckPacket.fromByteArray(byArray, 0, byArray.length);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.getGroup(), this.getSocketPortNumber());
            this.fMulticastSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    protected synchronized void createMulticastSocket() {
        try {
            this.fMulticastSocket = new MulticastSocket(this.getSocketPortNumber());
            this.fMulticastSocket.setTimeToLive(this.getSocketTimeToLive());
            this.fMulticastSocket.setSendBufferSize(this.getSocketBufferSize());
            this.fMulticastSocket.setSoTimeout(this.getSocketTimeout());
            this.fMulticastSocket.joinGroup(this.getGroup());
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    protected InetAddress getGroup() throws UnknownHostException {
        if (this.fGroup == null) {
            this.fGroup = InetAddress.getByName(this.getSocketGroupName());
        }
        return this.fGroup;
    }

    protected synchronized void releaseMulticastSocket() {
        try {
            this.fMulticastSocket.leaveGroup(this.getGroup());
            this.fMulticastSocket.close();
            this.fMulticastSocket = null;
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void processDatagramPacket(DatagramPacket datagramPacket) {
        block6: {
            try {
                NetworkCheckPacket networkCheckPacket = new NetworkCheckPacket();
                networkCheckPacket.fromByteArray(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                if (!this.fSignature.equals(networkCheckPacket.getSignature()) || !this.fProductID.equals(networkCheckPacket.getProductID()) || !this.fLicenseNumber.equals(networkCheckPacket.getLicenseNumber())) break block6;
                if (networkCheckPacket.getType() == 0) {
                    this.sendResponse(this.fProductID, this.fLicenseNumber);
                    if (z == 0) break block6;
                }
                if (networkCheckPacket.getType() == 1 && this.checkResponse(networkCheckPacket)) {
                    this.fResponceAddresses.add(datagramPacket.getAddress());
                    if (++this.fResponseCount >= this.fNumberCopies) {
                        this.fireNumberCopiesViolation(this, this.fResponseCount + 1);
                    }
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
    }

    public int getCheckHostPolicy() {
        return this.fCheckHostPolicy;
    }

    public void setCheckHostPolicy(int n) {
        this.fCheckHostPolicy = n;
    }

    public int getDefaultCheckHostPolicy() {
        return this.fDefaultCheckHostPolicy;
    }

    public void setDefaultCheckHostPolicy(int n) {
        this.fDefaultCheckHostPolicy = n;
    }

    protected boolean checkResponse(NetworkCheckPacket networkCheckPacket) {
        return this.checkHost(networkCheckPacket) && networkCheckPacket.getHostTimestamp() < this.fHostTimestamp;
    }

    protected boolean checkHost(NetworkCheckPacket networkCheckPacket) {
        boolean bl = true;
        switch (this.fCheckHostPolicy) {
            case 1: {
                bl = StringUtils.equals(networkCheckPacket.getHostID(), this.fHostID);
                if (z == 0) break;
            }
            case 2: {
                bl = !StringUtils.equals(networkCheckPacket.getHostID(), this.fHostID);
            }
        }
        return bl;
    }

    public int getResponseCount() {
        return this.fResponseCount;
    }

    protected void sendResponse(String string, String string2) {
        this.send(NetworkCheckPacket.createResponse(string, string2, this.fSignature, this.fHostID, this.fHostTimestamp));
    }

    protected void sendRequest(String string, String string2) {
        this.send(NetworkCheckPacket.createRequest(string, string2, this.fSignature, this.fHostID, this.fHostTimestamp));
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String string) {
        this.fSignature = string;
    }

    public synchronized void removeNetworkCheckListener(NetworkCheckListener networkCheckListener) {
        if (this.fNetworkCheckListeners != null && this.fNetworkCheckListeners.contains(networkCheckListener)) {
            Vector vector = (Vector)this.fNetworkCheckListeners.clone();
            vector.removeElement(networkCheckListener);
            this.fNetworkCheckListeners = vector;
        }
    }

    public synchronized void addNetworkCheckListener(NetworkCheckListener networkCheckListener) {
        Vector vector;
        Vector vector2 = vector = this.fNetworkCheckListeners == null ? new Vector(2) : (Vector)this.fNetworkCheckListeners.clone();
        if (!vector.contains(networkCheckListener)) {
            vector.addElement(networkCheckListener);
            this.fNetworkCheckListeners = vector;
        }
    }

    protected void fireNumberCopiesViolation(NetworkCheck networkCheck, int n) {
        int n2 = z;
        if (this.fNetworkCheckListeners != null) {
            Vector vector = this.fNetworkCheckListeners;
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                ((NetworkCheckListener)vector.elementAt(i)).numberCopiesViolation(networkCheck, n);
                if (n2 == 0) continue;
            }
        }
    }

    static {
        Object var0 = null;
        A = NetworkCheck.z(NetworkCheck.z("ov[<iSx\u000f(nDpDkoR3A$r\u0001`[*tUvK"));
        var0 = null;
        SOCKET_GROUP_NAME = NetworkCheck.z(NetworkCheck.z("\u0013!\u001be6\u000f#\u0001z"));
        var0 = null;
        SIGNATURE = NetworkCheck.z(NetworkCheck.z("KC]$bTp[\"pHgVfVS|[.eUz@%'"));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 6);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 33;
                            break;
                        }
                        case 1: {
                            n6 = 19;
                            break;
                        }
                        case 2: {
                            n6 = 47;
                            break;
                        }
                        case 3: {
                            n6 = 75;
                            break;
                        }
                        default: {
                            n6 = 6;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

