/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.pro.ls.BasicLicenseStorage;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarLicenseStorage
extends BasicLicenseStorage {
    public static final String ROOT_LICENSE_ENTRIES;
    public static final String EXTENSION_LICENSE_ENTRY;
    public static final Attributes.Name PROPERTY_DIGEST;
    public static final Attributes.Name PROPERTY_SEPARATE_LICENSE;
    public static final byte[] COOKIE;
    protected boolean fSeparateLicense = true;
    protected static final byte[] EMPTY_LICENSE_BYTES;
    protected MessageDigest fMessageDigest;
    private static final /* synthetic */ String[] A;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream fileInputStream = file.canRead() ? new FileInputStream(file) : null;
        try {
            this.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream inputStream) throws IOException {
        boolean bl = BasicLicenseStorage.z;
        boolean bl2 = false;
        this.fireBeforeLicenseStorageLoad();
        try {
            this.fLicenseEntryMap.clear();
            this.resetDigest();
            if (inputStream != null) {
                String string = null;
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                try {
                    Object object;
                    Cloneable cloneable;
                    if (jarInputStream.getManifest() != null) {
                        cloneable = jarInputStream.getManifest().getMainAttributes();
                        string = (String)((Attributes)cloneable).get(PROPERTY_DIGEST);
                        object = ((Attributes)cloneable).get(PROPERTY_SEPARATE_LICENSE);
                        if (object != null) {
                            this.setSeparateLicense(Boolean.TRUE.toString().equals(object));
                        }
                    }
                    cloneable = jarInputStream.getNextJarEntry();
                    while (cloneable != null) {
                        try {
                            object = ((ZipEntry)cloneable).getName();
                            if (!((ZipEntry)cloneable).isDirectory() && ((String)object).startsWith(ROOT_LICENSE_ENTRIES)) {
                                this.loadLicenseEntry(jarInputStream, (JarEntry)cloneable);
                            }
                        }
                        finally {
                            jarInputStream.closeEntry();
                        }
                        cloneable = jarInputStream.getNextJarEntry();
                        if (!bl) continue;
                        break;
                    }
                }
                finally {
                    jarInputStream.close();
                }
                this.checkDigest(string != null ? LicenseUtils.toBytes(string) : null);
            }
            this.calculateCurrentID();
            this.setModified(false);
            bl2 = true;
        }
        finally {
            this.fireLicenseStorageLoaded(bl2);
        }
    }

    private final void checkDigest(byte[] byArray) throws IOException {
        this.updateDigest(COOKIE);
        byte[] byArray2 = this.getDigest();
        boolean bl = Arrays.equals(byArray, byArray2);
        if (!bl) {
            this.fLicenseEntryMap.clear();
            throw new IOException(A[2]);
        }
    }

    protected boolean isLicenseBytesEntry(JarEntry jarEntry) {
        return !jarEntry.getName().endsWith(EXTENSION_LICENSE_ENTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLicenseEntry(JarInputStream jarInputStream, JarEntry jarEntry) throws IOException {
        block12: {
            Object object;
            byte[] byArray;
            block11: {
                byArray = StreamUtil.readB(jarInputStream);
                if (this.isLicenseBytesEntry(jarEntry)) break block11;
                object = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                try {
                    try {
                        LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)objectInputStream.readObject();
                        if (!this.isSeparateLicense()) {
                            licenseEntry.setLicenseBytes((byte[])objectInputStream.readObject());
                            this.updateDigest(licenseEntry.getLicenseBytes());
                        }
                        this.addLicenseEntryImpl(licenseEntry, this.getLicenseEntryName(jarEntry));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException(classNotFoundException.getMessage());
                    }
                }
                finally {
                    objectInputStream.close();
                }
                if (!BasicLicenseStorage.z) break block12;
            }
            if ((object = this.getLicenseEntry(this.getLicenseBytesEntryName(jarEntry))) != null) {
                object.setLicenseBytes(byArray);
                this.updateDigest(byArray);
            }
        }
    }

    protected String getLicenseEntryName(JarEntry jarEntry) {
        String string = jarEntry.getName();
        return string.substring(ROOT_LICENSE_ENTRIES.length() + 1, string.length() - EXTENSION_LICENSE_ENTRY.length());
    }

    protected String getLicenseBytesEntryName(JarEntry jarEntry) {
        String string = jarEntry.getName();
        return string.substring(ROOT_LICENSE_ENTRIES.length() + 1, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.store(fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(OutputStream outputStream) throws IOException {
        boolean bl = BasicLicenseStorage.z;
        boolean bl2 = false;
        this.fireBeforeLicenseStorageSave();
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream, this.createManifest());
            try {
                this.storeLicenseEntries(jarOutputStream);
            }
            finally {
                jarOutputStream.close();
            }
            this.setModified(false);
            bl2 = true;
        }
        finally {
            this.fireLicenseStorageSaved(bl2);
        }
        if (StringUtils.z) {
            BasicLicenseStorage.z = !bl;
        }
    }

    protected Manifest createManifest() {
        Manifest manifest = new Manifest();
        byte[] byArray = this.calculateDigest();
        if (byArray != null) {
            manifest.getMainAttributes().put(PROPERTY_DIGEST, LicenseUtils.toString(byArray));
        }
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, A[0]);
        manifest.getMainAttributes().put(PROPERTY_SEPARATE_LICENSE, (this.isSeparateLicense() ? Boolean.TRUE : Boolean.FALSE).toString());
        return manifest;
    }

    private byte[] calculateDigest() {
        Object object;
        boolean bl = BasicLicenseStorage.z;
        this.resetDigest();
        Iterator iterator = this.getLicenseEntries("", true).iterator();
        while (iterator.hasNext()) {
            object = (LicenseStorage.LicenseEntry)iterator.next();
            this.updateDigest(object.getLicenseBytes());
            if (!bl) continue;
        }
        this.updateDigest(COOKIE);
        object = this.getDigest();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLicenseEntries(JarOutputStream jarOutputStream) throws IOException {
        boolean bl = BasicLicenseStorage.z;
        Iterator iterator = this.getLicenseEntries("", true).iterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)iterator.next();
            InputStream inputStream = this.getInputStream(licenseEntry);
            try {
                this.addJarEntry(jarOutputStream, inputStream, this.getJarEntryName(licenseEntry));
            }
            finally {
                inputStream.close();
            }
            if (this.isSeparateLicense()) {
                inputStream = this.getLicenseInputStream(licenseEntry);
                try {
                    this.addJarEntry(jarOutputStream, inputStream, this.getLicenseBytesJarEntryName(licenseEntry));
                }
                finally {
                    inputStream.close();
                }
            }
            if (!bl) continue;
        }
    }

    public boolean isSeparateLicense() {
        return this.fSeparateLicense;
    }

    public void setSeparateLicense(boolean bl) {
        this.fSeparateLicense = bl;
    }

    protected String getJarEntryName(LicenseStorage.LicenseEntry licenseEntry) {
        return A[1] + this.getName(licenseEntry) + EXTENSION_LICENSE_ENTRY;
    }

    protected String getLicenseBytesJarEntryName(LicenseStorage.LicenseEntry licenseEntry) {
        return A[1] + this.getName(licenseEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(LicenseStorage.LicenseEntry licenseEntry) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(licenseEntry);
                if (!this.isSeparateLicense()) {
                    objectOutputStream.writeObject(licenseEntry.getLicenseBytes());
                }
            }
            finally {
                objectOutputStream.close();
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected InputStream getLicenseInputStream(LicenseStorage.LicenseEntry licenseEntry) throws IOException {
        return new ByteArrayInputStream(licenseEntry.getLicenseBytes() != null ? licenseEntry.getLicenseBytes() : EMPTY_LICENSE_BYTES);
    }

    protected void addJarEntry(JarOutputStream jarOutputStream, InputStream inputStream, String string) throws IOException {
        int n;
        boolean bl = BasicLicenseStorage.z;
        byte[] byArray = new byte[1024];
        jarOutputStream.putNextEntry(new JarEntry(string));
        while ((n = inputStream.read(byArray)) != -1) {
            jarOutputStream.write(byArray, 0, n);
            if (!bl) continue;
        }
        jarOutputStream.closeEntry();
    }

    protected void updateDigest(byte[] byArray) {
        MessageDigest messageDigest = this.getMessageDigest();
        if (messageDigest != null && byArray != null) {
            messageDigest.update(byArray);
        }
    }

    protected void resetDigest() {
        MessageDigest messageDigest = this.getMessageDigest();
        if (messageDigest != null) {
            messageDigest.reset();
        }
    }

    protected byte[] getDigest() {
        MessageDigest messageDigest = this.getMessageDigest();
        return messageDigest != null ? messageDigest.digest() : null;
    }

    protected MessageDigest getMessageDigest() {
        if (this.fMessageDigest == null) {
            try {
                this.fMessageDigest = MessageDigest.getInstance(A[3]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fMessageDigest;
    }

    public LicenseReader createLicenseReader(String string) {
        LicenseStorage.LicenseEntry licenseEntry = this.getLicenseEntry(string);
        if (licenseEntry == null) {
            licenseEntry = this.createLicenseEntry();
            this.addLicenseEntry(licenseEntry, string);
        }
        return new BasicLicenseStorage.EntryLicenseReader(licenseEntry, string);
    }

    static {
        String[] stringArray = new String[6];
        Object var0 = null;
        EXTENSION_LICENSE_ENTRY = JarLicenseStorage.z(JarLicenseStorage.z("Zl\u0012\u0011/\r"));
        var0 = null;
        ROOT_LICENSE_ENTRIES = JarLicenseStorage.z(JarLicenseStorage.z("8`\u001f\u00003\u0007l\\ 3\u0000{\u0015\u0000."));
        var0 = null;
        stringArray[0] = JarLicenseStorage.z(JarLicenseStorage.z("E'L"));
        var0 = null;
        stringArray[1] = JarLicenseStorage.z(JarLicenseStorage.z("8`\u001f\u00003\u0007l\\ 3\u0000{\u0015\u0000.["));
        var0 = null;
        stringArray[2] = JarLicenseStorage.z(JarLicenseStorage.z("=g\b\u0000:\u0006`\b\u001c}\u0002`\u0013\t<\u0000`\u0013\u000b"));
        var0 = null;
        stringArray[3] = JarLicenseStorage.z(JarLicenseStorage.z("'A=Hl"));
        var0 = null;
        stringArray[4] = JarLicenseStorage.z(JarLicenseStorage.z("'l\f\u0004/\u0015}\u0019)4\u0017l\u0012\u00168"));
        var0 = null;
        stringArray[5] = JarLicenseStorage.z(JarLicenseStorage.z("8`\u001f\u00003\u0007l9\u000b)\u0006`\u0019\u0016p0`\u001b\u0000.\u0000"));
        A = stringArray;
        PROPERTY_DIGEST = new Attributes.Name(A[5]);
        PROPERTY_SEPARATE_LICENSE = new Attributes.Name(A[4]);
        var0 = null;
        COOKIE = JarLicenseStorage.z(JarLicenseStorage.z("?IUV2\u0018G_\u0016d\t=?\u000b\u0002L5\u00180i")).getBytes();
        EMPTY_LICENSE_BYTES = new byte[0];
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x5D);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 116;
                            break;
                        }
                        case 1: {
                            n6 = 9;
                            break;
                        }
                        case 2: {
                            n6 = 124;
                            break;
                        }
                        case 3: {
                            n6 = 101;
                            break;
                        }
                        default: {
                            n6 = 93;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

