/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro.ls;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.pro.ls.LicenseStorage;
import com.jp.protection.pub.pro.ls.LicenseStorageListener;
import dev.util.HashDualMap;
import dev.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class BasicLicenseStorage
implements LicenseStorage,
PropertyChangeListener {
    private int fCurrentID = 0;
    protected HashMap fLicenseEntryIDMap = new HashMap();
    protected HashDualMap fLicenseEntryMap = new HashDualMap();
    protected transient Vector fLicenseStorageListeners;
    protected boolean fModified = false;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public synchronized int getNewID() {
        return ++this.fCurrentID;
    }

    protected synchronized void calculateCurrentID() {
        boolean bl = z;
        this.fCurrentID = 0;
        Iterator iterator = this.getLicenseEntries("", true).iterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)iterator.next();
            this.fCurrentID = Math.max(this.fCurrentID, licenseEntry.getID());
            if (!bl) continue;
        }
    }

    public void assignNewID(LicenseStorage.LicenseEntry licenseEntry) {
        ((BasicLicenseEntry)licenseEntry).fID = this.getNewID();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof LicenseStorage.LicenseEntry) {
            this.setModified(true);
            this.fireLicenseEntryUpdated((LicenseStorage.LicenseEntry)propertyChangeEvent.getSource());
        }
    }

    public LicenseStorage.LicenseEntry createLicenseEntry() {
        return new BasicLicenseEntry(this.getNewID());
    }

    public void addLicenseEntry(LicenseStorage.LicenseEntry licenseEntry, String string) {
        this.addLicenseEntryImpl(licenseEntry, string);
        this.setModified(true);
        this.fireLicenseEntryAdded(licenseEntry);
    }

    protected void addLicenseEntryImpl(LicenseStorage.LicenseEntry licenseEntry, String string) throws IllegalArgumentException {
        if (this.fLicenseEntryMap.containsKey(string)) {
            throw new IllegalArgumentException(A[1] + string);
        }
        this.checkLicenseExistence(licenseEntry, licenseEntry.getLicenseBytes());
        this.fLicenseEntryMap.put(string, licenseEntry);
        this.fLicenseEntryIDMap.put(new Integer(licenseEntry.getID()), licenseEntry);
        if (licenseEntry instanceof BasicLicenseEntry) {
            ((BasicLicenseEntry)licenseEntry).setBasicLicenseStorage(this);
        }
    }

    protected void checkLicenseExistence(LicenseStorage.LicenseEntry licenseEntry, byte[] byArray) {
        boolean bl = z;
        Iterator iterator = this.fLicenseEntryMap.valueIterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry2 = (LicenseStorage.LicenseEntry)iterator.next();
            if (licenseEntry != licenseEntry2 && licenseEntry2.getLicenseBytes() != byArray && Arrays.equals(licenseEntry2.getLicenseBytes(), byArray)) {
                throw new IllegalArgumentException(A[0]);
            }
            if (!bl) continue;
        }
    }

    public Collection getLicenseEntries(String string, boolean bl) {
        boolean bl2 = z;
        ArrayList arrayList = new ArrayList();
        String string2 = string.replace('\\', '/');
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Iterator iterator = this.fLicenseEntryMap.keyIterator();
        while (iterator.hasNext()) {
            block7: {
                int n;
                String string3;
                block6: {
                    string3 = ((String)iterator.next()).replace('\\', '/');
                    if (!bl) break block6;
                    if (!string3.startsWith(string2)) break block7;
                    arrayList.add(this.fLicenseEntryMap.get(string3));
                    if (!bl2) break block7;
                }
                if ((n = string3.lastIndexOf(47)) != -1 && string2.equals(string3.substring(0, n))) {
                    arrayList.add(this.fLicenseEntryMap.get(string3));
                }
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    public Collection getLicenseEntries(String string, String string2, int n, int n2, int n3, boolean bl) {
        Collection collection = this.getLicenseEntries(string, string2, n, n2, n3);
        if (collection.isEmpty() && !bl) {
            collection = this.getLicenseEntries(string, string2, n, n2, -1);
            if (collection.isEmpty()) {
                collection = this.getLicenseEntries(string, string2, n, -1, -1);
            }
            if (collection.isEmpty()) {
                collection = this.getLicenseEntries(string, string2, -1, -1, -1);
            }
            if (collection.isEmpty()) {
                collection = this.getLicenseEntries(string, LicenseStorage.ANY_PRODUCT_EDITION, -1, -1, -1);
            }
        }
        return collection;
    }

    public Collection getLicenseEntries(String string, String string2, int n, int n2, int n3) {
        boolean bl = z;
        ArrayList<LicenseStorage.LicenseEntry> arrayList = new ArrayList<LicenseStorage.LicenseEntry>();
        Iterator iterator = this.fLicenseEntryMap.valueIterator();
        while (iterator.hasNext()) {
            LicenseStorage.LicenseEntry licenseEntry = (LicenseStorage.LicenseEntry)iterator.next();
            if (string != LicenseStorage.ANY_PRODUCT && !string.equals(licenseEntry.getProduct())) {
                licenseEntry = null;
            } else if (string2 != LicenseStorage.ANY_PRODUCT_EDITION && !string2.equals(licenseEntry.getProductEdition())) {
                licenseEntry = null;
            } else if (n > -1 && n != licenseEntry.getMajorVersion()) {
                licenseEntry = null;
            } else if (n3 > -1 && n3 != licenseEntry.getLicenseType()) {
                licenseEntry = null;
            }
            if (licenseEntry != null) {
                arrayList.add(licenseEntry);
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    public LicenseStorage.LicenseEntry getLicenseEntry(String string) {
        return (LicenseStorage.LicenseEntry)this.fLicenseEntryMap.get(string);
    }

    public String getName(LicenseStorage.LicenseEntry licenseEntry) {
        return (String)this.fLicenseEntryMap.getKey(licenseEntry);
    }

    public static String getLicenseEntryShortName(String string) {
        String string2 = string.replace('\\', '/');
        int n = string2.lastIndexOf(47);
        return n != -1 ? string2.substring(n + 1, string2.length()) : string2;
    }

    public static String getLicenseEntryPath(String string) {
        String string2 = string.replace('\\', '/');
        int n = string2.lastIndexOf(47);
        return n != -1 ? string2.substring(0, n) : null;
    }

    public void removeLicenseEntry(LicenseStorage.LicenseEntry licenseEntry) {
        this.fLicenseEntryMap.removeByValue(licenseEntry);
        this.fLicenseEntryIDMap.remove(new Integer(licenseEntry.getID()));
        if (licenseEntry instanceof BasicLicenseEntry) {
            ((BasicLicenseEntry)licenseEntry).setBasicLicenseStorage(null);
        }
        this.setModified(true);
        this.fireLicenseEntryRemoved(licenseEntry);
    }

    public LicenseStorage.LicenseEntry getLicenseEntry(int n) {
        return (LicenseStorage.LicenseEntry)this.fLicenseEntryIDMap.get(new Integer(n));
    }

    public synchronized void addLicenseStorageListener(LicenseStorageListener licenseStorageListener) {
        Vector vector;
        Vector vector2 = vector = this.fLicenseStorageListeners == null ? new Vector(2) : (Vector)this.fLicenseStorageListeners.clone();
        if (!vector.contains(licenseStorageListener)) {
            vector.addElement(licenseStorageListener);
            this.fLicenseStorageListeners = vector;
        }
    }

    public synchronized void removeLicenseStorageListener(LicenseStorageListener licenseStorageListener) {
        if (this.fLicenseStorageListeners != null && this.fLicenseStorageListeners.contains(licenseStorageListener)) {
            Vector vector = (Vector)this.fLicenseStorageListeners.clone();
            vector.removeElement(licenseStorageListener);
            this.fLicenseStorageListeners = vector;
        }
    }

    protected void fireLicenseEntryAdded(LicenseStorage.LicenseEntry licenseEntry) {
        boolean bl = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).licenseEntryAdded(this, licenseEntry);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseEntryUpdated(LicenseStorage.LicenseEntry licenseEntry) {
        boolean bl = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).licenseEntryUpdated(this, licenseEntry);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseEntryRemoved(LicenseStorage.LicenseEntry licenseEntry) {
        boolean bl = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).licenseEntryRemoved(this, licenseEntry);
                if (!bl) continue;
            }
        }
    }

    protected void fireBeforeLicenseStorageLoad() {
        boolean bl = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).beforeLicenseStorageLoad(this);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseStorageLoaded(boolean bl) {
        boolean bl2 = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).licenseStorageLoaded(this, bl);
                if (!bl2) continue;
            }
        }
    }

    protected void fireBeforeLicenseStorageSave() {
        boolean bl = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).beforeLicenseStorageSave(this);
                if (!bl) continue;
            }
        }
    }

    protected void fireLicenseStorageSaved(boolean bl) {
        boolean bl2 = z;
        if (this.fLicenseStorageListeners != null) {
            Vector vector = this.fLicenseStorageListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LicenseStorageListener)vector.elementAt(i)).licenseStorageSaved(this, bl);
                if (!bl2) continue;
            }
        }
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean bl) {
        this.fModified = bl;
    }

    public static void updateLicenseEntryProperties(License license, LicenseStorage.LicenseEntry licenseEntry) {
        licenseEntry.setLicenseNumber(license.getLicenseNumber());
        licenseEntry.setProduct(license.getProduct());
        licenseEntry.setProductEdition(license.getProductEdition());
        licenseEntry.setMajorVersion(license.getProductMajorVersion());
        licenseEntry.setMinorVersion(license.getProductMinorVersion());
        licenseEntry.setLicenseType(license.getLicenseType());
        licenseEntry.setUserLicensingModel(license.getUserLicensingModel());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "XOAGLj\u001aNF\u000fnTQJLbI\u0002N\u0000y_CK\u0015+_ZF\u001f\u007fI".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 11;
                                    break;
                                }
                                case 1: {
                                    n8 = 58;
                                    break;
                                }
                                case 2: {
                                    n8 = 34;
                                    break;
                                }
                                case 3: {
                                    n8 = 47;
                                    break;
                                }
                                default: {
                                    n8 = 108;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "GSAJ\u0002x_\u0002J\u0002\u007fH[\u000f\u001bbNJ\u000f\u001f~YJ\u000f\u0002jWG\u000f\u0005x\u001aCC\u001en[FVLnBK\\\u0018x\u0000\u0002".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 11;
                            break;
                        }
                        case 1: {
                            n11 = 58;
                            break;
                        }
                        case 2: {
                            n11 = 34;
                            break;
                        }
                        case 3: {
                            n11 = 47;
                            break;
                        }
                        default: {
                            n11 = 108;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        A = stringArray;
    }

    public static class EntryLicenseReader
    extends LicenseReader {
        protected LicenseStorage.LicenseEntry fLicenseEntry;
        protected String fLicenseEntryName;

        public EntryLicenseReader(LicenseStorage.LicenseEntry licenseEntry, String string) {
            this.fLicenseEntry = licenseEntry;
            this.fLicenseEntryName = string;
        }

        public InputStream getLicenseInputStream() {
            return this.fLicenseEntry.getLicenseBytes() != null ? new ByteArrayInputStream(this.fLicenseEntry.getLicenseBytes()) : null;
        }

        public InputStream getLicenseFileInputStream() {
            return this.getLicenseInputStream();
        }

        public InputStream getLicenseResourceInputStream() {
            return this.getLicenseInputStream();
        }

        public String getLicenseFileLocation() {
            return this.fLicenseEntryName;
        }

        protected void updateLicenseEntryProperties() {
            EntryLicenseReader entryLicenseReader = new EntryLicenseReader(this.fLicenseEntry, this.fLicenseEntryName);
            entryLicenseReader.setSecurityAlgorithm(this.getSecurityAlgorithm());
            entryLicenseReader.setDecryptKeyBytes(this.getDecryptKeyBytes());
            License license = entryLicenseReader.getLicense();
            if (license != null) {
                BasicLicenseStorage.updateLicenseEntryProperties(license, this.fLicenseEntry);
            }
        }

        public OutputStream getLicenseOutputStream() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    EntryLicenseReader.this.fLicenseEntry.setLicenseBytes(this.toByteArray());
                    EntryLicenseReader.this.updateLicenseEntryProperties();
                }
            };
            return byteArrayOutputStream;
        }
    }

    public static class BasicLicenseEntry
    implements LicenseStorage.LicenseEntry,
    Serializable {
        public static final long serialVersionUID = 1L;
        public static final String PROPERTY_LICENSE_BYTES;
        public static final String PROPERTY_LICENSE_TYPE;
        public static final String PROPERTY_LICENSE_NUMBER;
        public static final String PROPERTY_PRODUCT;
        public static final String PROPERTY_PRODUCT_EDITION;
        public static final String PROPERTY_MAJOR_VERSION;
        public static final String PROPERTY_MINOR_VERSION;
        public static final String PROPERTY_USER_LICENSING_MODEL;
        protected transient byte[] fLicenseBytes;
        protected String fLicenseNumber;
        protected int fLicenseType = -1;
        protected String fProduct;
        protected String fProductEdition = LicenseStorage.ANY_PRODUCT_EDITION;
        protected int fMajorVersion = -1;
        protected int fMinorVersion = -1;
        protected int fUserLicensingModel = -1;
        protected transient BasicLicenseStorage fBasicLicenseStorage;
        protected transient PropertyChangeSupport fPropertyChangeSupport;
        protected int fID;

        public int getID() {
            return this.fID;
        }

        public int hashCode() {
            return this.fID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BasicLicenseEntry)) {
                return false;
            }
            return this.fID == ((BasicLicenseEntry)object).fID;
        }

        public BasicLicenseEntry(int n) {
            this.fID = n;
        }

        public BasicLicenseEntry(int n, byte[] byArray, String string) {
            this(n);
            this.fLicenseBytes = byArray;
            this.fProduct = string;
        }

        public BasicLicenseEntry(int n, byte[] byArray, String string, String string2, int n2, int n3, int n4) {
            this(n);
            this.fLicenseBytes = byArray;
            this.fProduct = string;
            this.fProductEdition = string2;
            this.fMajorVersion = n2;
            this.fMinorVersion = n3;
            this.fLicenseType = n4;
        }

        public PropertyChangeSupport getPropertyChangeSupport() {
            if (this.fPropertyChangeSupport == null) {
                this.fPropertyChangeSupport = new PropertyChangeSupport(this);
            }
            return this.fPropertyChangeSupport;
        }

        public BasicLicenseStorage getBasicLicenseStorage() {
            return this.fBasicLicenseStorage;
        }

        protected void setBasicLicenseStorage(BasicLicenseStorage basicLicenseStorage) {
            if (this.fBasicLicenseStorage != null) {
                this.removePropertyChangeListener(this.fBasicLicenseStorage);
            }
            this.fBasicLicenseStorage = basicLicenseStorage;
            if (this.fBasicLicenseStorage != null) {
                this.addPropertyChangeListener(this.fBasicLicenseStorage);
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
            propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public byte[] getLicenseBytes() {
            return this.fLicenseBytes;
        }

        public void setLicenseBytes(byte[] byArray) {
            if (this.fLicenseBytes != byArray) {
                if (this.fBasicLicenseStorage != null) {
                    this.fBasicLicenseStorage.checkLicenseExistence(this, byArray);
                }
                byte[] byArray2 = this.fLicenseBytes;
                this.fLicenseBytes = byArray;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_BYTES, byArray2, this.fLicenseBytes);
            }
        }

        public void setLicenseType(int n) {
            if (this.fLicenseType != n) {
                int n2 = this.fLicenseType;
                this.fLicenseType = n;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_TYPE, n2, this.fLicenseType);
            }
        }

        public void setMajorVersion(int n) {
            if (this.fMajorVersion != n) {
                int n2 = this.fMajorVersion;
                this.fMajorVersion = n;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAJOR_VERSION, n2, this.fMajorVersion);
            }
        }

        public void setMinorVersion(int n) {
            if (this.fMinorVersion != n) {
                int n2 = this.fMinorVersion;
                this.fMinorVersion = n;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MINOR_VERSION, n2, this.fMinorVersion);
            }
        }

        public void setProduct(String string) {
            if (!StringUtils.equals(this.fProduct, string)) {
                String string2 = this.fProduct;
                this.fProduct = string;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PRODUCT, string2, this.fProduct);
            }
        }

        public void setProductEdition(String string) {
            if (!StringUtils.equals(this.fProductEdition, string)) {
                String string2 = this.fProductEdition;
                this.fProductEdition = string;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PRODUCT_EDITION, string2, this.fProductEdition);
            }
        }

        public void setLicenseNumber(String string) {
            if (!StringUtils.equals(this.fLicenseNumber, string)) {
                String string2 = this.fLicenseNumber;
                this.fLicenseNumber = string;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LICENSE_NUMBER, string2, this.fLicenseNumber);
            }
        }

        public void setUserLicensingModel(int n) {
            if (this.fUserLicensingModel != n) {
                int n2 = this.fUserLicensingModel;
                this.fUserLicensingModel = n;
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_USER_LICENSING_MODEL, n2, this.fUserLicensingModel);
            }
        }

        public int getLicenseType() {
            return this.fLicenseType;
        }

        public String getProduct() {
            return this.fProduct;
        }

        public String getProductEdition() {
            return this.fProductEdition;
        }

        public int getMajorVersion() {
            return this.fMajorVersion;
        }

        public int getMinorVersion() {
            return this.fMinorVersion;
        }

        public String getLicenseNumber() {
            return this.fLicenseNumber;
        }

        public int getUserLicensingModel() {
            return this.fUserLicensingModel;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block87: {
                int n;
                int n2;
                char[] cArray2;
                int n3;
                block86: {
                    char[] cArray3;
                    Object var0;
                    block85: {
                        int n4;
                        int n5;
                        char[] cArray4;
                        block84: {
                            char[] cArray5;
                            block83: {
                                int n6;
                                int n7;
                                char[] cArray6;
                                block82: {
                                    char[] cArray7;
                                    block81: {
                                        int n8;
                                        int n9;
                                        char[] cArray8;
                                        block80: {
                                            char[] cArray9;
                                            block79: {
                                                int n10;
                                                int n11;
                                                char[] cArray10;
                                                block78: {
                                                    char[] cArray11;
                                                    block77: {
                                                        int n12;
                                                        int n13;
                                                        char[] cArray12;
                                                        block76: {
                                                            char[] cArray13;
                                                            block75: {
                                                                int n14;
                                                                int n15;
                                                                char[] cArray14;
                                                                block74: {
                                                                    char[] cArray15;
                                                                    block73: {
                                                                        int n16;
                                                                        int n17;
                                                                        char[] cArray16;
                                                                        block72: {
                                                                            var0 = null;
                                                                            char[] cArray17 = "5/\u0016\u0003\u0014*#!\u001f\n<".toCharArray();
                                                                            n3 = 0;
                                                                            int n18 = cArray17.length;
                                                                            cArray16 = cArray17;
                                                                            n17 = n18;
                                                                            if (n18 <= 1) break block72;
                                                                            cArray15 = cArray16;
                                                                            n16 = n17;
                                                                            if (n17 <= n3) break block73;
                                                                        }
                                                                        do {
                                                                            char[] cArray18 = cArray16;
                                                                            char[] cArray19 = cArray16;
                                                                            int n19 = n3;
                                                                            while (true) {
                                                                                int n20;
                                                                                char c = cArray18[n19];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n20 = 89;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n20 = 70;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n20 = 117;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n20 = 102;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n20 = 122;
                                                                                    }
                                                                                }
                                                                                cArray18[n19] = (char)(c ^ n20);
                                                                                ++n3;
                                                                                cArray16 = cArray19;
                                                                                n17 = n17;
                                                                                if (n17 != 0) break;
                                                                                cArray19 = cArray16;
                                                                                n16 = n17;
                                                                                n19 = n17;
                                                                                cArray18 = cArray16;
                                                                            }
                                                                            cArray15 = cArray16;
                                                                            n16 = n17;
                                                                        } while (n17 > n3);
                                                                    }
                                                                    PROPERTY_LICENSE_TYPE = new String(cArray15).intern();
                                                                    var0 = null;
                                                                    char[] cArray20 = ")4\u001a\u0002\u000f:2".toCharArray();
                                                                    n3 = 0;
                                                                    int n21 = cArray20.length;
                                                                    cArray14 = cArray20;
                                                                    n15 = n21;
                                                                    if (n21 <= 1) break block74;
                                                                    cArray13 = cArray14;
                                                                    n14 = n15;
                                                                    if (n15 <= n3) break block75;
                                                                }
                                                                do {
                                                                    char[] cArray21 = cArray14;
                                                                    char[] cArray22 = cArray14;
                                                                    int n22 = n3;
                                                                    while (true) {
                                                                        int n23;
                                                                        char c = cArray21[n22];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n23 = 89;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n23 = 70;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n23 = 117;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n23 = 102;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n23 = 122;
                                                                            }
                                                                        }
                                                                        cArray21[n22] = (char)(c ^ n23);
                                                                        ++n3;
                                                                        cArray14 = cArray22;
                                                                        n15 = n15;
                                                                        if (n15 != 0) break;
                                                                        cArray22 = cArray14;
                                                                        n14 = n15;
                                                                        n22 = n15;
                                                                        cArray21 = cArray14;
                                                                    }
                                                                    cArray13 = cArray14;
                                                                    n14 = n15;
                                                                } while (n15 > n3);
                                                            }
                                                            PROPERTY_PRODUCT = new String(cArray13).intern();
                                                            var0 = null;
                                                            char[] cArray23 = ")4\u001a\u0002\u000f:20\u0002\u0013-/\u001a\b".toCharArray();
                                                            n3 = 0;
                                                            int n24 = cArray23.length;
                                                            cArray12 = cArray23;
                                                            n13 = n24;
                                                            if (n24 <= 1) break block76;
                                                            cArray11 = cArray12;
                                                            n12 = n13;
                                                            if (n13 <= n3) break block77;
                                                        }
                                                        do {
                                                            char[] cArray24 = cArray12;
                                                            char[] cArray25 = cArray12;
                                                            int n25 = n3;
                                                            while (true) {
                                                                int n26;
                                                                char c = cArray24[n25];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n26 = 89;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n26 = 70;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n26 = 117;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n26 = 102;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n26 = 122;
                                                                    }
                                                                }
                                                                cArray24[n25] = (char)(c ^ n26);
                                                                ++n3;
                                                                cArray12 = cArray25;
                                                                n13 = n13;
                                                                if (n13 != 0) break;
                                                                cArray25 = cArray12;
                                                                n12 = n13;
                                                                n25 = n13;
                                                                cArray24 = cArray12;
                                                            }
                                                            cArray11 = cArray12;
                                                            n12 = n13;
                                                        } while (n13 > n3);
                                                    }
                                                    PROPERTY_PRODUCT_EDITION = new String(cArray11).intern();
                                                    var0 = null;
                                                    char[] cArray26 = "4/\u001b\t\b\u000f#\u0007\u0015\u00136(".toCharArray();
                                                    n3 = 0;
                                                    int n27 = cArray26.length;
                                                    cArray10 = cArray26;
                                                    n11 = n27;
                                                    if (n27 <= 1) break block78;
                                                    cArray9 = cArray10;
                                                    n10 = n11;
                                                    if (n11 <= n3) break block79;
                                                }
                                                do {
                                                    char[] cArray27 = cArray10;
                                                    char[] cArray28 = cArray10;
                                                    int n28 = n3;
                                                    while (true) {
                                                        int n29;
                                                        char c = cArray27[n28];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n29 = 89;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n29 = 70;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n29 = 117;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n29 = 102;
                                                                break;
                                                            }
                                                            default: {
                                                                n29 = 122;
                                                            }
                                                        }
                                                        cArray27[n28] = (char)(c ^ n29);
                                                        ++n3;
                                                        cArray10 = cArray28;
                                                        n11 = n11;
                                                        if (n11 != 0) break;
                                                        cArray28 = cArray10;
                                                        n10 = n11;
                                                        n28 = n11;
                                                        cArray27 = cArray10;
                                                    }
                                                    cArray9 = cArray10;
                                                    n10 = n11;
                                                } while (n11 > n3);
                                            }
                                            PROPERTY_MINOR_VERSION = new String(cArray9).intern();
                                            var0 = null;
                                            char[] cArray29 = "5/\u0016\u0003\u0014*#7\u001f\u000e<5".toCharArray();
                                            n3 = 0;
                                            int n30 = cArray29.length;
                                            cArray8 = cArray29;
                                            n9 = n30;
                                            if (n30 <= 1) break block80;
                                            cArray7 = cArray8;
                                            n8 = n9;
                                            if (n9 <= n3) break block81;
                                        }
                                        do {
                                            char[] cArray30 = cArray8;
                                            char[] cArray31 = cArray8;
                                            int n31 = n3;
                                            while (true) {
                                                int n32;
                                                char c = cArray30[n31];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n32 = 89;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n32 = 70;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n32 = 117;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n32 = 102;
                                                        break;
                                                    }
                                                    default: {
                                                        n32 = 122;
                                                    }
                                                }
                                                cArray30[n31] = (char)(c ^ n32);
                                                ++n3;
                                                cArray8 = cArray31;
                                                n9 = n9;
                                                if (n9 != 0) break;
                                                cArray31 = cArray8;
                                                n8 = n9;
                                                n31 = n9;
                                                cArray30 = cArray8;
                                            }
                                            cArray7 = cArray8;
                                            n8 = n9;
                                        } while (n9 > n3);
                                    }
                                    PROPERTY_LICENSE_BYTES = new String(cArray7).intern();
                                    var0 = null;
                                    char[] cArray32 = ",5\u0010\u001460%\u0010\b\t0(\u0012+\u0015=#\u0019".toCharArray();
                                    n3 = 0;
                                    int n33 = cArray32.length;
                                    cArray6 = cArray32;
                                    n7 = n33;
                                    if (n33 <= 1) break block82;
                                    cArray5 = cArray6;
                                    n6 = n7;
                                    if (n7 <= n3) break block83;
                                }
                                do {
                                    char[] cArray33 = cArray6;
                                    char[] cArray34 = cArray6;
                                    int n34 = n3;
                                    while (true) {
                                        int n35;
                                        char c = cArray33[n34];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n35 = 89;
                                                break;
                                            }
                                            case 1: {
                                                n35 = 70;
                                                break;
                                            }
                                            case 2: {
                                                n35 = 117;
                                                break;
                                            }
                                            case 3: {
                                                n35 = 102;
                                                break;
                                            }
                                            default: {
                                                n35 = 122;
                                            }
                                        }
                                        cArray33[n34] = (char)(c ^ n35);
                                        ++n3;
                                        cArray6 = cArray34;
                                        n7 = n7;
                                        if (n7 != 0) break;
                                        cArray34 = cArray6;
                                        n6 = n7;
                                        n34 = n7;
                                        cArray33 = cArray6;
                                    }
                                    cArray5 = cArray6;
                                    n6 = n7;
                                } while (n7 > n3);
                            }
                            PROPERTY_USER_LICENSING_MODEL = new String(cArray5).intern();
                            var0 = null;
                            char[] cArray35 = "5/\u0016\u0003\u0014*#;\u0013\u0017;#\u0007".toCharArray();
                            n3 = 0;
                            int n36 = cArray35.length;
                            cArray4 = cArray35;
                            n5 = n36;
                            if (n36 <= 1) break block84;
                            cArray3 = cArray4;
                            n4 = n5;
                            if (n5 <= n3) break block85;
                        }
                        do {
                            char[] cArray36 = cArray4;
                            char[] cArray37 = cArray4;
                            int n37 = n3;
                            while (true) {
                                int n38;
                                char c = cArray36[n37];
                                switch (n3 % 5) {
                                    case 0: {
                                        n38 = 89;
                                        break;
                                    }
                                    case 1: {
                                        n38 = 70;
                                        break;
                                    }
                                    case 2: {
                                        n38 = 117;
                                        break;
                                    }
                                    case 3: {
                                        n38 = 102;
                                        break;
                                    }
                                    default: {
                                        n38 = 122;
                                    }
                                }
                                cArray36[n37] = (char)(c ^ n38);
                                ++n3;
                                cArray4 = cArray37;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray37 = cArray4;
                                n4 = n5;
                                n37 = n5;
                                cArray36 = cArray4;
                            }
                            cArray3 = cArray4;
                            n4 = n5;
                        } while (n5 > n3);
                    }
                    PROPERTY_LICENSE_NUMBER = new String(cArray3).intern();
                    var0 = null;
                    char[] cArray38 = "4'\u001f\t\b\u000f#\u0007\u0015\u00136(".toCharArray();
                    n3 = 0;
                    int n39 = cArray38.length;
                    cArray2 = cArray38;
                    n2 = n39;
                    if (n39 <= 1) break block86;
                    cArray = cArray2;
                    n = n2;
                    if (n2 <= n3) break block87;
                }
                do {
                    char[] cArray39 = cArray2;
                    char[] cArray40 = cArray2;
                    int n40 = n3;
                    while (true) {
                        int n41;
                        char c = cArray39[n40];
                        switch (n3 % 5) {
                            case 0: {
                                n41 = 89;
                                break;
                            }
                            case 1: {
                                n41 = 70;
                                break;
                            }
                            case 2: {
                                n41 = 117;
                                break;
                            }
                            case 3: {
                                n41 = 102;
                                break;
                            }
                            default: {
                                n41 = 122;
                            }
                        }
                        cArray39[n40] = (char)(c ^ n41);
                        ++n3;
                        cArray2 = cArray40;
                        n2 = n2;
                        if (n2 != 0) break;
                        cArray40 = cArray2;
                        n = n2;
                        n40 = n2;
                        cArray39 = cArray2;
                    }
                    cArray = cArray2;
                    n = n2;
                } while (n2 > n3);
            }
            PROPERTY_MAJOR_VERSION = new String(cArray).intern();
        }
    }
}

