/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.LicenseAdapter;
import com.jp.protection.pub.LicenseReader;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.pro.LicenseHostPro;
import com.jp.protection.pub.pro.lserver.BasicLicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicenseData;
import com.jp.protection.pub.pro.lserver.LicenseDataImpl;
import com.jp.protection.pub.pro.lserver.LicensingService;
import com.jp.protection.pub.pro.lserver.LicensingServiceProvider;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderAdapter;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderFactory;
import com.jp.protection.pub.pro.lserver.LicensingServiceProviderListener;
import com.jp.protection.pub.pro.lserver.LicensingServiceResult;
import com.jp.protection.pub.pro.lserver.LicensingServiceResultImpl;
import dev.net.HttpProxy;
import dev.util.StringUtils;
import java.util.Map;
import java.util.prefs.Preferences;

public class LicensingServiceSupport
extends LicenseAdapter {
    protected LicenseHostPro fLicenseHost;
    protected String fProviderName;
    protected LicensingServiceProvider fLicensingServiceProvider;
    protected LicensingService fLicensingService;
    protected Thread fShutdownHook = new Thread(){

        public void run() {
            LicensingServiceSupport.this.release(true);
        }
    };
    protected String fLicensingServerAddress;
    protected LicensingServiceProviderListener fLicensingServiceProviderListener = new LicensingServiceProviderAdapter(){

        public void licenseLockConfirmed(LicensingServiceProvider licensingServiceProvider, LicensingService licensingService, String string, LicensingServiceResult licensingServiceResult) {
            LicensingServiceSupport.this.fConfirmLockResult = licensingServiceResult;
            switch (LicensingServiceSupport.this.fConfirmLockResult.getResult()) {
                case 4: {
                    LicensingServiceSupport.this.fLicenseHost.fireLicenseLockRevoked(LicensingServiceSupport.this.fLicenseHost, LicensingServiceSupport.this.fLicenseHost.getLicense(), LicensingServiceSupport.this.fConfirmLockResult.getMessage());
                    if (!LicenseHostPro.z) break;
                }
                case 5: {
                    LicensingServiceSupport.this.fLicenseHost.fireLicenseLockExpired(LicensingServiceSupport.this.fLicenseHost, LicensingServiceSupport.this.fLicenseHost.getLicense(), LicensingServiceSupport.this.fConfirmLockResult.getMessage());
                    break;
                }
            }
        }
    };
    protected LicensingServiceResult fObtainLicenseResult;
    protected LicensingServiceResult fLockResult;
    protected LicensingServiceResult fConfirmLockResult;
    protected LicensingServiceResult fUnlockLicenseResult;
    protected boolean fAcquireMACAddress = true;
    protected Preferences fPreferences;
    public static /* synthetic */ boolean z;
    private static final /* synthetic */ String[] A;

    public LicensingServiceSupport(LicenseHostPro licenseHostPro) {
        this.fLicenseHost = licenseHostPro;
        this.fLicenseHost.addLicenseHostListener(this);
    }

    public void licenseAboutToRead(LicenseReader licenseReader, String string) {
        this.release();
    }

    public String getProviderName() {
        return this.fProviderName;
    }

    public void setProviderName(String string) {
        this.fProviderName = string;
    }

    public String getLicensingServerAddress() {
        return this.fLicenseHost.loadSecretStorageProperty(A[0], null);
    }

    public void setLicensingServerAddress(String string) {
        this.fLicenseHost.saveSecretStorageProperty(A[0], string);
    }

    public boolean isLicensingServerAddressKnown() {
        License license = this.fLicenseHost.getLicense();
        return license != null && !StringUtils.noValue(license.getLicensingServerAddress());
    }

    public boolean hasLicensingServiceProvider() {
        return this.fLicensingServiceProvider != null;
    }

    public LicensingServiceProvider createLicensingServiceProvider(String string) {
        return LicensingServiceProviderFactory.getInstance().createProvider(this.fProviderName, string, null);
    }

    public LicensingService createLicensingService(LicensingServiceProvider licensingServiceProvider) {
        return licensingServiceProvider.createLicensingService(this.createAttributes());
    }

    protected LicensingServiceProvider getLicensingServiceProvider() {
        if (this.fLicensingServiceProvider == null) {
            String string;
            String string2 = string = this.fLicenseHost.getLicense() != null ? this.fLicenseHost.getLicense().getLicensingServerAddress() : null;
            if (StringUtils.noValue(string)) {
                string = this.getLicensingServerAddress();
            }
            this.fLicensingServiceProvider = LicensingServiceProviderFactory.getInstance().createProvider(this.fProviderName, string, null);
            Runtime.getRuntime().addShutdownHook(this.fShutdownHook);
            this.fLicensingServiceProvider.addLicensingServiceProviderListener(this.fLicensingServiceProviderListener);
            if (this.fLicensingServiceProvider instanceof BasicLicensingServiceProvider) {
                ((BasicLicensingServiceProvider)this.fLicensingServiceProvider).setConfirmLicenseLocks(true, null);
            }
        }
        return this.fLicensingServiceProvider;
    }

    public LicensingServiceResult getLockResult() {
        return this.fLockResult;
    }

    public LicensingServiceResult getConfirmLockResult() {
        return this.fConfirmLockResult;
    }

    public LicensingServiceResult getObtainLicenseResult() {
        return this.fObtainLicenseResult;
    }

    public void setLockResult(LicensingServiceResult licensingServiceResult) {
        this.fLockResult = licensingServiceResult;
    }

    private LicenseDataImpl.RequestImpl createRequest() {
        LicenseDataImpl.RequestImpl requestImpl = new LicenseDataImpl.RequestImpl();
        License license = this.fLicenseHost.getLicense();
        requestImpl.setLicenseType(license.getLicenseType());
        requestImpl.setLicenseNumber(license.getLicenseNumber());
        requestImpl.setNumberCopies(license.getNumberCopies());
        requestImpl.setProduct(license.getProduct());
        requestImpl.setProductEdition(license.getProductEdition());
        requestImpl.setProductMajorVersion(license.getProductMajorVersion());
        requestImpl.setProductMinorVersion(license.getProductMinorVersion());
        requestImpl.setUserLicensingModel(license.getUserLicensingModel());
        requestImpl.setLicenseOptions(license.getLicenseOptions());
        requestImpl.setLicenseIssueDate(license.getLicenseIssueDate());
        requestImpl.setLicenseExpireInfo(this.fLicenseHost.getLicenseExpireInfo(license));
        return requestImpl;
    }

    public static LicenseData.Request createRequest(ProductInfo productInfo) {
        LicenseDataImpl.RequestImpl requestImpl = new LicenseDataImpl.RequestImpl();
        requestImpl.setLicenseType(3);
        requestImpl.setProduct(productInfo.getID());
        requestImpl.setProductEdition(productInfo.getEdition());
        requestImpl.setProductMajorVersion(productInfo.getMajorVersion());
        requestImpl.setProductMinorVersion(productInfo.getMinorVersion());
        return requestImpl;
    }

    public synchronized boolean lockLicense(boolean bl) {
        boolean bl2;
        boolean bl3 = this.isLockOK();
        boolean bl4 = bl2 = bl3 && !bl;
        if (!bl2) {
            try {
                LicensingService licensingService;
                if (bl3 && bl) {
                    this.unlockLicense();
                }
                if ((licensingService = this.getLicensingService()) != null) {
                    this.fLockResult = licensingService.lockLicense(this.createRequest(), this.createAttributes());
                    this.fConfirmLockResult = null;
                    bl2 = this.fLockResult.getResult() == 1;
                }
            }
            catch (RuntimeException runtimeException) {
                this.fLockResult = LicensingServiceSupport.createResult(runtimeException);
                this.error(runtimeException);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean obtainLicense(String string, ProductInfo productInfo) {
        boolean bl = false;
        LicensingServiceProvider licensingServiceProvider = this.createLicensingServiceProvider(string);
        try {
            LicensingService licensingService = this.createLicensingService(licensingServiceProvider);
            if (licensingService != null) {
                bl = this.obtainLicense(licensingService, productInfo);
            }
        }
        catch (RuntimeException runtimeException) {
            this.fObtainLicenseResult = LicensingServiceSupport.createResult(runtimeException);
            this.error(runtimeException);
        }
        finally {
            if (licensingServiceProvider != null) {
                licensingServiceProvider.release();
            }
        }
        return bl;
    }

    public synchronized boolean obtainLicense(LicensingService licensingService, ProductInfo productInfo) {
        boolean bl = false;
        try {
            this.fObtainLicenseResult = licensingService.getLicense(LicensingServiceSupport.createRequest(productInfo), this.createAttributes());
            bl = this.fObtainLicenseResult.getResult() == 1;
        }
        catch (RuntimeException runtimeException) {
            this.fObtainLicenseResult = LicensingServiceSupport.createResult(runtimeException);
            this.error(runtimeException);
        }
        return bl;
    }

    public byte[] getObtainedLicenseBytes() {
        return this.fObtainLicenseResult != null && this.fObtainLicenseResult.getResult() == 1 ? ((LicensingServiceResult.LicenseResult)this.fObtainLicenseResult).getResponse().getLicenseBytes() : null;
    }

    public static LicensingServiceResult createResult(RuntimeException runtimeException) {
        String string = LicensingServiceSupport.getUserMessage(runtimeException);
        return new LicensingServiceResultImpl(string != null ? 2 : 3, string);
    }

    public synchronized LicensingServiceResult canLockLicense() {
        LicensingServiceResult licensingServiceResult;
        try {
            licensingServiceResult = this.getLicensingService().canLockLicense(this.createRequest(), this.createAttributes());
        }
        catch (RuntimeException runtimeException) {
            licensingServiceResult = LicensingServiceSupport.createResult(runtimeException);
            this.error(runtimeException);
        }
        return licensingServiceResult;
    }

    public boolean isLockOK() {
        boolean bl;
        boolean bl2 = bl = this.fLockResult != null && this.fLockResult.getResult() == 1;
        if (this.fConfirmLockResult != null) {
            bl &= this.fConfirmLockResult.getResult() == 1 || this.fConfirmLockResult.getResult() == 4;
        }
        return bl;
    }

    public boolean isLockRevoked() {
        return this.fConfirmLockResult != null && this.fConfirmLockResult.getResult() == 4;
    }

    public boolean isLockExpired() {
        return this.fConfirmLockResult != null && this.fConfirmLockResult.getResult() == 5;
    }

    public synchronized boolean unlockLicense() {
        block3: {
            if (this.isLockOK()) {
                try {
                    this.fUnlockLicenseResult = this.getLicensingService().unlockLicense(this.fLockResult.getTicket(), this.createAttributes());
                    break block3;
                }
                catch (RuntimeException runtimeException) {
                    this.fUnlockLicenseResult = LicensingServiceSupport.createResult(runtimeException);
                    this.error(runtimeException);
                    if (!LicenseHostPro.z) break block3;
                }
            }
            this.fUnlockLicenseResult = new LicensingServiceResultImpl(3, A[2]);
        }
        this.fLockResult = null;
        this.fConfirmLockResult = null;
        return this.fUnlockLicenseResult.getResult() == 1;
    }

    public LicensingServiceResult getUnlockLicenseResult() {
        return this.fUnlockLicenseResult;
    }

    private Map createAttributes() {
        return this.fLicenseHost.getContext().createAttributes(this.isAcquireMACAddress());
    }

    public boolean isAcquireMACAddress() {
        return this.fAcquireMACAddress;
    }

    public void setAcquireMACAddress(boolean bl) {
        this.fAcquireMACAddress = bl;
    }

    public LicensingService getLicensingService() {
        return this.getLicensingService(false);
    }

    public LicensingService getLicensingService(boolean bl) {
        if (this.fLicensingService == null || bl || this.isHttpProxyChanged()) {
            this.applyHttpProxy();
            LicensingServiceProvider licensingServiceProvider = this.getLicensingServiceProvider();
            this.fLicensingService = this.getLicensingServiceProvider().createLicensingService(this.createAttributes());
        }
        return this.fLicensingService;
    }

    public static String getUserMessage(Throwable throwable) {
        return BasicLicensingServiceProvider.getMessage(throwable);
    }

    protected void error(String string) {
        if (this.fLicenseHost.isVerbose()) {
            System.err.println(string);
        }
    }

    protected void error(Throwable throwable) {
        if (this.fLicenseHost.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    public synchronized void release(boolean bl) {
        block6: {
            try {
                if (this.fLicensingServiceProvider != null) {
                    this.fLicensingServiceProvider.removeLicensingServiceProviderListener(this.fLicensingServiceProviderListener);
                    this.fLicensingServiceProvider.release();
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
            this.fLicensingServiceProvider = null;
            this.fLicensingService = null;
            this.fLockResult = null;
            this.fConfirmLockResult = null;
            if (!bl) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.fShutdownHook);
                    break block6;
                }
                catch (Exception exception) {
                    if (!LicenseHostPro.z) break block6;
                }
            }
            this.fLicenseHost.removeLicenseHostListener(this);
        }
    }

    public void release() {
        this.release(false);
    }

    public Preferences getPreferences() {
        return this.fPreferences;
    }

    public void setPreferences(Preferences preferences) {
        this.fPreferences = preferences;
    }

    protected boolean isHttpProxyChanged() {
        return false;
    }

    protected void applyHttpProxy() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            HttpProxy.applyFromPreferences(preferences.node(A[1]));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block32: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block31: {
                char[] cArray3;
                Object var0;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block29: {
                        char[] cArray5;
                        block28: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block27: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray7 = "\u0014xD\u0012\"\u000bxI\u0010\u001f\u001dcQ\u0012>9uC\u0005)\u000bb".toCharArray();
                                n3 = 0;
                                int n8 = cArray7.length;
                                cArray6 = cArray7;
                                n7 = n8;
                                if (n8 <= 1) break block27;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block28;
                            }
                            do {
                                char[] cArray8 = cArray6;
                                char[] cArray9 = cArray6;
                                int n9 = n3;
                                while (true) {
                                    int n10;
                                    char c = cArray8[n9];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n10 = 120;
                                            break;
                                        }
                                        case 1: {
                                            n10 = 17;
                                            break;
                                        }
                                        case 2: {
                                            n10 = 39;
                                            break;
                                        }
                                        case 3: {
                                            n10 = 119;
                                            break;
                                        }
                                        default: {
                                            n10 = 76;
                                        }
                                    }
                                    cArray8[n9] = (char)(c ^ n10);
                                    ++n3;
                                    cArray6 = cArray9;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray9 = cArray6;
                                    n6 = n7;
                                    n9 = n7;
                                    cArray8 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[0] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray10 = "\u0010eS\u0007\u001c\n~_\u000e".toCharArray();
                        n3 = 0;
                        int n11 = cArray10.length;
                        cArray4 = cArray10;
                        n5 = n11;
                        if (n11 <= 1) break block29;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block30;
                    }
                    do {
                        char[] cArray11 = cArray4;
                        char[] cArray12 = cArray4;
                        int n12 = n3;
                        while (true) {
                            int n13;
                            char c = cArray11[n12];
                            switch (n3 % 5) {
                                case 0: {
                                    n13 = 120;
                                    break;
                                }
                                case 1: {
                                    n13 = 17;
                                    break;
                                }
                                case 2: {
                                    n13 = 39;
                                    break;
                                }
                                case 3: {
                                    n13 = 119;
                                    break;
                                }
                                default: {
                                    n13 = 76;
                                }
                            }
                            cArray11[n12] = (char)(c ^ n13);
                            ++n3;
                            cArray4 = cArray12;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray12 = cArray4;
                            n4 = n5;
                            n12 = n5;
                            cArray11 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[1] = new String(cArray3).intern();
                var0 = null;
                char[] cArray13 = "4xD\u0012\"\u000bt\u0007\u001e?X\u007fH\u0003l\u0014~D\u001c)\u001c".toCharArray();
                n3 = 0;
                int n14 = cArray13.length;
                cArray2 = cArray13;
                n2 = n14;
                if (n14 <= 1) break block31;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block32;
            }
            do {
                char[] cArray14 = cArray2;
                char[] cArray15 = cArray2;
                int n15 = n3;
                while (true) {
                    int n16;
                    char c = cArray14[n15];
                    switch (n3 % 5) {
                        case 0: {
                            n16 = 120;
                            break;
                        }
                        case 1: {
                            n16 = 17;
                            break;
                        }
                        case 2: {
                            n16 = 39;
                            break;
                        }
                        case 3: {
                            n16 = 119;
                            break;
                        }
                        default: {
                            n16 = 76;
                        }
                    }
                    cArray14[n15] = (char)(c ^ n16);
                    ++n3;
                    cArray2 = cArray15;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray15 = cArray2;
                    n = n2;
                    n15 = n2;
                    cArray14 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        A = stringArray;
    }
}

