/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.pro.IntegrityHostPro;
import com.jp.protection.security.SecurityProvider;
import com.jp.protection.security.SecurityProviderFactory;
import com.jp.protection.utils.LicenseUtils;
import dev.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class IntegrityHostProConfigReader {
    protected boolean fVerbose = false;
    protected boolean fSkipEncryption = false;
    protected String fSecurityAlgorithm = z;
    protected byte[] fDecryptKeyBytes;
    protected SecurityProvider fSecurityProvider;
    private static final /* synthetic */ String z;

    protected SecurityProvider getSecurityProvider() {
        if (this.fSecurityProvider == null || !this.fSecurityProvider.getID().equals(this.fSecurityAlgorithm)) {
            this.fSecurityProvider = SecurityProviderFactory.getSecurityProvider(this.fSecurityAlgorithm);
        }
        return this.fSecurityProvider;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String string) {
        this.fSecurityAlgorithm = string;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] byArray) {
        this.fDecryptKeyBytes = byArray;
    }

    public void setDecryptKeyBytes(String string) {
        this.fDecryptKeyBytes = LicenseUtils.toBytes(string);
    }

    public boolean isSkipEncryption() {
        return this.fSkipEncryption;
    }

    public void setSkipEncryption(boolean bl) {
        this.fSkipEncryption = bl;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    private byte[] decode(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (!this.isSkipEncryption()) {
            try {
                SecurityProvider securityProvider = this.getSecurityProvider();
                PublicKey publicKey = securityProvider.getPublicKey(this.fDecryptKeyBytes);
                byArray2 = securityProvider.decode(byArray, publicKey);
            }
            catch (Exception exception) {
                byArray2 = null;
                this.error(exception);
            }
        }
        return byArray2;
    }

    public void read(IntegrityHostPro.Config config, InputStream inputStream) throws IOException {
        this.read(config, StreamUtil.readB(inputStream));
    }

    public void read(IntegrityHostPro.Config config, String string) throws IOException {
        this.read(config, this.getClass().getResourceAsStream(string));
    }

    protected void read(IntegrityHostPro.Config config, byte[] byArray) throws IOException {
        byArray = this.decode(byArray);
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        properties.load(byteArrayInputStream);
        config.load(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IntegrityHostPro.Config config, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.read(config, fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IntegrityHostPro.Config config, File file, String string) throws IOException {
        JarFile jarFile = new JarFile(file);
        try {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                this.read(config, inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            jarFile.close();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = ",\u0006\u0000".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 126;
                            break;
                        }
                        case 1: {
                            n6 = 85;
                            break;
                        }
                        case 2: {
                            n6 = 65;
                            break;
                        }
                        case 3: {
                            n6 = 90;
                            break;
                        }
                        default: {
                            n6 = 47;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
    }
}

