/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.pro;

import com.jp.protection.pub.License;
import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.launch.ProtectionLauncher;
import com.jp.protection.pub.pro.LicenseHostPro;
import java.io.File;

public class BackgroundLicenseCheck {
    protected LicenseHostPro fLicenseHost;
    protected ProductInfo fProductInfo;
    protected boolean fCheckLicense = true;
    protected Thread fCheckLicenseThread;
    protected long fLicenseFileModificationTime;
    protected boolean fLicenseFileCanRead = false;
    protected long fCheckPeriod = 60000L;

    public BackgroundLicenseCheck(LicenseHostPro licenseHostPro, ProductInfo productInfo) {
        this.fLicenseHost = licenseHostPro;
        this.fProductInfo = productInfo;
    }

    public BackgroundLicenseCheck(ProtectionLauncher protectionLauncher) {
        this.fLicenseHost = (LicenseHostPro)protectionLauncher.getLicenseHost();
        this.fProductInfo = protectionLauncher.getProductInfo();
    }

    public boolean isRunning() {
        return this.fCheckLicenseThread != null && this.fCheckLicense;
    }

    public void start() {
        if (!this.isRunning()) {
            this.fCheckLicense = true;
            this.getCheckLicenseThread().start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            if (this.fCheckLicenseThread != null) {
                this.fCheckLicenseThread.interrupt();
            }
            this.fCheckLicense = false;
        }
    }

    public long getCheckPeriod() {
        return this.fCheckPeriod;
    }

    public void setCheckPeriod(long l) {
        this.fCheckPeriod = l;
    }

    protected Thread getCheckLicenseThread() {
        if (this.fCheckLicenseThread == null) {
            this.fCheckLicenseThread = new Thread(){

                public void run() {
                    boolean bl = LicenseHostPro.z;
                    BackgroundLicenseCheck.this.checkLicense();
                    while (BackgroundLicenseCheck.this.fCheckLicense) {
                        try {
                            1.sleep(BackgroundLicenseCheck.this.getCheckPeriod());
                            if (!BackgroundLicenseCheck.this.fCheckLicense) continue;
                            BackgroundLicenseCheck.this.checkLicense();
                        }
                        catch (Exception exception) {
                            if (!bl) continue;
                        }
                    }
                    BackgroundLicenseCheck.this.fCheckLicenseThread = null;
                }
            };
        }
        return this.fCheckLicenseThread;
    }

    public boolean checkLicense() {
        File file = this.fLicenseHost.getLicenseReader().getLicenseFile();
        boolean bl = file.canRead() && file.lastModified() != this.fLicenseFileModificationTime || this.fLicenseFileCanRead != file.canRead();
        return this.checkLicense(bl);
    }

    public boolean checkLicense(boolean bl) {
        boolean bl2 = false;
        this.checkLicenseImpl(bl);
        License license = this.fLicenseHost.getLicense();
        bl2 = license != null && license.getLicenseState() == 2;
        File file = this.fLicenseHost.getLicenseReader().getLicenseFile();
        if (file.canRead()) {
            this.fLicenseFileModificationTime = file.lastModified();
        }
        this.fLicenseFileCanRead = file.canRead();
        return bl2;
    }

    protected void checkLicenseImpl(boolean bl) {
        this.fLicenseHost.checkLicense(this.fProductInfo.getID(), this.fProductInfo.getMajorVersion(), this.fProductInfo.getMinorVersion(), bl);
    }
}

