/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub.launch;

import com.jp.protection.pub.ProductInfo;
import com.jp.protection.pub.SecretStorage;
import com.jp.protection.pub.launch.FacadeConnectionConfig;
import com.jp.protection.pub.launch.LicensingServerConnectionConfig;
import com.jp.protection.pub.launch.ProtectionLauncherConfigBase;
import dev.util.StreamUtil;
import dev.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class ProtectionLauncherConfig
extends ProtectionLauncherConfigBase {
    public static final long serialVersionUID = 1L;
    protected String fSecurityAlgorithm;
    protected byte[] fDecryptKeyBytes;
    protected boolean fProfessional;
    protected ProductInfo fProductInfo;
    protected transient boolean fUseEncryption;
    protected boolean fVerbose;
    private static final byte[] SALT;
    private static final /* synthetic */ String[] A;

    public ProtectionLauncherConfig() {
        this.fProfessional = false;
        this.fUseEncryption = true;
        this.fVerbose = false;
    }

    public ProtectionLauncherConfig(ProtectionLauncherConfigBase protectionLauncherConfigBase) {
        LicensingServerConnectionConfig[] licensingServerConnectionConfigArray;
        FacadeConnectionConfig[] facadeConnectionConfigArray;
        boolean bl = FacadeConnectionConfig.z;
        this.fProfessional = false;
        this.fUseEncryption = true;
        this.fVerbose = false;
        this.fCopyright = protectionLauncherConfigBase.getCopyright();
        this.fCompany = protectionLauncherConfigBase.getCompany();
        this.fCompanyLogo = protectionLauncherConfigBase.getCompanyLogo();
        this.fCompanyLogoRes = protectionLauncherConfigBase.getCompanyLogoRes();
        this.fLicenseFileName = protectionLauncherConfigBase.getLicenseFileName();
        this.fLicenseFolder = protectionLauncherConfigBase.getLicenseFolder();
        this.fLicenseUserHomeRelative = protectionLauncherConfigBase.isLicenseUserHomeRelative();
        this.fLicenseResourceFolder = protectionLauncherConfigBase.getLicenseResourceFolder();
        this.fLicenseTextCommercial = protectionLauncherConfigBase.getLicenseTextCommercial();
        this.fLicenseTextCommercialRes = protectionLauncherConfigBase.getLicenseTextCommercialRes();
        this.fLicenseTextEvaluation = protectionLauncherConfigBase.getLicenseTextEvaluation();
        this.fLicenseTextEvaluationRes = protectionLauncherConfigBase.getLicenseTextEvaluationRes();
        this.fGUI = protectionLauncherConfigBase.isGUI();
        this.fAllowFlexibleExpirationDate = protectionLauncherConfigBase.isAllowFlexibleExpirationDate();
        this.fCheckPreviousShutdownDate = protectionLauncherConfigBase.isCheckPreviousShutdownDate();
        this.fSilentActivation = protectionLauncherConfigBase.isSilentActivation();
        this.fUseStrippedActivationKeyChars = protectionLauncherConfigBase.isUseStrippedActivationKeyChars();
        this.fAcceptLicenseAgreement = protectionLauncherConfigBase.isAcceptLicenseAgreement();
        this.fMaintainPreviousShutdownDate = protectionLauncherConfigBase.isMaintainPreviousShutdownDate();
        this.fActivationLockOptions = protectionLauncherConfigBase.getActivationLockOptions();
        SecretStorage.Provider[] providerArray = protectionLauncherConfigBase.getSecretStorageProviders();
        if (providerArray != null) {
            this.fSecretStorageProviders = new SecretStorage.Provider[providerArray.length];
            for (int i = 0; i < providerArray.length; ++i) {
                this.fSecretStorageProviders[i] = (SecretStorage.Provider)providerArray[i].clone();
                if (!bl) continue;
                boolean bl2 = StringUtils.z = !StringUtils.z;
                break;
            }
        }
        if ((facadeConnectionConfigArray = protectionLauncherConfigBase.getFacadeConnectionConfigs()) != null) {
            this.fFacadeConnectionConfigs = new FacadeConnectionConfig[facadeConnectionConfigArray.length];
            for (int i = 0; i < facadeConnectionConfigArray.length; ++i) {
                this.fFacadeConnectionConfigs[i] = (FacadeConnectionConfig)facadeConnectionConfigArray[i].clone();
                if (!bl) continue;
            }
        }
        if ((licensingServerConnectionConfigArray = protectionLauncherConfigBase.getLicensingServerConnectionConfigs()) != null) {
            this.fLicensingServerConnectionConfigs = new LicensingServerConnectionConfig[licensingServerConnectionConfigArray.length];
            for (int i = 0; i < licensingServerConnectionConfigArray.length; ++i) {
                this.fLicensingServerConnectionConfigs[i] = (LicensingServerConnectionConfig)licensingServerConnectionConfigArray[i].clone();
                if (!bl) continue;
            }
        }
        this.fLicensingWizardLogo = protectionLauncherConfigBase.getLicensingWizardLogo();
        this.fLicensingWizardLogoRes = protectionLauncherConfigBase.getLicensingWizardLogoRes();
        this.fLicensingWizardOptions = protectionLauncherConfigBase.getLicensingWizardOptions();
        this.fActivationWizardLogo = protectionLauncherConfigBase.getActivationWizardLogo();
        this.fActivationWizardLogoRes = protectionLauncherConfigBase.getActivationWizardLogoRes();
        this.fActivationWizardOptions = protectionLauncherConfigBase.getActivationWizardOptions();
        this.fDeactivationWizardLogo = protectionLauncherConfigBase.getDeactivationWizardLogo();
        this.fDeactivationWizardLogoRes = protectionLauncherConfigBase.getDeactivationWizardLogoRes();
        this.fDeactivationWizardOptions = protectionLauncherConfigBase.getDeactivationWizardOptions();
        this.fLicenseLockWizardLogo = protectionLauncherConfigBase.getLicenseLockWizardLogo();
        this.fLicenseLockWizardLogoRes = protectionLauncherConfigBase.getLicenseLockWizardLogoRes();
        this.fLicenseLockWizardOptions = protectionLauncherConfigBase.getLicenseLockWizardOptions();
    }

    public ProductInfo getProductInfo() {
        return this.fProductInfo;
    }

    public void setProductInfo(ProductInfo productInfo) {
        this.fProductInfo = productInfo;
    }

    public boolean isProfessional() {
        return this.fProfessional;
    }

    public void setProfessional(boolean bl) {
        this.fProfessional = bl;
    }

    public byte[] getDecryptKeyBytes() {
        return this.fDecryptKeyBytes;
    }

    public void setDecryptKeyBytes(byte[] byArray) {
        this.fDecryptKeyBytes = byArray;
    }

    public String getSecurityAlgorithm() {
        return this.fSecurityAlgorithm;
    }

    public void setSecurityAlgorithm(String string) {
        this.fSecurityAlgorithm = string;
    }

    public boolean isUseEncryption() {
        return this.fUseEncryption;
    }

    public void setUseEncryption(boolean bl) {
        this.fUseEncryption = bl;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    public static ProtectionLauncherConfig loadDecrypted(InputStream inputStream) throws IOException {
        ProtectionLauncherConfig protectionLauncherConfig = ProtectionLauncherConfig.load(StreamUtil.getDecryptedInputStream(inputStream, ProtectionLauncherConfig.getCipher(false)));
        protectionLauncherConfig.setUseEncryption(true);
        return protectionLauncherConfig;
    }

    protected static Cipher getCipher(boolean bl) {
        try {
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(SALT, 20);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(A[1].toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(A[0]);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            Cipher cipher = Cipher.getInstance(A[0]);
            cipher.init(bl ? 1 : 2, (Key)secretKey, pBEParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ProtectionLauncherConfig load(InputStream inputStream) throws IOException {
        ProtectionLauncherConfig protectionLauncherConfig = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            protectionLauncherConfig = (ProtectionLauncherConfig)objectInputStream.readObject();
            protectionLauncherConfig.setUseEncryption(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        finally {
            objectInputStream.close();
        }
        return protectionLauncherConfig;
    }

    public static void storeEncrypted(ProtectionLauncherConfig protectionLauncherConfig, OutputStream outputStream) throws IOException {
        ProtectionLauncherConfig.store(protectionLauncherConfig, StreamUtil.getEncryptedOutputStream(outputStream, ProtectionLauncherConfig.getCipher(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(ProtectionLauncherConfig protectionLauncherConfig, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        try {
            objectOutputStream.writeObject(protectionLauncherConfig);
        }
        finally {
            objectOutputStream.close();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "%\u0003ay\u0010\u0001)ijL4/@j<&".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 117;
                                    break;
                                }
                                case 1: {
                                    n8 = 65;
                                    break;
                                }
                                case 2: {
                                    n8 = 36;
                                    break;
                                }
                                case 3: {
                                    n8 = 46;
                                    break;
                                }
                                default: {
                                    n8 = 121;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "&*\u001e\u001e_8~\u0015p\u0007\u0002\u0011Bq\u0015$}`e\u0000\u0003\u0003".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 117;
                            break;
                        }
                        case 1: {
                            n11 = 65;
                            break;
                        }
                        case 2: {
                            n11 = 36;
                            break;
                        }
                        case 3: {
                            n11 = 46;
                            break;
                        }
                        default: {
                            n11 = 121;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        A = stringArray;
        SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    }
}

