/*
 * Decompiled with CFR 0.152.
 */
package com.jp.protection.pub;

import com.jp.protection.pub.LicenseHost;
import com.jp.protection.utils.CustomCRC32;
import com.jp.protection.utils.CustomMessageDigest;
import dev.util.StreamUtil;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class IntegrityHost {
    protected String[] fDigestEntries;
    protected long fCRC = -1L;
    public static final int ALGORITHM_CRC32 = 1;
    public static final int ALGORITHM_SHA_1 = 2;
    public static final int ALGORITHM_MD5 = 3;
    public static final int ALGORITHM_DEFAULT = 1;
    protected Digest fDigest;
    protected int fAlgorithm = -1;
    protected byte[] fDigestBytes;
    protected static final String WEB_INF;
    protected boolean fVerbose = false;
    protected byte[] fCheckDigest;
    public static /* synthetic */ int z;
    private static final /* synthetic */ String[] A;

    public IntegrityHost(String[] stringArray, long l) {
        this();
        this.fDigestEntries = stringArray;
        this.fCRC = l;
        this.fCheckDigest = IntegrityHost.calculateDigest(this.fCRC);
    }

    public IntegrityHost(String[] stringArray, byte[] byArray) {
        this();
        this.fDigestEntries = stringArray;
        this.fCheckDigest = byArray;
    }

    public IntegrityHost() {
        this.setAlgorithm(1);
    }

    public int getAlgorithm() {
        return this.fAlgorithm;
    }

    public static String getAlgorithmStr(int n) {
        String string = null;
        switch (n) {
            case 2: {
                string = A[3];
                break;
            }
            case 3: {
                string = A[2];
                break;
            }
            case 1: {
                string = A[5];
            }
        }
        return string;
    }

    public void setAlgorithm(int n) {
        boolean bl = LicenseHost.z;
        if (this.fAlgorithm != n) {
            this.fAlgorithm = n;
            switch (this.fAlgorithm) {
                case 1: {
                    this.fDigest = new CRC32Digest();
                    if (!bl) break;
                }
                case 2: {
                    this.fDigest = new MessageDigest(A[3]);
                    if (!bl) break;
                }
                case 3: {
                    this.fDigest = new MessageDigest(A[2]);
                    if (!bl) break;
                }
                default: {
                    throw new IllegalArgumentException(A[1] + n);
                }
            }
        }
    }

    public long getCRC() {
        return this.fCRC;
    }

    public void setCRC(long l) {
        this.fCRC = l;
        IntegrityHost.calculateDigest(this.fCRC);
    }

    public String[] getCRCEntries() {
        return this.fDigestEntries;
    }

    public String[] getDigestEntries() {
        return this.fDigestEntries;
    }

    public void setCRCEntries(String[] stringArray) {
        this.fDigestEntries = stringArray;
    }

    public void setDigestEntries(String[] stringArray) {
        this.fDigestEntries = stringArray;
    }

    public boolean check() {
        return this.check(this.fDigestEntries, this.fCheckDigest);
    }

    public static boolean checkStatic(String[] stringArray, long l) {
        return new IntegrityHost().check(stringArray, l);
    }

    public static boolean checkStatic(String[] stringArray, byte[] byArray, int n) {
        IntegrityHost integrityHost = new IntegrityHost();
        integrityHost.setAlgorithm(n);
        return integrityHost.check(stringArray, byArray);
    }

    public static boolean checkStatic(String[] stringArray, byte[] byArray) {
        return IntegrityHost.checkStatic(stringArray, byArray, 1);
    }

    protected boolean check(String[] stringArray, long l) {
        return this.check(stringArray, IntegrityHost.calculateDigest(l));
    }

    protected boolean check(String[] stringArray, byte[] byArray) {
        this.calculateDigest(stringArray);
        return Arrays.equals(this.getDigest(), byArray);
    }

    public void resetDigest() {
        this.fDigestBytes = null;
        this.fDigest.reset();
    }

    public void updateDigest(byte[] byArray) {
        this.fDigest.update(byArray);
    }

    public byte[] getDigest() {
        if (this.fDigestBytes == null) {
            this.fDigestBytes = this.fDigest.getDigest();
        }
        return this.fDigestBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateDigest(String[] stringArray) {
        boolean bl = LicenseHost.z;
        this.resetDigest();
        if (stringArray != null && stringArray.length > 0) {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    InputStream inputStream = this.getEntryStream(string);
                    if (inputStream != null) {
                        try {
                            this.updateDigest(StreamUtil.readB(inputStream));
                        }
                        finally {
                            inputStream.close();
                        }
                        if (!bl) continue;
                    }
                    this.error(A[0] + string);
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
    }

    protected long calculate(byte[] byArray) {
        CustomCRC32 customCRC32 = new CustomCRC32();
        customCRC32.reset();
        customCRC32.proceed(byArray);
        return customCRC32.getCRC();
    }

    protected InputStream getEntryStream(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.startsWith(WEB_INF)) {
            string = string.substring(WEB_INF.length(), string.length());
        }
        return this.getClass().getResourceAsStream(string);
    }

    public static String toResourceName(Class clazz) {
        return clazz.getName().replace('.', '/') + A[4];
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean bl) {
        this.fVerbose = bl;
    }

    protected void error(String string) {
        if (this.isVerbose()) {
            System.err.println(string);
        }
    }

    protected void error(Throwable throwable) {
        if (this.isVerbose()) {
            throwable.printStackTrace();
        }
    }

    public byte[] getCheckDigest() {
        return this.fCheckDigest;
    }

    public void setCheckDigest(byte[] byArray) {
        this.fCheckDigest = byArray;
    }

    protected static byte[] calculateDigest(long l) {
        return BigInteger.valueOf(l).toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block76: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block75: {
                char[] cArray3;
                Object var0;
                block74: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block73: {
                        char[] cArray5;
                        block72: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block71: {
                                char[] cArray7;
                                block70: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block69: {
                                        char[] cArray9;
                                        block68: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block67: {
                                                char[] cArray11;
                                                block66: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block65: {
                                                        char[] cArray13;
                                                        block64: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block63: {
                                                                stringArray = new String[6];
                                                                var0 = null;
                                                                char[] cArray15 = "`[\u0019t\u007f\u0006B\u001a\u00191#m/E7<".toCharArray();
                                                                n3 = 0;
                                                                int n16 = cArray15.length;
                                                                cArray14 = cArray15;
                                                                n15 = n16;
                                                                if (n16 <= 1) break block63;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block64;
                                                            }
                                                            do {
                                                                char[] cArray16 = cArray14;
                                                                char[] cArray17 = cArray14;
                                                                int n17 = n3;
                                                                while (true) {
                                                                    int n18;
                                                                    char c = cArray16[n17];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n18 = 79;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n18 = 12;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n18 = 92;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n18 = 54;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n18 = 82;
                                                                        }
                                                                    }
                                                                    cArray16[n17] = (char)(c ^ n18);
                                                                    ++n3;
                                                                    cArray14 = cArray17;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray17 = cArray14;
                                                                    n14 = n15;
                                                                    n17 = n15;
                                                                    cArray16 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        WEB_INF = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray18 = "\u001ab=T>*,(Yr(i(\u00166&k9E&oi2B 66|".toCharArray();
                                                        n3 = 0;
                                                        int n19 = cArray18.length;
                                                        cArray12 = cArray18;
                                                        n13 = n19;
                                                        if (n19 <= 1) break block65;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block66;
                                                    }
                                                    do {
                                                        char[] cArray19 = cArray12;
                                                        char[] cArray20 = cArray12;
                                                        int n20 = n3;
                                                        while (true) {
                                                            int n21;
                                                            char c = cArray19[n20];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n21 = 79;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n21 = 12;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n21 = 92;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n21 = 54;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n21 = 82;
                                                                }
                                                            }
                                                            cArray19[n20] = (char)(c ^ n21);
                                                            ++n3;
                                                            cArray12 = cArray20;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray20 = cArray12;
                                                            n12 = n13;
                                                            n20 = n13;
                                                            cArray19 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[0] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray21 = "\u0006b*W>&h|W>(c._&'af\u0016".toCharArray();
                                                n3 = 0;
                                                int n22 = cArray21.length;
                                                cArray10 = cArray21;
                                                n11 = n22;
                                                if (n22 <= 1) break block67;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block68;
                                            }
                                            do {
                                                char[] cArray22 = cArray10;
                                                char[] cArray23 = cArray10;
                                                int n23 = n3;
                                                while (true) {
                                                    int n24;
                                                    char c = cArray22[n23];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n24 = 79;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n24 = 12;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n24 = 92;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n24 = 54;
                                                            break;
                                                        }
                                                        default: {
                                                            n24 = 82;
                                                        }
                                                    }
                                                    cArray22[n23] = (char)(c ^ n24);
                                                    ++n3;
                                                    cArray10 = cArray23;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray23 = cArray10;
                                                    n10 = n11;
                                                    n23 = n11;
                                                    cArray22 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[1] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray24 = "\u0002Hi".toCharArray();
                                        n3 = 0;
                                        int n25 = cArray24.length;
                                        cArray8 = cArray24;
                                        n9 = n25;
                                        if (n25 <= 1) break block69;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block70;
                                    }
                                    do {
                                        char[] cArray25 = cArray8;
                                        char[] cArray26 = cArray8;
                                        int n26 = n3;
                                        while (true) {
                                            int n27;
                                            char c = cArray25[n26];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n27 = 79;
                                                    break;
                                                }
                                                case 1: {
                                                    n27 = 12;
                                                    break;
                                                }
                                                case 2: {
                                                    n27 = 92;
                                                    break;
                                                }
                                                case 3: {
                                                    n27 = 54;
                                                    break;
                                                }
                                                default: {
                                                    n27 = 82;
                                                }
                                            }
                                            cArray25[n26] = (char)(c ^ n27);
                                            ++n3;
                                            cArray8 = cArray26;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray26 = cArray8;
                                            n8 = n9;
                                            n26 = n9;
                                            cArray25 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[2] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray27 = "\u001cD\u001d\u001bc".toCharArray();
                                n3 = 0;
                                int n28 = cArray27.length;
                                cArray6 = cArray27;
                                n7 = n28;
                                if (n28 <= 1) break block71;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block72;
                            }
                            do {
                                char[] cArray28 = cArray6;
                                char[] cArray29 = cArray6;
                                int n29 = n3;
                                while (true) {
                                    int n30;
                                    char c = cArray28[n29];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n30 = 79;
                                            break;
                                        }
                                        case 1: {
                                            n30 = 12;
                                            break;
                                        }
                                        case 2: {
                                            n30 = 92;
                                            break;
                                        }
                                        case 3: {
                                            n30 = 54;
                                            break;
                                        }
                                        default: {
                                            n30 = 82;
                                        }
                                    }
                                    cArray28[n29] = (char)(c ^ n30);
                                    ++n3;
                                    cArray6 = cArray29;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray29 = cArray6;
                                    n6 = n7;
                                    n29 = n7;
                                    cArray28 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[3] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray30 = "ao0W!<".toCharArray();
                        n3 = 0;
                        int n31 = cArray30.length;
                        cArray4 = cArray30;
                        n5 = n31;
                        if (n31 <= 1) break block73;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block74;
                    }
                    do {
                        char[] cArray31 = cArray4;
                        char[] cArray32 = cArray4;
                        int n32 = n3;
                        while (true) {
                            int n33;
                            char c = cArray31[n32];
                            switch (n3 % 5) {
                                case 0: {
                                    n33 = 79;
                                    break;
                                }
                                case 1: {
                                    n33 = 12;
                                    break;
                                }
                                case 2: {
                                    n33 = 92;
                                    break;
                                }
                                case 3: {
                                    n33 = 54;
                                    break;
                                }
                                default: {
                                    n33 = 82;
                                }
                            }
                            cArray31[n32] = (char)(c ^ n33);
                            ++n3;
                            cArray4 = cArray32;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray32 = cArray4;
                            n4 = n5;
                            n32 = n5;
                            cArray31 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[4] = new String(cArray3).intern();
                var0 = null;
                char[] cArray33 = "\f^\u001f\u0005`".toCharArray();
                n3 = 0;
                int n34 = cArray33.length;
                cArray2 = cArray33;
                n2 = n34;
                if (n34 <= 1) break block75;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block76;
            }
            do {
                char[] cArray34 = cArray2;
                char[] cArray35 = cArray2;
                int n35 = n3;
                while (true) {
                    int n36;
                    char c = cArray34[n35];
                    switch (n3 % 5) {
                        case 0: {
                            n36 = 79;
                            break;
                        }
                        case 1: {
                            n36 = 12;
                            break;
                        }
                        case 2: {
                            n36 = 92;
                            break;
                        }
                        case 3: {
                            n36 = 54;
                            break;
                        }
                        default: {
                            n36 = 82;
                        }
                    }
                    cArray34[n35] = (char)(c ^ n36);
                    ++n3;
                    cArray2 = cArray35;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray35 = cArray2;
                    n = n2;
                    n35 = n2;
                    cArray34 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[5] = new String(cArray).intern();
        A = stringArray;
    }

    protected static class MessageDigest
    implements Digest {
        protected CustomMessageDigest fMessageDigest;

        public MessageDigest(String string) {
            this.fMessageDigest = CustomMessageDigest.getInstance(string);
        }

        public void reset() {
            this.fMessageDigest.reset();
        }

        public void update(byte[] byArray) {
            this.fMessageDigest.update(byArray);
        }

        public byte[] getDigest() {
            return this.fMessageDigest.getDigest();
        }
    }

    protected static class CRC32Digest
    implements Digest {
        private CustomCRC32 fCustomCRC32 = new CustomCRC32();

        protected CRC32Digest() {
        }

        public void reset() {
            this.fCustomCRC32.reset();
        }

        public void update(byte[] byArray) {
            this.fCustomCRC32.proceed(byArray);
        }

        public byte[] getDigest() {
            return IntegrityHost.calculateDigest(this.fCustomCRC32.getCRC());
        }
    }

    protected static interface Digest {
        public void reset();

        public void update(byte[] var1);

        public byte[] getDigest();
    }
}

