#!/bin/sh

set -e

case $(uname) in
Darwin) platform=macos;;
Linux)  platform=linux;;
*) echo "Unknown platform: $(uname)"; exit 1;;
esac

case $(uname -m) in
x86_64)        architecture=x64;;
aarch64|arm64) architecture=arm64;;
*) echo "Unknown architecture: $(uname -m)" >&2; exit 2;;
esac

root=$(cd "$(dirname "$0")"; pwd)
dotnet="$root/$platform-$architecture/dotnet"

# Unblock files when downloaded in Safari
if [ "x$platform" = "xmacos" ] && xattr "$dotnet" | grep -q com.apple.quarantine; then
  xattr -d -r com.apple.quarantine "$dotnet"
fi

exec "$dotnet/dotnet" "$@"
