/*
 * Decompiled with CFR 0.152.
 */
package com.rover12421.asm.optimizer;

import com.rover12421.asm.AnnotationVisitor;
import com.rover12421.asm.Type;
import com.rover12421.asm.optimizer.ConstantPool;

public class AnnotationConstantsCollector
extends AnnotationVisitor {
    private final ConstantPool cp;

    public AnnotationConstantsCollector(AnnotationVisitor av, ConstantPool cp) {
        super(327680, av);
        this.cp = cp;
    }

    @Override
    public void visit(String name, Object value) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        if (value instanceof Byte) {
            this.cp.newInteger(((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            this.cp.newInteger((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            this.cp.newInteger(((Character)value).charValue());
        } else if (value instanceof Short) {
            this.cp.newInteger(((Short)value).shortValue());
        } else if (value instanceof Type) {
            this.cp.newUTF8(((Type)value).getDescriptor());
        } else if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i] ? 1 : 0);
            }
        } else if (value instanceof short[]) {
            short[] v = (short[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value instanceof char[]) {
            char[] v = (char[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newLong(v[i]);
            }
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newFloat(v[i]);
            }
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newDouble(v[i]);
            }
        } else {
            this.cp.newConst(value);
        }
        this.av.visit(name, value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        this.cp.newUTF8(desc);
        this.cp.newUTF8(value);
        this.av.visitEnum(name, desc, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        this.cp.newUTF8(desc);
        return new AnnotationConstantsCollector(this.av.visitAnnotation(name, desc), this.cp);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        return new AnnotationConstantsCollector(this.av.visitArray(name), this.cp);
    }

    @Override
    public void visitEnd() {
        this.av.visitEnd();
    }
}

