agf_highp float;

agf_highp sampler2D;
//agf_include "core_vertex.glsl"

//agf_include "main_vertex2fragment.glsl"


uniform agf_highp mat4 modelViewProj;
uniform agf_highp mat4 modelView;
uniform agf_highp mat4 modelViewIT;
uniform agf_highp vec3 normalMultiplier;

void main()
	{
		agf_highp vec4 vPosition =		AGFVS_VERTEX();
		agf_highp vec4 vNormal =			AGFVS_NORMAL();
		agf_highp vec4 vTexCoord0 =		AGFVS_UVW();
		agf_highp vec4 vFaceTangent =		AGFVS_TANGENT();
		agf_highp vec4 vFaceBinormal =	AGFVS_BINORMAL();
		agf_highp vec4 vColor =			AGFVS_COLOR();

	#ifdef GPU_SKINNING
        if (agf_bonecount > 0)
            {
            vPosition = SkinVertex(vPosition);
			vNormal = SkinDirection(vNormal);
			vFaceTangent = SkinDirection(vFaceTangent);
			vFaceBinormal = SkinDirection(vFaceBinormal);
            }
	#endif

		vertOut_fClipPosition = modelViewProj * vPosition;
		agf_highp vec4 normalVecMesh = vNormal;
		normalVecMesh.w = 0.0;
		agf_highp vec4 normalVecEye = modelViewIT*normalVecMesh;
		agf_highp vec3 normalVecEye3 = vec3(normalVecEye.x, normalVecEye.y, normalVecEye.z);
		agf_highp vec3 normalVecEyeNormalized = normalize(normalVecEye3);
		
		agf_highp vec3 normalVec = normalVecEyeNormalized * normalMultiplier; //To flip the normal if necessary

		vertOut_fTexCoord0.xy = vTexCoord0.xy;
		vertOut_fTexCoord0.z = 0.0;
		vertOut_fTexCoord0.w = 1.0;

		vertOut_n = normalVec;
		vertOut_t = (normalize(modelViewIT*vFaceTangent)).xyz;
		vertOut_b = (normalize(modelViewIT*vFaceBinormal)).xyz;

		vertOut_vNormal = normalVec;
		vertOut_vEye = (modelView*vPosition).xyz;
		vertOut_vPosition = (modelView*vPosition).xyz;

		vertOut_Color = vColor.xyz;
        #ifdef Y_FLIP_CAMERA
            vertOut_fClipPosition.y =-1.0*vertOut_fClipPosition.y;
		#endif
        gl_Position = vertOut_fClipPosition;
	}
