
//agf_include "main_shared_functions_fragment.glsl"

//agf_include "main_vertex2fragment.glsl"


#ifdef ENABLE_AGFDiffuseMap
uniform agf_highp sampler2D	diffuse_texture;
uniform agf_highp mat4		diffuse_texture_matrix;
#endif
uniform agf_highp vec4 constantColor;
uniform agf_highp vec4 clippingPlane;
uniform agf_highp vec4 extraReflectionClippingPlane;
uniform agf_highp vec4 refraction_flag;
uniform agf_highp vec4 useVertexForBase;
uniform Material	material;
void main()
{
		agf_highp vec4 UV = vertOut_fTexCoord0;
        agf_highp vec3 materialBaseColor = material.Kd.rgb;
		if (useVertexForBase[0]>0.5)
			{
			materialBaseColor = vertOut_Color.rgb; //Show Repair Color
			}
        agf_highp vec3 materialDiffuseColor = materialBaseColor;
        agf_highp float materialDiffuseOpacity = 1.0;
		agf_highp vec4 texLookup = vec4(0.0, 0.0, 0.0, 0.0); //Temporary variable, to use in all the texture Lookups
#ifdef ENABLE_AGFDiffuseMap
		texLookup = xformTex2D(diffuse_texture, UV, diffuse_texture_matrix);
        if (useVertexForBase[1]>0.5) //The fRenderStatePtr->currentRenderSettings.blendUnlitWithBaseValue is passed here
            {
            materialDiffuseColor = mix(materialBaseColor, texLookup.rgb, texLookup.a);
            }
        else
            {
            materialDiffuseColor = texLookup.rgb;
            materialDiffuseOpacity = texLookup.a;
            }
#endif
		agf_highp vec4 finalColor;
        finalColor.rgb = materialDiffuseColor.rgb;
        finalColor.a = materialDiffuseOpacity;

//########################################## CLIPPING PLANES ################################################################################		

		agf_highp float clipSign = dot(clippingPlane.xyz, vertOut_vPosition.xyz)+clippingPlane.w;
		if (clipSign < 0.0) discard;

		agf_highp float extraClipSign = dot(extraReflectionClippingPlane.xyz, vertOut_vPosition.xyz)+extraReflectionClippingPlane.w;
		if (extraClipSign < 0.0) discard;

//########################################## FINAL PROCESSING ################################################################################		

		if (finalColor.a == 0.0) discard;

#ifdef ENABLE_ALPHA_PREMULTIPLY
        if (useVertexForBase[1]>0.5) //The fRenderStatePtr->currentRenderSettings.blendUnlitWithBaseValue is passed here
            {
            finalColor.rgb = finalColor.rgb*finalColor.a;
            }
#endif


	gl_FragColor = finalColor;
}
