## Generator Core [![Build Status](https://travis-ci.org/adobe-photoshop/generator-core.png?branch=master)](https://travis-ci.org/adobe-photoshop/generator-core)

Generator is a JavaScript-based extensibility technology which first shipped in Adobe Photoshop CC v14.1. This repository contains Generator Core, a Node.js library that handles communication between Photoshop and Generator Plug-ins.

### Status

Generator Core is under active development. Thorough documentation, example plug-ins, and tutorials are coming soon. In the mean time, please refer to these resources:

* [Generator Architecture](https://github.com/adobe-photoshop/generator-core/wiki/Generator-Architecture) -- A wiki page that describes the current overall architecture of Generator.
* [Generator API Changes](https://github.com/adobe-photoshop/generator-core/wiki/API-Changes) -- A wiki page that describes changes and additions to the Generator Core API over time. 
* [Image Asset Generation Plug-in](https://github.com/adobe-photoshop/generator-assets) -- A Generator Plug-in that helps users export image assets from their Photoshop files.
* [List of (known) Generator Plug-ins](https://github.com/adobe-photoshop/generator-core/wiki/Generator-Plug-ins)

### Developing Generator Plug-ins

* Learn how to [setup the Generator development environment](https://github.com/adobe-photoshop/generator-core/wiki/Generator-Development-Environment-Setup)
* Script your [first Adobe Generator plugin for Photoshop](http://tomkrcha.com/?p=3896)
* Experiment with a [sample plug-in](https://github.com/adobe-photoshop/generator-getting-started/)
* Get your Generator development questions answered at the [Adobe-Generator-Dev Google group](https://groups.google.com/forum/#!forum/adobe-generator-dev)
* Follow [@AdobeGenerator](https://twitter.com/AdobeGenerator) on Twitter for more updates
* We :heart: pull requests! If you submit one, please also sign our [Contributor License Agreement](https://secure.echosign.com/public/hostedForm?formid=8IWLQL2I3V7F6R)

### License

(MIT License)

Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
