/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

"use strict";

var os = require("os"),
    fs = require("fs");

var CommonConfiguration = require("./CommonConfiguration");

var PLATFORM_WINDOWS_32     = "win32",
    PLATFORM_WINDOWS_64     = "win64",
    PLATFORM_OSX10          = "darwin";

var OSX_PATH                = "/tmp/com.adobe.preview.pipe",
    WINDOWS_PATH            = "\\\\?\\pipe\\com.adobe.preview.pipe";

var enabled                 = CommonConfiguration.useNamedPipes;

function getPath() {
    switch (os.platform()) {
    case PLATFORM_WINDOWS_32:
    case PLATFORM_WINDOWS_64:
        return WINDOWS_PATH;
    case PLATFORM_OSX10:
        return OSX_PATH;
    default:
        throw new Error("platform unexpected");
    }
}

function reset() {
    if (enabled && os.platform() === PLATFORM_OSX10 && fs.existsSync(getPath())) {
        fs.unlinkSync(getPath());
    }
}

function shutdown() {
    reset();
}

function init() {
    reset();
}

exports.enabled  = enabled;
exports.init     = init;
exports.getPath  = getPath;
exports.shutdown = shutdown;
